/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.gui.edit;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithCommentSupplement;
import com.arcway.planagent.planeditor.base.edit.PEPlanElementWithOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planeditor.base.inputinterpreter.EPEditNameOnPlanElement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPDeleteCommentTextOnSupplement;
import com.arcway.planagent.planeditor.cm.inputinterpreter.EPEditCommentTextOnSupplement;
import com.arcway.planagent.planeditor.edit.PEFigure;
import com.arcway.planagent.planeditor.edit.PEGraphicalSupplement;
import com.arcway.planagent.planeditor.edit.PEPlanObject;
import com.arcway.planagent.planeditor.gui.edit.PEGraphicalSupplementGUIRadioButtonActive;
import com.arcway.planagent.planeditor.handles.HandlePointDiagonal;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.handles.IHandleLine;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;

public class PEPlanElementGUIRadioButton
extends PEPlanElementWithOutlineAndNameAndDescriptionSupplement
implements IPEPlanElementWithCommentSupplement {
    private static final double DEFAULT_COMMENT_WIDTH = 30.0;
    private static final double DEFAULT_NAME_WIDTH = 40.0;

    protected void createEditPolicies() {
        super.createEditPolicies();
        switch (this.getPEPlan().getMode()) {
            case 1: {
                this.installEditPolicy("planelement_edit_role", (EditPolicy)new EPEditNameOnPlanElement());
                this.installEditPolicy("commentsupplement_edit_role", (EditPolicy)new EPEditCommentTextOnSupplement());
                this.installEditPolicy("DELETE_COMMENT_ROLE", (EditPolicy)new EPDeleteCommentTextOnSupplement());
                break;
            }
            case 3: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public PEFigure getEditFigure() {
        return this.getOutlineFigure();
    }

    public Points getDefaultCommentArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Point lowerRight = bounds.lowerRight;
        double height = bounds.h();
        Points geometry = new Points();
        geometry.add(lowerRight);
        geometry.add(new Point(lowerRight.x, lowerRight.y + height));
        geometry.add(new Point(lowerRight.x + 30.0, lowerRight.y + height));
        geometry.add(new Point(lowerRight.x + 30.0, lowerRight.y));
        return geometry;
    }

    public Points getDefaultNameSupplementTextArea() {
        Rectangle bounds = this.getPMPlanElementFMCWithOutline().getOutlineFigureRO().getPointListRO().getPoints().getBounds();
        Point lowerRight = bounds.lowerRight;
        double height = bounds.h();
        Points geometry = new Points();
        geometry.add(lowerRight);
        geometry.add(new Point(lowerRight.x, lowerRight.y - height));
        geometry.add(new Point(lowerRight.x + 40.0, lowerRight.y - height));
        geometry.add(new Point(lowerRight.x + 40.0, lowerRight.y));
        return geometry;
    }

    protected boolean isGraphicalSupplementSelectable(PEGraphicalSupplement graphicalSupplement) {
        if (graphicalSupplement instanceof PEGraphicalSupplementGUIRadioButtonActive) {
            return false;
        }
        return super.isGraphicalSupplementSelectable(graphicalSupplement);
    }

    public boolean provideAppearancesFor(PEPlanObject child) {
        if (child instanceof PEGraphicalSupplementGUIRadioButtonActive) {
            return true;
        }
        return super.provideAppearancesFor(child);
    }

    public List<IHandleLine> getLineHandles() {
        return Collections.emptyList();
    }

    public List<IHandle> getPointHandlesFor(PEPlanObject child) {
        List handles = super.getPointHandlesFor(child);
        int i = 0;
        while (i < child.getPMPointList().getPointCount()) {
            HandlePointDiagonal handlePoint = new HandlePointDiagonal((EditPart)child, this.getPEPlan().getViewMgr(), this.getFeedbackManager(), child.getPMPointList().getPointRO(i), 1);
            handles.add(handlePoint);
            ++i;
        }
        return handles;
    }
}

