/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.planeditor.actions.AppearanceUtil;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.actions.MenuContributionItem;
import com.arcway.planagent.planeditor.actions.UIChangeAppearanceAction;
import com.arcway.planagent.planeditor.cm.actions.TextAlignmentDecoration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class CITextAlignmment
extends MenuContributionItem {
    private static final String action_id_textalign_top_left = "com.arcway.cockpitplanagent.editor.actions.textalignment.1.top.left";
    private static final String action_id_textalign_top_center = "com.arcway.cockpitplanagent.editor.actions.textalignment.2.top.center";
    private static final String action_id_textalign_top_right = "com.arcway.cockpitplanagent.editor.actions.textalignment.3.top.right";
    private static final String action_id_textalign_separator_1 = "com.arcway.cockpitplanagent.editor.actions.textalignment.4.1.separator";
    private static final String action_id_textalign_mid_left = "com.arcway.cockpitplanagent.editor.actions.textalignment.4.mid.left";
    private static final String action_id_textalign_mid_center = "com.arcway.cockpitplanagent.editor.actions.textalignment.5.mid.center";
    private static final String action_id_textalign_mid_right = "com.arcway.cockpitplanagent.editor.actions.textalignment.6.mid.right";
    private static final String action_id_textalign_separator_2 = "com.arcway.cockpitplanagent.editor.actions.textalignment.7.1.separator";
    private static final String action_id_textalign_bottom_left = "com.arcway.cockpitplanagent.editor.actions.textalignment.7.bottom.left";
    private static final String action_id_textalign_bottom_center = "com.arcway.cockpitplanagent.editor.actions.textalignment.8.bottom.center";
    private static final String action_id_textalign_bottom_right = "com.arcway.cockpitplanagent.editor.actions.textalignment.9.bottom.right";
    private static final String postfixStringSeparator = ".separator";
    private static final Map<String, Alignment> alignmentMaps = new HashMap<String, Alignment>();
    private static ArrayList<String> sortedIDList;
    private static final IAppearanceButtonDecoration buttonType;
    public static final Alignment initAlignment;

    static {
        alignmentMaps.put(action_id_textalign_top_left, new Alignment(1, 8));
        alignmentMaps.put(action_id_textalign_top_center, new Alignment(2, 8));
        alignmentMaps.put(action_id_textalign_top_right, new Alignment(4, 8));
        alignmentMaps.put(action_id_textalign_separator_1, new Alignment());
        alignmentMaps.put(action_id_textalign_mid_left, new Alignment(1, 16));
        alignmentMaps.put(action_id_textalign_mid_center, new Alignment(2, 16));
        alignmentMaps.put(action_id_textalign_mid_right, new Alignment(4, 16));
        alignmentMaps.put(action_id_textalign_separator_2, new Alignment());
        alignmentMaps.put(action_id_textalign_bottom_left, new Alignment(1, 32));
        alignmentMaps.put(action_id_textalign_bottom_center, new Alignment(2, 32));
        alignmentMaps.put(action_id_textalign_bottom_right, new Alignment(4, 32));
        sortedIDList = new ArrayList();
        Set<String> alignmentIDList = alignmentMaps.keySet();
        ArrayList<String> idList = new ArrayList<String>(alignmentIDList);
        Collections.sort(idList);
        sortedIDList = idList;
        buttonType = TextAlignmentDecoration.getInstance();
        initAlignment = new Alignment();
    }

    public CITextAlignmment() {
    }

    public CITextAlignmment(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected IAppearanceButtonDecoration getButtonType() {
        return buttonType;
    }

    private List<IContributionItem> constructContributionItem() {
        IWorkbenchPage workbenchPage = this.getWorkbenchPage();
        AppearanceUtil.SelectionInfoProvider currentSelectionInfoOrNull = this.getCurrentSelectionInfoOrNull();
        boolean enabled = this.isActionEnabled(currentSelectionInfoOrNull, initAlignment);
        ArrayList selectedStates = this.getSelectedStates(currentSelectionInfoOrNull);
        ArrayList<IContributionItem> items = new ArrayList<IContributionItem>();
        for (String actionID : sortedIDList) {
            if (actionID.endsWith(postfixStringSeparator)) {
                items.add((IContributionItem)new Separator());
                continue;
            }
            Alignment alignment = alignmentMaps.get(actionID);
            String alignmentName = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryText((Object)alignment);
            UIChangeAppearanceAction action = new UIChangeAppearanceAction(workbenchPage, actionID, alignmentName, (Object)alignment, buttonType);
            ImageDescriptor imageDescriptor = ((IAppearanceButtonDecorationWithMenu)buttonType).getMenuEntryImage((Object)alignment);
            action.setImageDescriptor(imageDescriptor);
            action.setEnabled(enabled);
            boolean checked = false;
            if (enabled) {
                checked = this.isActionChecked(alignment, selectedStates);
            }
            action.setChecked(checked);
            items.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
        return items;
    }

    private boolean isActionChecked(Alignment alignment, ArrayList<Object> selectedStates) {
        boolean checked = false;
        for (Object state : selectedStates) {
            Alignment selectedAlignment;
            if (state instanceof Alignment && (checked = alignment.equalsAlignment(selectedAlignment = (Alignment)state))) break;
        }
        return checked;
    }

    protected IContributionItem[] getContributionItems() {
        List<IContributionItem> items = this.constructContributionItem();
        IContributionItem[] colorItems = items.toArray(new IContributionItem[items.size()]);
        return colorItems;
    }
}

