/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.actions;

import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.base.Messages;
import com.arcway.planagent.planeditor.base.actions.UIAbstractWithOptionalShadowAction;
import com.arcway.planagent.planeditor.base.commands.CMRemoveShadow;
import com.arcway.planagent.planeditor.base.edit.IPEPlanElementWithOptionalShadow;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOptionalShadowRO;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class UIRemoveShadow
extends UIAbstractWithOptionalShadowAction {
    private static final String ID = "de.plans.fmca.planagent.planeditor.fmc.bd.actions.uiremoveshadow";
    private String commandText;

    public UIRemoveShadow(ContextMenuContext context) {
        super(context);
        this.updateLabels();
        this.setId(ID);
    }

    private void updateLabels() {
        IPEPlanElementWithOptionalShadow planElement = this.getSelectedPEPlanElementWithOptionalShadow();
        if (planElement != null) {
            this.setText(planElement.getRemoveShadowActionText());
            this.setToolTipText(planElement.getRemoveShadowActionTooltipText());
            this.commandText = planElement.getRemoveShadowCommandText();
        } else {
            this.setText(Messages.getString("UIRemoveShadow.Remove_Shadow"));
            this.setToolTipText(Messages.getString("UIRemoveShadow.Removes_Shadow"));
        }
    }

    @Override
    protected boolean calculateEnabled() {
        IPMPlanElementWithOptionalShadowRO channel;
        boolean toReturn = false;
        if (super.calculateEnabled() && !(channel = this.getSelectedPlanElementWithOptionalShadow()).getShadowFigures().isEmpty()) {
            toReturn = true;
        }
        return toReturn;
    }

    protected Command getCommand(List<PEPlanElement> items) {
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty()) {
            IPMPlanElementWithOptionalShadowRO channel = this.getSelectedPlanElementWithOptionalShadow(items);
            return new CMRemoveShadow(channel, super.getCommandContext(), this.commandText);
        }
        return null;
    }

    protected boolean isVisibleIfDisabled() {
        return false;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }
}

