/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.lib.projections.AbstractProjection;

public class DimensionedProgressBarProjection
extends AbstractProjection {
    private static final double ORIGIN_OFFSET_X = 5.0;
    private static final double ORIGIN_OFFSET_Y = 5.0;
    private static final double SPACING_X = 8.0;
    private static final double SPACING_Y = 2.0;
    private static final Alignment TEXT_IN_BAR_ALIGNMENT = new Alignment(2, 16);
    private static final Alignment LABEL_ALIGNMENT = new Alignment(4, 16);
    private final double textAreaMinWidth;
    private final double axisAreaHeight;
    private final Color axisColor;
    private final double axisLength;
    private final Color axisBorderColor;
    private final Color axisLabelColor;
    private final TextStyle axisLabelTextStyle;
    private final String axisLabelText;
    private final FillColor barPartLeftFillColor;
    private final Color barPartLeftTextColor;
    private final TextStyle barPartLeftTextStyle;
    private final String barPartLeftText;
    private final double barPartLeftLength;
    private final FillColor barPartRightFillColor;
    private final Color barPartRightTextColor;
    private final TextStyle barPartRightTextStyle;
    private final String barPartRightText;
    private final double barPartRigthLength;
    private final Color barBorderColor;
    private final Color barLabelColor;
    private final TextStyle barLabelTextStyle;
    private final String barLabelText;
    final double barAreaWidth;
    final double barAreaHeight;
    final Rectangle barPartLeftArea;
    final Rectangle barPartRightArea;
    final double axisLabelTextHeight;
    final double barLabelTextHeight;
    final double axisLengthInPixels;
    final double barPartLeftLengthInPixels;
    final double barPartRightLengthInPixels;
    final Rectangle barTextArea;
    final Rectangle axisArea;
    final Rectangle axisTextArea;

    public DimensionedProgressBarProjection(double barAreaWidth, double textAreaMinWidth, double barAreaHeight, double axisAreaHeight, Color axisColor, double axisLength, Color axisBorderColor, Color axisLabelColor, TextStyle axisLabelTextStyle, String axisLabelText, FillColor barPartLeftFillColor, Color barPartLeftTextColor, TextStyle barPartLeftTextStyle, String barPartLeftText, double barPartLeftLength, FillColor barPartRightFillColor, Color barPartRightTextColor, TextStyle barPartRightTextStyle, String barPartRightText, double barPartRigthLength, Color barBorderColor, Color barLabelColor, TextStyle barLabelTextStyle, String barLabelText) {
        double textAreaWidth;
        double spacingWidth;
        double spacingHeight;
        double axisAreaHeightCalculated = axisAreaHeight;
        this.barAreaWidth = barAreaWidth;
        this.barAreaHeight = barAreaHeight;
        this.textAreaMinWidth = textAreaMinWidth;
        this.axisAreaHeight = axisAreaHeightCalculated;
        this.axisColor = axisColor;
        this.axisLength = axisLength;
        this.axisBorderColor = axisBorderColor;
        this.axisLabelColor = axisLabelColor;
        this.axisLabelTextStyle = axisLabelTextStyle;
        this.axisLabelText = axisLabelText;
        this.barPartLeftFillColor = barPartLeftFillColor;
        this.barPartLeftTextColor = barPartLeftTextColor;
        this.barPartLeftTextStyle = barPartLeftTextStyle;
        this.barPartLeftText = barPartLeftText;
        this.barPartLeftLength = barPartLeftLength;
        this.barPartRightFillColor = barPartRightFillColor;
        this.barPartRightTextColor = barPartRightTextColor;
        this.barPartRightTextStyle = barPartRightTextStyle;
        this.barPartRightText = barPartRightText;
        this.barPartRigthLength = barPartRigthLength;
        this.barBorderColor = barBorderColor;
        this.barLabelColor = barLabelColor;
        this.barLabelTextStyle = barLabelTextStyle;
        this.barLabelText = barLabelText;
        AbstractProjection.VirtualDevice device = new AbstractProjection.VirtualDevice();
        if (this.hasAxisAreas()) {
            spacingHeight = 2.0;
            axisAreaHeightCalculated = this.axisAreaHeight;
        } else {
            spacingHeight = 0.0;
            axisAreaHeightCalculated = 0.0;
        }
        this.axisLabelTextHeight = axisAreaHeightCalculated;
        this.barLabelTextHeight = barAreaHeight;
        if (this.hasTextAreas()) {
            double axisLabelLength = this.hasAxisAreas() ? device.getTextLength(axisLabelText, axisLabelTextStyle, this.axisLabelTextHeight) : 0.0;
            double barLabelLength = device.getTextLength(barLabelText, barLabelTextStyle, this.barLabelTextHeight);
            spacingWidth = 8.0;
            textAreaWidth = Math.max(this.textAreaMinWidth, Math.max(axisLabelLength, barLabelLength));
        } else {
            spacingWidth = 0.0;
            textAreaWidth = 0.0;
        }
        device.dispose();
        double axisLengthInLU = this.axisLength;
        double barPartLeftLengthInLU = this.barPartLeftLength;
        double barPartRightLengthInLU = this.barPartRigthLength;
        double barLengthInLU = barPartLeftLengthInLU + barPartRightLengthInLU;
        double maxLengthInLU = Math.max(axisLengthInLU, barLengthInLU);
        double pixelsPerLU = Geo.equals((double)0.0, (double)maxLengthInLU) ? 0.0 : barAreaWidth / maxLengthInLU;
        this.axisLengthInPixels = axisLengthInLU * pixelsPerLU;
        this.barPartLeftLengthInPixels = barPartLeftLengthInLU * pixelsPerLU;
        this.barPartRightLengthInPixels = barPartRightLengthInLU * pixelsPerLU;
        double projectionWidth = barAreaWidth + spacingWidth + textAreaWidth;
        if (this.hasAxisAreas()) {
            this.axisArea = new Rectangle(-projectionWidth, 0.0, -projectionWidth + barAreaWidth, axisAreaHeightCalculated);
            this.axisTextArea = this.hasTextAreas() ? new Rectangle(-textAreaWidth, 0.0, 0.0, axisAreaHeightCalculated) : null;
        } else {
            this.axisArea = null;
            this.axisTextArea = null;
        }
        Rectangle barArea = new Rectangle(-projectionWidth, axisAreaHeightCalculated + spacingHeight, -projectionWidth + barAreaWidth, axisAreaHeightCalculated + spacingHeight + barAreaHeight);
        this.barPartLeftArea = new Rectangle(barArea.upperLeft.x, barArea.upperLeft.y, barArea.upperLeft.x + this.barPartLeftLengthInPixels, barArea.lowerRight.y);
        this.barPartRightArea = new Rectangle(this.barPartLeftArea.lowerRight.x, barArea.upperLeft.y, this.barPartLeftArea.lowerRight.x + this.barPartRightLengthInPixels, barArea.lowerRight.y);
        this.barTextArea = this.hasTextAreas() ? new Rectangle(-textAreaWidth, axisAreaHeightCalculated + spacingHeight, 0.0, axisAreaHeightCalculated + spacingHeight + barAreaHeight) : null;
    }

    public double getBarAreaWidth() {
        return this.barAreaWidth;
    }

    public double getTextAreaMinWidth() {
        return this.textAreaMinWidth;
    }

    public double getBarAreaHeight() {
        return this.barAreaHeight;
    }

    public double getAxisAreaHeight() {
        return this.axisAreaHeight;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public Color getAxisBorderColor() {
        return this.axisBorderColor;
    }

    public Color getAxisLabelColor() {
        return this.axisLabelColor;
    }

    public TextStyle getAxisLabelTextStyle() {
        return this.axisLabelTextStyle;
    }

    public String getAxisLabelText() {
        return this.axisLabelText;
    }

    public FillColor getBarPartLeftFillColor() {
        return this.barPartLeftFillColor;
    }

    public Color getBarPartLeftTextColor() {
        return this.barPartLeftTextColor;
    }

    public TextStyle getBarPartLeftTextStyle() {
        return this.barPartLeftTextStyle;
    }

    public String getBarPartLeftText() {
        return this.barPartLeftText;
    }

    public double getBarPartLeftLength() {
        return this.barPartLeftLength;
    }

    public FillColor getBarPartRightFillColor() {
        return this.barPartRightFillColor;
    }

    public Color getBarPartRightTextColor() {
        return this.barPartRightTextColor;
    }

    public TextStyle getBarPartRightTextStyle() {
        return this.barPartRightTextStyle;
    }

    public String getBarPartRightText() {
        return this.barPartRightText;
    }

    public double getBarPartRightLength() {
        return this.barPartRigthLength;
    }

    public Color getBarBorderColor() {
        return this.barBorderColor;
    }

    public Color getBarLabelColor() {
        return this.barLabelColor;
    }

    public TextStyle getBarLabelTextStyle() {
        return this.barLabelTextStyle;
    }

    public String getBarLabelText() {
        return this.barLabelText;
    }

    @Override
    public String getProjectionTypeID() {
        return "dimensionedProgressBar";
    }

    @Override
    protected Point getPositionInPixels(Rectangle area) {
        return new Point(area.lowerRight.x - 5.0, area.upperLeft.y + 5.0);
    }

    @Override
    protected void drawProjectionInPixels(Device device) {
        double barPartLeftTextLenght;
        double barPartRightTextLenght;
        device.polygon(this.barPartRightArea.toCorners(0.0), this.barPartRightFillColor, FillStyle.SOLID, 1.0, this.barBorderColor, LineStyle.SOLID);
        device.polygon(this.barPartLeftArea.toCorners(0.0), this.barPartLeftFillColor, FillStyle.SOLID, 1.0, this.barBorderColor, LineStyle.SOLID);
        if (this.hasPartRightLabel() && (barPartRightTextLenght = device.getTextLength(this.barPartRightText, this.barPartRightTextStyle, this.barLabelTextHeight)) < this.barPartRightLengthInPixels) {
            device.text(this.barPartRightArea, TEXT_IN_BAR_ALIGNMENT, this.barPartRightText, this.barPartRightTextStyle, this.barLabelTextHeight, this.barPartRightTextColor, false);
        }
        if (this.hasPartLeftLabel() && (barPartLeftTextLenght = device.getTextLength(this.barPartLeftText, this.barPartLeftTextStyle, this.barLabelTextHeight)) < this.barPartLeftLengthInPixels) {
            device.text(this.barPartLeftArea, TEXT_IN_BAR_ALIGNMENT, this.barPartLeftText, this.barPartLeftTextStyle, this.barLabelTextHeight, this.barPartLeftTextColor, false);
        }
        if (this.hasAxis()) {
            double xStart = this.axisArea.upperLeft.x;
            double xEnd = xStart + this.axisLengthInPixels;
            Rectangle axis = new Rectangle(xStart, this.axisArea.upperLeft.y, xEnd, this.axisArea.lowerRight.y);
            device.polygon(axis.toCorners(0.0), new FillColor(this.axisColor), FillStyle.SOLID, 1.0, this.axisBorderColor, LineStyle.SOLID);
        }
        if (this.hasBarLabel()) {
            device.text(this.barTextArea, LABEL_ALIGNMENT, this.barLabelText, this.barLabelTextStyle, this.barLabelTextHeight, this.barLabelColor, false);
        }
        if (this.hasAxisLabel()) {
            device.text(this.axisTextArea, LABEL_ALIGNMENT, this.axisLabelText, this.axisLabelTextStyle, this.axisLabelTextHeight, this.axisLabelColor, false);
        }
    }

    private boolean hasAxisAreas() {
        return this.hasAxis() || this.hasAxisLabel();
    }

    private boolean hasAxis() {
        return this.axisColor != null;
    }

    private boolean hasTextAreas() {
        return this.hasBarLabel() || this.hasAxisLabel();
    }

    private boolean hasBarLabel() {
        return this.barLabelText != null;
    }

    private boolean hasAxisLabel() {
        return this.axisLabelText != null;
    }

    private boolean hasPartLeftLabel() {
        return this.barPartLeftText != null;
    }

    private boolean hasPartRightLabel() {
        return this.barPartRightText != null;
    }
}

