/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.AbstractFundamentalSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISetRW_;
import java.util.Map;

public abstract class AbstractSet_<T>
extends AbstractFundamentalSet_<T>
implements ISetRW_<T> {
    private final Map<MapKey, T> javaMap;
    private final IHasher_<? super T> keyHasher;

    protected AbstractSet_(Map<MapKey, T> javaMap, IHasher_<? super T> hasher) {
        assert (Assert.checkArgumentBeeingNotNull(javaMap));
        assert (Assert.checkArgumentBeeingNotNull(hasher));
        this.javaMap = javaMap;
        this.keyHasher = hasher;
    }

    @Override
    protected final Map<MapKey, T> getJavaMap() {
        return this.javaMap;
    }

    protected final IHasher_<? super T> getKeyHasher() {
        return this.keyHasher;
    }

    @Override
    protected final MapKey createMapKey(T object) {
        return new MapKey(object);
    }

    @Override
    public T replace(T object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        Object key = this.createMapKey((Object)object);
        return this.getJavaMap().put((MapKey)key, object);
    }

    protected final class MapKey {
        final T wrappedObject;

        protected MapKey(T object) {
            assert (Assert.checkArgumentBeeingNotNull(object));
            this.wrappedObject = object;
        }

        public boolean equals(Object mapKeyToBeCompared) {
            assert (Assert.checkArgumentBeeingNotNull(mapKeyToBeCompared));
            assert (Assert.checkObjectArgumentToBeInstanceOf(mapKeyToBeCompared, MapKey.class));
            return AbstractSet_.this.getKeyHasher().isEqual(this.wrappedObject, ((MapKey)mapKeyToBeCompared).wrappedObject);
        }

        public int hashCode() {
            return AbstractSet_.this.getKeyHasher().getHashCode(this.wrappedObject);
        }
    }
}

