/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataURLConnection
extends URLConnection {
    private final String contentType;
    private final String content;

    public DataURLConnection(URL url) {
        super(url);
        String encodingAndContent;
        String urlString = url.toExternalForm();
        String urlStringWithoutProtocol = urlString.substring(5);
        int semicolonIndex = urlStringWithoutProtocol.indexOf(";");
        if (semicolonIndex != -1) {
            this.contentType = urlStringWithoutProtocol.substring(0, semicolonIndex);
            encodingAndContent = urlStringWithoutProtocol.substring(semicolonIndex + 1);
        } else {
            this.contentType = null;
            encodingAndContent = urlStringWithoutProtocol;
        }
        this.content = encodingAndContent.startsWith("base64,") ? encodingAndContent.substring(7) : encodingAndContent;
    }

    @Override
    public boolean getAllowUserInteraction() {
        return false;
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public String getHeaderField(int n) {
        if (n == 0 && this.contentType != null) {
            return this.contentType;
        }
        return null;
    }

    @Override
    public String getHeaderField(String name) {
        if (name.equals("content-type") && this.contentType != null) {
            return this.contentType;
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int n) {
        if (n == 0 && this.contentType != null) {
            return "content-type";
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        if (this.contentType != null) {
            return Collections.singletonMap("content-type", Collections.singletonList(this.contentType));
        }
        return Collections.emptyMap();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content.getBytes());
    }

    @Override
    public void connect() throws IOException {
    }
}

