/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.xml;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.IXMLElementRO;
import com.arcway.lib.codec.xml.IXMLItemRO;
import com.arcway.lib.codec.xml.PrimitiveXMLElement;
import com.arcway.lib.codec.xml.XMLAttribute;
import com.arcway.lib.codec.xml.XMLCharacters;
import com.arcway.lib.codec.xml.XMLElementName;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;

public class XMLElementROForDataSaving
implements IXMLElementRO {
    private static final IList_<XMLAttribute> ATTRIBUTES_OF_NULL_ELEMENT;
    private static final IList_<XMLAttribute> ATTRIBUTES_OF_NON_NULL_ELEMENT;
    private final XMLElementName xmlElementName;
    private final IDataType dataType;
    private final Object data;

    static {
        ArrayList_<boolean> attributesRW = new ArrayList_<boolean>(true);
        attributesRW.add((boolean)XMLCoDecForData.NULL_ATTRIBUTE);
        ATTRIBUTES_OF_NULL_ELEMENT = attributesRW;
        attributesRW = new ArrayList_<boolean>(false);
        ATTRIBUTES_OF_NON_NULL_ELEMENT = attributesRW;
    }

    public XMLElementROForDataSaving(String name, String namespace, IDataType dataType, Object data) {
        Assert.checkArgumentBeeingNotNull(name);
        Assert.checkStringToBeNotEmpty(name);
        Assert.checkArgumentBeeingNotNull(dataType);
        this.xmlElementName = new XMLElementName(namespace, name);
        this.dataType = dataType;
        this.data = data;
    }

    @Override
    public XMLElementName getElementName() {
        return this.xmlElementName;
    }

    @Override
    public IList_<XMLAttribute> getAttributes() {
        IList_<XMLAttribute> attributes = this.dataType.isNull(this.data) ? ATTRIBUTES_OF_NULL_ELEMENT : ATTRIBUTES_OF_NON_NULL_ELEMENT;
        return attributes;
    }

    @Override
    public IList_<IXMLItemRO> getChildItems() {
        ArrayList_<IXMLItemRO> childItems = new ArrayList_<IXMLItemRO>();
        if (!this.dataType.isNull(this.data)) {
            Class<? extends IDataType> type = this.dataType.getStructureType();
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)this.dataType.getConcreteDataType();
                String valueAsString = elementaryDataType.getValueAsString(this.data);
                XMLCharacters xmlItem = new XMLCharacters(valueAsString);
                childItems.add(xmlItem);
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)this.dataType.getConcreteDataType();
                IList_<IKey> flagAndPropertyAndChildRoles = structuredDataType.getFlagAndPropertyAndChildRoles(this.data);
                for (IKey flagOrPropertyOrChildRole : flagAndPropertyAndChildRoles) {
                    SubDataType flagOrPropertyOrChildSubDataType = structuredDataType.getSubDataType(flagOrPropertyOrChildRole);
                    if (flagOrPropertyOrChildSubDataType.isFlag()) {
                        boolean flag = structuredDataType.isSet(this.data, flagOrPropertyOrChildRole);
                        if (!flag) continue;
                        PrimitiveXMLElement xmlItem = new PrimitiveXMLElement(new XMLElementName(this.xmlElementName.getNameSpace(), flagOrPropertyOrChildRole.toCanonicalString()));
                        childItems.add(xmlItem);
                        continue;
                    }
                    IDataType propertyOrChildDataType = structuredDataType.getDataTypeOfPropertyOrChildren(this.data, flagOrPropertyOrChildRole);
                    if (flagOrPropertyOrChildSubDataType.isProperty()) {
                        Object property = structuredDataType.getProperty(this.data, flagOrPropertyOrChildRole);
                        XMLElementROForDataSaving xMLElementROForDataSaving = new XMLElementROForDataSaving(flagOrPropertyOrChildRole.toCanonicalString(), this.xmlElementName.getNameSpace(), propertyOrChildDataType, property);
                        childItems.add(xMLElementROForDataSaving);
                        continue;
                    }
                    if (flagOrPropertyOrChildSubDataType.isChild()) {
                        IList_<? extends Object> children = structuredDataType.getChildren(this.data, flagOrPropertyOrChildRole);
                        for (Object e : children) {
                            XMLElementROForDataSaving xmlItem = new XMLElementROForDataSaving(flagOrPropertyOrChildRole.toCanonicalString(), this.xmlElementName.getNameSpace(), propertyOrChildDataType, e);
                            childItems.add(xmlItem);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
        return childItems;
    }
}

