/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AbsPathChecker;
import org.apache.xalan.templates.ElemForEach;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.ElemVariablePsuedo;
import org.apache.xalan.templates.RedundentExprEliminator;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.VarNameCollector;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.FilterExprIteratorSimple;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.operations.VariableSafeAbsRef;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class RedundentExprEliminator
extends XSLTVisitor {
    Vector m_paths = null;
    Vector m_absPaths;
    boolean m_isSameContext = true;
    AbsPathChecker m_absPathChecker = new AbsPathChecker();
    private static int m_uniquePseudoVarID = 1;
    static final String PSUEDOVARNAMESPACE = "http://xml.apache.org/xalan/psuedovar";
    public static final boolean DEBUG = false;
    public static final boolean DIAGNOSE_NUM_PATHS_REDUCED = false;
    public static final boolean DIAGNOSE_MULTISTEPLIST = false;
    VarNameCollector m_varNameCollector = new VarNameCollector();

    public RedundentExprEliminator() {
        this.m_absPaths = new Vector();
    }

    public void eleminateRedundentLocals(ElemTemplateElement psuedoVarRecipient) {
        this.eleminateRedundent(psuedoVarRecipient, this.m_paths);
    }

    public void eleminateRedundentGlobals(StylesheetRoot stylesheet) {
        this.eleminateRedundent((ElemTemplateElement)stylesheet, this.m_absPaths);
    }

    protected void eleminateRedundent(ElemTemplateElement psuedoVarRecipient, Vector paths) {
        int n = paths.size();
        int numPathsEliminated = 0;
        int numUniquePathsEliminated = 0;
        int i = 0;
        while (i < n) {
            ExpressionOwner owner = (ExpressionOwner)paths.elementAt(i);
            if (null != owner) {
                int found = this.findAndEliminateRedundant(i + 1, i, owner, psuedoVarRecipient, paths);
                if (found > 0) {
                    ++numUniquePathsEliminated;
                }
                numPathsEliminated += found;
            }
            ++i;
        }
        this.eleminateSharedPartialPaths(psuedoVarRecipient, paths);
    }

    protected void eleminateSharedPartialPaths(ElemTemplateElement psuedoVarRecipient, Vector paths) {
        MultistepExprHolder list = this.createMultistepExprList(paths);
        if (null != list) {
            boolean isGlobal = paths == this.m_absPaths;
            int longestStepsCount = list.m_stepCount;
            int i = longestStepsCount - 1;
            while (i >= 1) {
                MultistepExprHolder next = list;
                while (null != next) {
                    if (next.m_stepCount < i) break;
                    list = this.matchAndEliminatePartialPaths(next, list, isGlobal, i, psuedoVarRecipient);
                    next = next.m_next;
                }
                --i;
            }
        }
    }

    protected MultistepExprHolder matchAndEliminatePartialPaths(MultistepExprHolder testee, MultistepExprHolder head, boolean isGlobal, int lengthToTest, ElemTemplateElement varScope) {
        if (null == testee.m_exprOwner) {
            return head;
        }
        WalkingIterator iter1 = (WalkingIterator)testee.m_exprOwner.getExpression();
        if (this.partialIsVariable(testee, lengthToTest)) {
            return head;
        }
        MultistepExprHolder matchedPaths = null;
        MultistepExprHolder matchedPathsTail = null;
        MultistepExprHolder meh = head;
        while (null != meh) {
            WalkingIterator iter2;
            if (meh != testee && null != meh.m_exprOwner && this.stepsEqual(iter1, iter2 = (WalkingIterator)meh.m_exprOwner.getExpression(), lengthToTest)) {
                if (null == matchedPaths) {
                    try {
                        matchedPaths = (MultistepExprHolder)testee.clone();
                        testee.m_exprOwner = null;
                    }
                    catch (CloneNotSupportedException cnse) {
                        // empty catch block
                    }
                    matchedPathsTail = matchedPaths;
                    matchedPathsTail.m_next = null;
                }
                try {
                    matchedPathsTail.m_next = (MultistepExprHolder)meh.clone();
                    meh.m_exprOwner = null;
                }
                catch (CloneNotSupportedException cnse) {
                    // empty catch block
                }
                matchedPathsTail = matchedPathsTail.m_next;
                matchedPathsTail.m_next = null;
            }
            meh = meh.m_next;
        }
        boolean matchCount = false;
        if (null != matchedPaths) {
            ElemTemplateElement root = isGlobal ? varScope : this.findCommonAncestor(matchedPaths);
            WalkingIterator sharedIter = (WalkingIterator)matchedPaths.m_exprOwner.getExpression();
            WalkingIterator newIter = this.createIteratorFromSteps(sharedIter, lengthToTest);
            ElemVariable var = this.createPseudoVarDecl(root, (LocPathIterator)newIter, isGlobal);
            while (null != matchedPaths) {
                ExpressionOwner owner = matchedPaths.m_exprOwner;
                WalkingIterator iter = (WalkingIterator)owner.getExpression();
                LocPathIterator newIter2 = this.changePartToRef(var.getName(), iter, lengthToTest, isGlobal);
                owner.setExpression((Expression)newIter2);
                matchedPaths = matchedPaths.m_next;
            }
        }
        return head;
    }

    boolean partialIsVariable(MultistepExprHolder testee, int lengthToTest) {
        WalkingIterator wi;
        return 1 == lengthToTest && (wi = (WalkingIterator)testee.m_exprOwner.getExpression()).getFirstWalker() instanceof FilterExprWalker;
    }

    protected void diagnoseLineNumber(Expression expr) {
        ElemTemplateElement e = this.getElemFromExpression(expr);
        System.err.println("   " + e.getSystemId() + " Line " + e.getLineNumber());
    }

    protected ElemTemplateElement findCommonAncestor(MultistepExprHolder head) {
        int numExprs = head.getLength();
        ElemTemplateElement[] elems = new ElemTemplateElement[numExprs];
        int[] ancestorCounts = new int[numExprs];
        MultistepExprHolder next = head;
        int shortestAncestorCount = 10000;
        int i = 0;
        while (i < numExprs) {
            int numAncestors;
            ElemTemplateElement elem;
            elems[i] = elem = this.getElemFromExpression(next.m_exprOwner.getExpression());
            ancestorCounts[i] = numAncestors = this.countAncestors(elem);
            if (numAncestors < shortestAncestorCount) {
                shortestAncestorCount = numAncestors;
            }
            next = next.m_next;
            ++i;
        }
        int i2 = 0;
        while (i2 < numExprs) {
            if (ancestorCounts[i2] > shortestAncestorCount) {
                int numStepCorrection = ancestorCounts[i2] - shortestAncestorCount;
                int j = 0;
                while (j < numStepCorrection) {
                    elems[i2] = elems[i2].getParentElem();
                    ++j;
                }
            }
            ++i2;
        }
        ElemTemplateElement first = null;
        while (shortestAncestorCount-- >= 0) {
            boolean areEqual = true;
            first = elems[0];
            int i3 = 1;
            while (i3 < numExprs) {
                if (first != elems[i3]) {
                    areEqual = false;
                    break;
                }
                ++i3;
            }
            if (areEqual && this.isNotSameAsOwner(head, first) && first.canAcceptVariables()) {
                return first;
            }
            int i4 = 0;
            while (i4 < numExprs) {
                elems[i4] = elems[i4].getParentElem();
                ++i4;
            }
        }
        RedundentExprEliminator.assertion((boolean)false, (String)"Could not find common ancestor!!!");
        return null;
    }

    protected boolean isNotSameAsOwner(MultistepExprHolder head, ElemTemplateElement ete) {
        MultistepExprHolder next = head;
        while (null != next) {
            ElemTemplateElement elemOwner = this.getElemFromExpression(next.m_exprOwner.getExpression());
            if (elemOwner == ete) {
                return false;
            }
            next = next.m_next;
        }
        return true;
    }

    protected int countAncestors(ElemTemplateElement elem) {
        int count = 0;
        while (null != elem) {
            ++count;
            elem = elem.getParentElem();
        }
        return count;
    }

    protected void diagnoseMultistepList(int matchCount, int lengthToTest, boolean isGlobal) {
        if (matchCount > 0) {
            System.err.print("Found multistep matches: " + matchCount + ", " + lengthToTest + " length");
            if (isGlobal) {
                System.err.println(" (global)");
            } else {
                System.err.println();
            }
        }
    }

    protected LocPathIterator changePartToRef(QName uniquePseudoVarName, WalkingIterator wi, int numSteps, boolean isGlobal) {
        Variable var = new Variable();
        var.setQName(uniquePseudoVarName);
        var.setIsGlobal(isGlobal);
        if (isGlobal) {
            ElemTemplateElement elem = this.getElemFromExpression((Expression)wi);
            StylesheetRoot root = elem.getStylesheetRoot();
            Vector vars = root.getVariablesAndParamsComposed();
            var.setIndex(vars.size() - 1);
        }
        AxesWalker walker = wi.getFirstWalker();
        int i = 0;
        while (i < numSteps) {
            RedundentExprEliminator.assertion((null != walker ? 1 : 0) != 0, (String)"Walker should not be null!");
            walker = walker.getNextWalker();
            ++i;
        }
        if (null != walker) {
            FilterExprWalker few = new FilterExprWalker(wi);
            few.setInnerExpression((Expression)var);
            few.exprSetParent((ExpressionNode)wi);
            few.setNextWalker(walker);
            walker.setPrevWalker((AxesWalker)few);
            wi.setFirstWalker((AxesWalker)few);
            return wi;
        }
        FilterExprIteratorSimple feis = new FilterExprIteratorSimple((Expression)var);
        feis.exprSetParent(wi.exprGetParent());
        return feis;
    }

    protected WalkingIterator createIteratorFromSteps(WalkingIterator wi, int numSteps) {
        WalkingIterator newIter = new WalkingIterator(wi.getPrefixResolver());
        try {
            AxesWalker walker = (AxesWalker)wi.getFirstWalker().clone();
            newIter.setFirstWalker(walker);
            walker.setLocPathIterator((LocPathIterator)newIter);
            int i = 1;
            while (i < numSteps) {
                AxesWalker next = (AxesWalker)walker.getNextWalker().clone();
                walker.setNextWalker(next);
                next.setLocPathIterator((LocPathIterator)newIter);
                walker = next;
                ++i;
            }
            walker.setNextWalker(null);
        }
        catch (CloneNotSupportedException cnse) {
            throw new WrappedRuntimeException((Exception)cnse);
        }
        return newIter;
    }

    protected boolean stepsEqual(WalkingIterator iter1, WalkingIterator iter2, int numSteps) {
        AxesWalker aw1 = iter1.getFirstWalker();
        AxesWalker aw2 = iter2.getFirstWalker();
        int i = 0;
        while (i < numSteps) {
            if (null == aw1 || null == aw2) {
                return false;
            }
            if (!aw1.deepEquals((Expression)aw2)) {
                return false;
            }
            aw1 = aw1.getNextWalker();
            aw2 = aw2.getNextWalker();
            ++i;
        }
        RedundentExprEliminator.assertion((null != aw1 || null != aw2 ? 1 : 0) != 0, (String)"Total match is incorrect!");
        return true;
    }

    protected MultistepExprHolder createMultistepExprList(Vector paths) {
        MultistepExprHolder first = null;
        int n = paths.size();
        int i = 0;
        while (i < n) {
            LocPathIterator lpi;
            int numPaths;
            ExpressionOwner eo = (ExpressionOwner)paths.elementAt(i);
            if (null != eo && (numPaths = this.countSteps(lpi = (LocPathIterator)eo.getExpression())) > 1) {
                first = null == first ? new MultistepExprHolder(this, eo, numPaths, null) : first.addInSortedOrder(eo, numPaths);
            }
            ++i;
        }
        if (null == first || first.getLength() <= 1) {
            return null;
        }
        return first;
    }

    protected int findAndEliminateRedundant(int start, int firstOccuranceIndex, ExpressionOwner firstOccuranceOwner, ElemTemplateElement psuedoVarRecipient, Vector paths) throws DOMException {
        MultistepExprHolder head = null;
        MultistepExprHolder tail = null;
        int numPathsFound = 0;
        int n = paths.size();
        Expression expr1 = firstOccuranceOwner.getExpression();
        boolean isGlobal = paths == this.m_absPaths;
        LocPathIterator lpi = (LocPathIterator)expr1;
        int stepCount = this.countSteps(lpi);
        int j = start;
        while (j < n) {
            Expression expr2;
            boolean isEqual;
            ExpressionOwner owner2 = (ExpressionOwner)paths.elementAt(j);
            if (null != owner2 && (isEqual = (expr2 = owner2.getExpression()).deepEquals((Expression)lpi))) {
                LocPathIterator lpi2 = (LocPathIterator)expr2;
                if (null == head) {
                    tail = head = new MultistepExprHolder(this, firstOccuranceOwner, stepCount, null);
                    ++numPathsFound;
                }
                tail = tail.m_next = new MultistepExprHolder(this, owner2, stepCount, null);
                paths.setElementAt(null, j);
                ++numPathsFound;
            }
            ++j;
        }
        if (0 == numPathsFound && isGlobal) {
            head = new MultistepExprHolder(this, firstOccuranceOwner, stepCount, null);
            ++numPathsFound;
        }
        if (null != head) {
            ElemTemplateElement root = isGlobal ? psuedoVarRecipient : this.findCommonAncestor(head);
            LocPathIterator sharedIter = (LocPathIterator)head.m_exprOwner.getExpression();
            ElemVariable var = this.createPseudoVarDecl(root, sharedIter, isGlobal);
            QName uniquePseudoVarName = var.getName();
            while (null != head) {
                ExpressionOwner owner = head.m_exprOwner;
                this.changeToVarRef(uniquePseudoVarName, owner, paths, root);
                head = head.m_next;
            }
            paths.setElementAt(var.getSelect(), firstOccuranceIndex);
        }
        return numPathsFound;
    }

    protected int oldFindAndEliminateRedundant(int start, int firstOccuranceIndex, ExpressionOwner firstOccuranceOwner, ElemTemplateElement psuedoVarRecipient, Vector paths) throws DOMException {
        QName uniquePseudoVarName = null;
        boolean foundFirst = false;
        int numPathsFound = 0;
        int n = paths.size();
        Expression expr1 = firstOccuranceOwner.getExpression();
        boolean isGlobal = paths == this.m_absPaths;
        LocPathIterator lpi = (LocPathIterator)expr1;
        int j = start;
        while (j < n) {
            Expression expr2;
            boolean isEqual;
            ExpressionOwner owner2 = (ExpressionOwner)paths.elementAt(j);
            if (null != owner2 && (isEqual = (expr2 = owner2.getExpression()).deepEquals((Expression)lpi))) {
                LocPathIterator lpi2 = (LocPathIterator)expr2;
                if (!foundFirst) {
                    foundFirst = true;
                    ElemVariable var = this.createPseudoVarDecl(psuedoVarRecipient, lpi, isGlobal);
                    if (null == var) {
                        return 0;
                    }
                    uniquePseudoVarName = var.getName();
                    this.changeToVarRef(uniquePseudoVarName, firstOccuranceOwner, paths, psuedoVarRecipient);
                    paths.setElementAt(var.getSelect(), firstOccuranceIndex);
                    ++numPathsFound;
                }
                this.changeToVarRef(uniquePseudoVarName, owner2, paths, psuedoVarRecipient);
                paths.setElementAt(null, j);
                ++numPathsFound;
            }
            ++j;
        }
        if (0 == numPathsFound && paths == this.m_absPaths) {
            ElemVariable var = this.createPseudoVarDecl(psuedoVarRecipient, lpi, true);
            if (null == var) {
                return 0;
            }
            uniquePseudoVarName = var.getName();
            this.changeToVarRef(uniquePseudoVarName, firstOccuranceOwner, paths, psuedoVarRecipient);
            paths.setElementAt(var.getSelect(), firstOccuranceIndex);
            ++numPathsFound;
        }
        return numPathsFound;
    }

    protected int countSteps(LocPathIterator lpi) {
        if (lpi instanceof WalkingIterator) {
            WalkingIterator wi = (WalkingIterator)lpi;
            AxesWalker aw = wi.getFirstWalker();
            int count = 0;
            while (null != aw) {
                ++count;
                aw = aw.getNextWalker();
            }
            return count;
        }
        return 1;
    }

    protected void changeToVarRef(QName varName, ExpressionOwner owner, Vector paths, ElemTemplateElement psuedoVarRecipient) {
        VariableSafeAbsRef varRef = paths == this.m_absPaths ? new VariableSafeAbsRef() : new Variable();
        varRef.setQName(varName);
        if (paths == this.m_absPaths) {
            StylesheetRoot root = (StylesheetRoot)psuedoVarRecipient;
            Vector globalVars = root.getVariablesAndParamsComposed();
            varRef.setIndex(globalVars.size() - 1);
            varRef.setIsGlobal(true);
        }
        owner.setExpression((Expression)varRef);
    }

    private static synchronized int getPseudoVarID() {
        return m_uniquePseudoVarID++;
    }

    protected ElemVariable createPseudoVarDecl(ElemTemplateElement psuedoVarRecipient, LocPathIterator lpi, boolean isGlobal) throws DOMException {
        QName uniquePseudoVarName = new QName("http://xml.apache.org/xalan/psuedovar", "#" + RedundentExprEliminator.getPseudoVarID());
        if (isGlobal) {
            return this.createGlobalPseudoVarDecl(uniquePseudoVarName, (StylesheetRoot)psuedoVarRecipient, lpi);
        }
        return this.createLocalPseudoVarDecl(uniquePseudoVarName, psuedoVarRecipient, lpi);
    }

    protected ElemVariable createGlobalPseudoVarDecl(QName uniquePseudoVarName, StylesheetRoot stylesheetRoot, LocPathIterator lpi) throws DOMException {
        ElemVariable psuedoVar = new ElemVariable();
        psuedoVar.setIsTopLevel(true);
        XPath xpath = new XPath((Expression)lpi);
        psuedoVar.setSelect(xpath);
        psuedoVar.setName(uniquePseudoVarName);
        Vector globalVars = stylesheetRoot.getVariablesAndParamsComposed();
        psuedoVar.setIndex(globalVars.size());
        globalVars.addElement(psuedoVar);
        return psuedoVar;
    }

    protected ElemVariable createLocalPseudoVarDecl(QName uniquePseudoVarName, ElemTemplateElement psuedoVarRecipient, LocPathIterator lpi) throws DOMException {
        ElemVariablePsuedo psuedoVar = new ElemVariablePsuedo();
        XPath xpath = new XPath((Expression)lpi);
        psuedoVar.setSelect(xpath);
        psuedoVar.setName(uniquePseudoVarName);
        ElemVariable var = this.addVarDeclToElem(psuedoVarRecipient, lpi, (ElemVariable)psuedoVar);
        lpi.exprSetParent((ExpressionNode)var);
        return var;
    }

    /*
     * Unable to fully structure code
     */
    protected ElemVariable addVarDeclToElem(ElemTemplateElement psuedoVarRecipient, LocPathIterator lpi, ElemVariable psuedoVar) throws DOMException {
        block4: {
            ete = psuedoVarRecipient.getFirstChildElem();
            lpi.callVisitors(null, (XPathVisitor)this.m_varNameCollector);
            if (this.m_varNameCollector.getVarCount() > 0) {
                baseElem = this.getElemFromExpression((Expression)lpi);
                varElem = this.getPrevVariableElem(baseElem);
                while (null != varElem) {
                    if (this.m_varNameCollector.doesOccur(varElem.getName())) {
                        psuedoVarRecipient = varElem.getParentElem();
                        ete = varElem.getNextSiblingElem();
                        break;
                    }
                    varElem = this.getPrevVariableElem((ElemTemplateElement)varElem);
                }
            }
            if (null == ete || 41 != ete.getXSLToken()) break block4;
            if (!this.isParam((ExpressionNode)lpi)) ** GOTO lbl-1000
            return null;
            while (null == (ete = ete.getNextSiblingElem()) || 41 == ete.getXSLToken()) lbl-1000:
            // 2 sources

            {
                if (null != ete) continue;
            }
        }
        psuedoVarRecipient.insertBefore((Node)psuedoVar, (Node)ete);
        this.m_varNameCollector.reset();
        return psuedoVar;
    }

    protected boolean isParam(ExpressionNode expr) {
        while (null != expr) {
            if (expr instanceof ElemTemplateElement) break;
            expr = expr.exprGetParent();
        }
        if (null != expr) {
            ElemTemplateElement ete = (ElemTemplateElement)expr;
            while (null != ete) {
                int type = ete.getXSLToken();
                switch (type) {
                    case 41: {
                        return true;
                    }
                    case 19: 
                    case 25: {
                        return false;
                    }
                }
                ete = ete.getParentElem();
            }
        }
        return false;
    }

    protected ElemVariable getPrevVariableElem(ElemTemplateElement elem) {
        while (null != (elem = this.getPrevElementWithinContext(elem))) {
            int type = elem.getXSLToken();
            if (73 != type && 41 != type) continue;
            return (ElemVariable)elem;
        }
        return null;
    }

    protected ElemTemplateElement getPrevElementWithinContext(ElemTemplateElement elem) {
        int type;
        ElemTemplateElement prev = elem.getPreviousSiblingElem();
        if (null == prev) {
            prev = elem.getParentElem();
        }
        if (null != prev && (28 == (type = prev.getXSLToken()) || 19 == type || 25 == type)) {
            prev = null;
        }
        return prev;
    }

    protected ElemTemplateElement getElemFromExpression(Expression expr) {
        ExpressionNode parent = expr.exprGetParent();
        while (null != parent) {
            if (parent instanceof ElemTemplateElement) {
                return (ElemTemplateElement)parent;
            }
            parent = parent.exprGetParent();
        }
        throw new RuntimeException(XSLMessages.createMessage((String)"ER_ASSERT_NO_TEMPLATE_PARENT", null));
    }

    public boolean isAbsolute(LocPathIterator path) {
        boolean isAbs;
        int analysis = path.getAnalysisBits();
        boolean bl = isAbs = WalkerFactory.isSet((int)analysis, (int)0x8000000) || WalkerFactory.isSet((int)analysis, (int)0x20000000);
        if (isAbs) {
            isAbs = this.m_absPathChecker.checkAbsolute(path);
        }
        return isAbs;
    }

    public boolean visitLocationPath(ExpressionOwner owner, LocPathIterator path) {
        FilterExprWalker few;
        Expression exp;
        WalkingIterator wi;
        AxesWalker aw;
        if (path instanceof SelfIteratorNoPredicate) {
            return true;
        }
        if (path instanceof WalkingIterator && (aw = (wi = (WalkingIterator)path).getFirstWalker()) instanceof FilterExprWalker && null == aw.getNextWalker() && (exp = (few = (FilterExprWalker)aw).getInnerExpression()) instanceof Variable) {
            return true;
        }
        if (this.isAbsolute(path) && null != this.m_absPaths) {
            this.m_absPaths.addElement(owner);
        } else if (this.m_isSameContext && null != this.m_paths) {
            this.m_paths.addElement(owner);
        }
        return true;
    }

    public boolean visitPredicate(ExpressionOwner owner, Expression pred) {
        boolean savedIsSame = this.m_isSameContext;
        this.m_isSameContext = false;
        pred.callVisitors(owner, (XPathVisitor)this);
        this.m_isSameContext = savedIsSame;
        return false;
    }

    public boolean visitTopLevelInstruction(ElemTemplateElement elem) {
        int type = elem.getXSLToken();
        switch (type) {
            case 19: {
                return this.visitInstruction(elem);
            }
        }
        return true;
    }

    public boolean visitInstruction(ElemTemplateElement elem) {
        int type = elem.getXSLToken();
        switch (type) {
            case 17: 
            case 19: 
            case 28: {
                if (type == 28) {
                    ElemForEach efe = (ElemForEach)elem;
                    Expression select = efe.getSelect();
                    select.callVisitors((ExpressionOwner)efe, (XPathVisitor)this);
                }
                Vector savedPaths = this.m_paths;
                this.m_paths = new Vector();
                elem.callChildVisitors((XSLTVisitor)this, false);
                this.eleminateRedundentLocals(elem);
                this.m_paths = savedPaths;
                return false;
            }
            case 35: 
            case 64: {
                boolean savedIsSame = this.m_isSameContext;
                this.m_isSameContext = false;
                elem.callChildVisitors((XSLTVisitor)this);
                this.m_isSameContext = savedIsSame;
                return false;
            }
        }
        return true;
    }

    protected void diagnoseNumPaths(Vector paths, int numPathsEliminated, int numUniquePathsEliminated) {
        if (numPathsEliminated > 0) {
            if (paths == this.m_paths) {
                System.err.println("Eliminated " + numPathsEliminated + " total paths!");
                System.err.println("Consolodated " + numUniquePathsEliminated + " redundent paths!");
            } else {
                System.err.println("Eliminated " + numPathsEliminated + " total global paths!");
                System.err.println("Consolodated " + numUniquePathsEliminated + " redundent global paths!");
            }
        }
    }

    private final void assertIsLocPathIterator(Expression expr1, ExpressionOwner eo) throws RuntimeException {
        if (!(expr1 instanceof LocPathIterator)) {
            String errMsg = expr1 instanceof Variable ? "Programmer's assertion: expr1 not an iterator: " + ((Variable)expr1).getQName() : "Programmer's assertion: expr1 not an iterator: " + expr1.getClass().getName();
            throw new RuntimeException(errMsg + ", " + eo.getClass().getName() + " " + expr1.exprGetParent());
        }
    }

    private static void validateNewAddition(Vector paths, ExpressionOwner owner, LocPathIterator path) throws RuntimeException {
        RedundentExprEliminator.assertion((owner.getExpression() == path ? 1 : 0) != 0, (String)"owner.getExpression() != path!!!");
        int n = paths.size();
        int i = 0;
        while (i < n) {
            ExpressionOwner ew = (ExpressionOwner)paths.elementAt(i);
            RedundentExprEliminator.assertion((ew != owner ? 1 : 0) != 0, (String)"duplicate owner on the list!!!");
            RedundentExprEliminator.assertion((ew.getExpression() != path ? 1 : 0) != 0, (String)"duplicate expression on the list!!!");
            ++i;
        }
    }

    protected static void assertion(boolean b, String msg) {
        if (!b) {
            throw new RuntimeException(XSLMessages.createMessage((String)"ER_ASSERT_REDUNDENT_EXPR_ELIMINATOR", (Object[])new Object[]{msg}));
        }
    }
}

