/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EOConfigField
extends EOEncodableObject {
    public static final String ADD_ATTR_ENUM_PRFIX = "enum";
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_LONG = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_ENUMERATION = 5;
    public static final int TYPE_PASSWORD = 6;
    public static final String XML_NAME = "Field";
    private static final String ATTR_TAG_TYPE = "type";
    private static final String ATTR_TAG_ID = "fieldid";
    private static final String ATTR_TAG_DISPLAY_NAME = "displayname";
    private static final String ATTR_TAG_NOT_NULL = "notnull";
    private int type;
    private String id;
    private String displayName;
    private String value;
    private boolean notNull;
    HashMap additionalAttributes;

    public EOConfigField() {
        super(XML_NAME);
    }

    public EOConfigField(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOConfigField(int type, String id, String displayName, boolean notNull) {
        super(XML_NAME);
        this.type = type;
        this.id = id;
        this.displayName = displayName;
        this.notNull = notNull;
    }

    public EOConfigField(int type, String id, String displayName, boolean notNull, String value) {
        super(XML_NAME);
        this.type = type;
        this.id = id;
        this.displayName = displayName;
        this.notNull = notNull;
        this.value = value;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.writeAttributes(writeContext);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_TYPE)) {
            this.type = this.toInt(value);
        } else if (name.equals(ATTR_TAG_ID)) {
            this.id = value;
        } else if (name.equals(ATTR_TAG_DISPLAY_NAME)) {
            this.displayName = value;
        } else if (name.equals(ATTR_TAG_NOT_NULL)) {
            this.notNull = this.toBoolean(value);
        } else {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = new HashMap();
            }
            this.additionalAttributes.put(name, value);
        }
        return true;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    protected void writeAttributes(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.type);
        this.appendAttrToXML(writeContext, ATTR_TAG_ID, this.id);
        this.appendAttrToXML(writeContext, ATTR_TAG_DISPLAY_NAME, this.displayName);
        this.appendAttrToXML(writeContext, ATTR_TAG_NOT_NULL, this.notNull);
        if (this.additionalAttributes != null) {
            for (Map.Entry e : this.additionalAttributes.entrySet()) {
                this.appendAttrToXML(writeContext, e.getKey().toString(), e.getValue().toString());
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getID() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getBooleanValue() {
        if (this.type == 4) {
            return new Boolean(this.value);
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getAdditionalAttribute(String name) {
        if (this.additionalAttributes.containsKey(name)) {
            return (String)this.additionalAttributes.get(name);
        }
        return null;
    }

    public int getAdditionalAttributeSize() {
        return this.additionalAttributes.size();
    }

    public Set getAdditionalAttributeKeys() {
        return this.additionalAttributes.keySet();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addAdditionalAttribute(String name, String value) {
        if (this.additionalAttributes == null) {
            this.additionalAttributes = new HashMap();
        }
        this.additionalAttributes.put(name, value);
    }
}

