/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.httputil.HTTPUtil;
import de.plans.psc.client.communication.transmissionprocessor.AlienHTTPResponseException;
import de.plans.psc.client.dialogs.swt.Messages;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class HTTPResponseProblemDialog
extends ModificationProblemsDialog {
    private final String headerinfo;
    private final String browsertext;

    public HTTPResponseProblemDialog(Shell parentShell, String dialogTitle, String dialogMessage, Collection<IModificationProblem> mProblems, AlienHTTPResponseException alienHTTPResponseException) {
        super(mProblems, dialogTitle, dialogMessage, parentShell);
        this.headerinfo = HTTPResponseProblemDialog.calculateHeaderInfoText(alienHTTPResponseException);
        this.browsertext = alienHTTPResponseException.getResponseContentAsString();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        tabFolder.setLayout((Layout)layout);
        tabFolder.setBackground(tabFolder.getDisplay().getSystemColor(1));
        TabItem problemsTabItem = new TabItem(tabFolder, 0);
        problemsTabItem.setText(Messages.getString("HTTPResponseProblemDialog.TabTitle_Problem"));
        Control problemsControl = super.createDialogArea((Composite)tabFolder);
        problemsTabItem.setControl(problemsControl);
        GridData problemsGridData = new GridData(1808);
        problemsGridData.heightHint = 180;
        problemsControl.setLayoutData((Object)problemsGridData);
        TabItem textTabItem = new TabItem(tabFolder, 0);
        textTabItem.setText(Messages.getString("HTTPResponseProblemDialog.TabTitle_ResponseHeaders"));
        Text text = new Text((Composite)tabFolder, 2634);
        text.setText(this.headerinfo);
        textTabItem.setControl((Control)text);
        GridData textGridData = new GridData(1808);
        textGridData.heightHint = 180;
        text.setLayoutData((Object)textGridData);
        TabItem browserTabItem = new TabItem(tabFolder, 0);
        browserTabItem.setText(Messages.getString("HTTPResponseProblemDialog.TabTitle_ResponseBody"));
        IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget((Composite)tabFolder, (int)2048);
        browser.setHtml(this.browsertext);
        Control browserControl = browser.getSWTControl();
        browserTabItem.setControl(browserControl);
        GridData browserGridData = new GridData(1808);
        browserGridData.heightHint = 180;
        browserControl.setLayoutData((Object)browserGridData);
        return tabFolder;
    }

    private static String calculateHeaderInfoText(AlienHTTPResponseException alienHTTPResponseException) {
        StringBuilder headerinfo = new StringBuilder();
        headerinfo.append("HTTP ");
        headerinfo.append(alienHTTPResponseException.getRequestMethod());
        headerinfo.append(" ");
        headerinfo.append(alienHTTPResponseException.getUrl());
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        headerinfo.append("Returned: ");
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        headerinfo.append("    ");
        headerinfo.append(alienHTTPResponseException.getResponseCode());
        headerinfo.append(" ");
        headerinfo.append(alienHTTPResponseException.getResponseMessage());
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        headerinfo.append("Response Headers:");
        headerinfo.append(HTTPUtil.LINE_SEPARATOR);
        for (Map.Entry<String, List<String>> headerField : alienHTTPResponseException.getHeaderFields().entrySet()) {
            headerinfo.append("    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + HTTPUtil.LINE_SEPARATOR);
            List<String> values = headerField.getValue();
            if (values == null) continue;
            for (String value : values) {
                headerinfo.append("        Value: " + (value == null ? " <null> " : value) + HTTPUtil.LINE_SEPARATOR);
            }
        }
        return headerinfo.toString();
    }
}

