/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import de.plans.psc.client.dialogs.swt.Messages;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDialog
extends TitleAreaDialog {
    private EXServerException serverException;
    private Throwable throwable;
    private Image exceptionImage;
    private Composite baseArea;
    private String msgText;

    public ExceptionDialog(Shell parentShell, EXServerException serverException) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.serverException = serverException;
    }

    public ExceptionDialog(Shell parentShell, EXServerException serverException, String msgText) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.serverException = serverException;
        this.msgText = msgText;
    }

    public ExceptionDialog(Shell parentShell, Throwable throwable) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.throwable = throwable;
    }

    public ExceptionDialog(Shell parentShell, Throwable throwable, String msgText) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.throwable = throwable;
        this.msgText = msgText;
    }

    protected Control createDialogArea(Composite parent) {
        this.exceptionImage = EclipsePlugin.getImageDescriptor("Exception.gif").createImage();
        this.setTitleImage(this.exceptionImage);
        if (this.serverException != null) {
            this.setTitle(Messages.getString("ExceptionDialog.Server_Exception_!_1"));
            if (this.msgText == null) {
                this.setMessage(Messages.getString("ExceptionDialog.Sorry,_an_unexpected_exception_occured_on_server_side._2"));
            } else {
                this.setMessage(this.msgText);
            }
            parent.getShell().setText(Messages.getString("ExceptionDialog.servererror"));
        } else if (this.throwable != null) {
            this.setTitle(Messages.getString("ExceptionDialog.Client_Exception_!_8"));
            if (this.msgText == null) {
                this.setMessage(Messages.getString("ExceptionDialog.Sorry,_an_unexpected_exception_occured_on_client_side._9"));
            } else {
                this.setMessage(this.msgText);
            }
        }
        if (this.serverException != null) {
            return this.displayException(parent);
        }
        if (this.throwable != null) {
            return this.displayThrowable(parent);
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private Composite displayException(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ExceptionDialog.this.exceptionImage != null && !ExceptionDialog.this.exceptionImage.isDisposed()) {
                    ExceptionDialog.this.exceptionImage.dispose();
                    ExceptionDialog.this.exceptionImage = null;
                }
            }
        });
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        area.setLayoutData((Object)gridData);
        this.showBaseArea(area);
        return area;
    }

    private void showBaseArea(Composite area) {
        if (this.baseArea != null && !this.baseArea.isDisposed()) {
            this.baseArea.dispose();
        }
        this.baseArea = new Composite(area, 0);
        GridData gridData = new GridData(1808);
        this.baseArea.setLayoutData((Object)gridData);
        this.baseArea.setLayout((Layout)new GridLayout(2, false));
        Label lblMessage = new Label(this.baseArea, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 3;
        lblMessage.setLayoutData((Object)gridData);
        lblMessage.setText(this.serverException.getLocalizedMessage());
        Button btnDetails = new Button(this.baseArea, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        btnDetails.setText(Messages.getString("ExceptionDialog.show_details"));
        btnDetails.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionDialog.this.showDetails();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void showDetails() {
        TitleAreaDialog dialog = new TitleAreaDialog(this.getShell()){

            protected Control createDialogArea(Composite parent) {
                String stackTrace;
                parent.getShell().setText(String.valueOf(Messages.getString("ExceptionDialog.error_details")) + " ...");
                this.setTitleImage(ExceptionDialog.this.exceptionImage);
                this.setTitle(Messages.getString("ExceptionDialog.error_details"));
                if (ExceptionDialog.this.serverException != null) {
                    this.setMessage(Messages.getString("ExceptionDialog.following_problem"));
                } else {
                    this.setMessage(Messages.getString("ExceptionDialog.following_client_problem"));
                }
                Composite detailsArea = new Composite(parent, 2048);
                GridData gridData = new GridData(1808);
                detailsArea.setLayoutData((Object)gridData);
                detailsArea.setLayout((Layout)new GridLayout(2, true));
                if (ExceptionDialog.this.serverException != null) {
                    Label lblExceptionGrp = new Label(detailsArea, 0);
                    lblExceptionGrp.setText(Messages.getString("ExceptionDialog.Exception_Group__5"));
                    Text txtExceptionGrp = new Text(detailsArea, 10);
                    txtExceptionGrp.setText(ExceptionDialog.this.serverException.getGroup());
                    gridData = new GridData();
                    gridData.grabExcessHorizontalSpace = true;
                    txtExceptionGrp.setLayoutData((Object)gridData);
                    Label lblExceptionID = new Label(detailsArea, 0);
                    lblExceptionID.setText(Messages.getString("ExceptionDialog.Exception_ID__6"));
                    Text txtExceptionID = new Text(detailsArea, 8);
                    txtExceptionID.setText(ExceptionDialog.this.serverException.getId());
                    gridData = new GridData();
                    gridData.grabExcessHorizontalSpace = true;
                    txtExceptionID.setLayoutData((Object)gridData);
                }
                Label label = new Label(detailsArea, 0);
                label.setText(Messages.getString("ExceptionDialog.description"));
                Text txtMessage = new Text(detailsArea, 8);
                String exceptionMessage = null;
                if (ExceptionDialog.this.serverException != null) {
                    exceptionMessage = ExceptionDialog.this.serverException.getLocalizedMessage();
                } else if (ExceptionDialog.this.throwable.getLocalizedMessage() != null) {
                    exceptionMessage = ExceptionDialog.this.throwable.getLocalizedMessage();
                }
                if (exceptionMessage == null) {
                    exceptionMessage = Messages.getString("ExceptionDialog.noMessage");
                }
                txtMessage.setText(exceptionMessage);
                gridData = new GridData();
                gridData.grabExcessHorizontalSpace = true;
                txtMessage.setLayoutData((Object)gridData);
                Label lblStackTrace = new Label(detailsArea, 0);
                lblStackTrace.setText(Messages.getString("ExceptionDialog.Stack_Trace__7"));
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                gridData.horizontalAlignment = 1;
                lblStackTrace.setLayoutData((Object)gridData);
                Text txtStackTrace = new Text(detailsArea, 2816);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                txtStackTrace.setLayoutData((Object)gridData);
                txtStackTrace.setEditable(false);
                if (ExceptionDialog.this.serverException != null) {
                    stackTrace = ExceptionDialog.this.serverException.getServerStackTrace();
                } else {
                    StackTraceElement[] stacktraceElements = ExceptionDialog.this.throwable.getStackTrace();
                    stackTrace = "";
                    StackTraceElement[] stackTraceElementArray = stacktraceElements;
                    int n = stacktraceElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement element = stackTraceElementArray[n2];
                        stackTrace = String.valueOf(stackTrace) + element.toString() + "\n";
                        ++n2;
                    }
                }
                if (stackTrace != null && stackTrace.trim().length() > 0) {
                    txtStackTrace.setText(stackTrace);
                } else {
                    txtStackTrace.setText(Messages.getString("ExceptionDialog.no_stacktrace"));
                }
                return detailsArea;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    private Composite displayThrowable(Composite parent) {
        Composite area = new Composite(parent, 16);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout());
        this.exceptionImage = EclipsePlugin.getImageDescriptor("Exception.gif").createImage();
        this.setTitleImage(this.exceptionImage);
        area.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExceptionDialog.this.exceptionImage.dispose();
            }
        });
        Composite message = new Composite(area, 0);
        message.setLayoutData((Object)new GridData(1808));
        message.setLayout((Layout)new GridLayout(2, false));
        Label lblMessage = new Label(message, 0);
        lblMessage.setText(Messages.getString("ExceptionDialog.Description__12"));
        Text txtMessage = new Text(message, 8);
        String msg = this.throwable.getLocalizedMessage();
        if (msg != null) {
            txtMessage.setText(msg);
        } else {
            txtMessage.setText("unknown problem");
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        txtMessage.setLayoutData((Object)gridData);
        Button btnStack = new Button(area, 0);
        btnStack.setText(Messages.getString("ExceptionDialog.show_details"));
        btnStack.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionDialog.this.showDetails();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return area;
    }
}

