/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.client.dialogs.admin.swt.UIPnlUserData;
import de.plans.psc.client.model.User;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class UserWizardUserDataPage
extends WizardPage
implements ModifyListener {
    private UIPnlUserData dataPanel;
    private String[] userNames;
    private User user;

    public UserWizardUserDataPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.dataPanel = new UIPnlUserData(composite, true);
        this.dataPanel.setLayoutData(new GridData(1808));
        this.dataPanel.setModifyListener(this);
        if (this.user != null) {
            this.dataPanel.setUser(this.user);
        }
        this.setTitle(Messages.getString("UserWizardUserDataPage.User_Data_1"));
        this.setDescription(Messages.getString("UserWizardUserDataPage.Please_enter_data_describing_the_new_user._2"));
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    protected void setUserNames(String[] userNames) {
        this.userNames = userNames;
    }

    protected void setUser(User user) {
        this.user = user;
        if (this.dataPanel != null) {
            this.dataPanel.setUser(user);
        }
    }

    public void modifyText(ModifyEvent evt) {
        if (this.updateDuplicateUserWarning()) {
            this.setPageComplete(false);
        } else if (this.dataPanel.getUserName().length() == 0) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.Please_enter_a_unique_user_name._3"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getUserName().indexOf(39) != -1) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.Do_not_use_single_quotes_in_user_name._3"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getDisplayName().length() == 0) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.Please_enter_a_display_name_for_the_user._4"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getDisplayName().length() > 63) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.display_name_too_long"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getUserName().length() > 63) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.user_name_too_long"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getEmail().length() > 255) {
            this.setMessage(Messages.getString("UserWizardUserDataPage.email_too_long"), 3);
            this.setPageComplete(false);
        } else {
            this.setMessage("");
            this.setPageComplete(true);
        }
    }

    private boolean updateDuplicateUserWarning() {
        boolean duplicate = false;
        if (this.userNames != null) {
            String userName = this.dataPanel.getUserName();
            String[] stringArray = this.userNames;
            int n = this.userNames.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.compareTo(userName) == 0) {
                    duplicate = true;
                    this.setErrorMessage(Messages.getString("UserWizardUserDataPage.This_user_name_is_already_in_use_5"));
                }
                ++n2;
            }
            if (!duplicate) {
                this.setErrorMessage(null);
            }
        }
        return duplicate;
    }

    protected void fillIn(User user) {
        user.setUserName(this.dataPanel.getUserName());
        user.setDisplayName(this.dataPanel.getDisplayName());
        user.setEmail(this.dataPanel.getEmail());
        user.setDescription(this.dataPanel.getDescription());
    }
}

