/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import com.arcway.lib.UUIDGenerator;
import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SetPermissionsWizardPage
extends WizardPage {
    private List permissionTemplates;
    private List currentPermissions;
    private List addedPermissions;
    private List deletedPermissions;
    private Table permissionTable;
    private static UUIDGenerator uidGenerator = new UUIDGenerator();
    private String ownerID;
    private int ownerType;

    public SetPermissionsWizardPage(String pageName) {
        super(pageName);
    }

    public void construct(List permissionTemplates, List currentPermissions, String ownerID, int ownerType) {
        this.permissionTemplates = permissionTemplates;
        this.currentPermissions = currentPermissions;
        this.ownerID = ownerID;
        this.ownerType = ownerType;
        this.fillTable();
    }

    public void construct(List permissionTemplates, List currentPermissions) {
        this.permissionTemplates = permissionTemplates;
        this.currentPermissions = currentPermissions;
        this.fillTable();
    }

    public void setOwner(String ownerID, int ownerType) {
        this.ownerID = ownerID;
        this.ownerType = ownerType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        this.permissionTable = new Table(composite, 32);
        this.permissionTable.setLayout((Layout)new GridLayout());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.permissionTable.setLayoutData((Object)gridData);
        TableColumn column = new TableColumn(this.permissionTable, 0);
        column.setText(Messages.getString("SetPermissionsWizardPage.Permission_1"));
        column.setWidth(200);
        this.setPageComplete(true);
        this.setControl((Control)composite);
        this.fillTable();
    }

    private void fillTable() {
        if (this.permissionTemplates != null && this.permissionTable != null && !this.permissionTable.isDisposed()) {
            int i = 0;
            while (i < this.permissionTemplates.size()) {
                EOPermission p = (EOPermission)this.permissionTemplates.get(i);
                TableItem item = new TableItem(this.permissionTable, 16384);
                item.setText(PSCPermissionConstants.getPermissionName((EOPermission)p));
                item.setChecked(this.hasPermission(p));
                ++i;
            }
        }
    }

    protected void analyzePermissions() {
        this.addedPermissions = new ArrayList();
        this.deletedPermissions = new ArrayList();
        int i = 0;
        while (i < this.permissionTemplates.size()) {
            TableItem tableItem = this.permissionTable.getItem(i);
            EOPermission template = (EOPermission)this.permissionTemplates.get(i);
            if (tableItem.getChecked()) {
                if (!this.hasPermission(template)) {
                    this.addPermission(template);
                }
            } else if (this.hasPermission(template)) {
                this.deletePermission(template);
            }
            ++i;
        }
    }

    private boolean hasPermission(EOPermission p) {
        boolean hasPermission = false;
        int i = 0;
        while (i < this.currentPermissions.size()) {
            EOPermission ownedPermission = (EOPermission)this.currentPermissions.get(i);
            if (p.hasEqualRights(ownedPermission)) {
                hasPermission = true;
                break;
            }
            ++i;
        }
        return hasPermission;
    }

    private void addPermission(EOPermission templatePermission) {
        EOPermission newPermission = new EOPermission();
        newPermission.setPermissionUID(uidGenerator.getUUID());
        newPermission.setOperandType(templatePermission.getOperandType());
        newPermission.setOperandUID(templatePermission.getOperandUID());
        newPermission.setOperation(templatePermission.getOperation());
        newPermission.setOwnerID(this.ownerID);
        newPermission.setOwnerType(this.ownerType);
        newPermission.setSubSetType(templatePermission.getSubSetType());
        newPermission.setSubSetUID(templatePermission.getSubSetUID());
        this.addedPermissions.add(newPermission);
    }

    private void deletePermission(EOPermission templatePermission) {
        int i = 0;
        while (i < this.currentPermissions.size()) {
            EOPermission ownedPermission = (EOPermission)this.currentPermissions.get(i);
            if (templatePermission.hasEqualRights(ownedPermission)) {
                this.deletedPermissions.add(ownedPermission);
            }
            ++i;
        }
    }

    public List getAddedPermissions() {
        return this.addedPermissions;
    }

    public List getDeletedPermissions() {
        return this.deletedPermissions;
    }
}

