/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import de.plans.psc.shared.message.StreamDataBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class RequestCoDec {
    private static final ILogger LOGGER = Logger.getLogger(RequestCoDec.class);

    private RequestCoDec() {
    }

    static EncodableObjectBase decodeInputStream(InputStream requestStream, XMLDecoder xmlDecoder, PSCAbstractMessageDataFactory messageFactory) throws EXDecoderException {
        assert (requestStream != null);
        ZipInputStream zipInputStream = new ZipInputStream(requestStream);
        ZipEntry contentEntry = null;
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (entry.getName().equalsIgnoreCase("content.xml")) {
                    contentEntry = entry;
                    break;
                }
                LOGGER.debug("Illegal/Unexpected Data (zipEntry=\"" + entry.getName() + "\") contained in Zip compressed Client Request.");
            }
        }
        catch (IOException e) {
            throw new EXDecoderException("Unable to decompress Zip compressed Client Request data.", (Throwable)e);
        }
        if (contentEntry == null) {
            throw new EXDecoderException("No data contained in Zip compressed Client Request container. Unable to decode Client Request.");
        }
        ZipInputStream requestStreamForXMLDecoder = zipInputStream;
        try {
            EncodableObjectBase decodedRequest;
            EncodableObjectBase encodableObjectBase = decodedRequest = xmlDecoder.decodeXML((InputStream)requestStreamForXMLDecoder, (IEncodableObjectFactory)messageFactory, true);
            return encodableObjectBase;
        }
        finally {
            try {
                ((InputStream)requestStreamForXMLDecoder).close();
            }
            catch (IOException e) {
                LOGGER.debug("Problem while closing request stream", (Throwable)e);
            }
        }
    }

    static void encodeEOAsStream(EncodableObjectBase eo, StreamDataBuffer responseBuffer) throws IOException, EXEncoderException {
        OutputStream outputStream = responseBuffer.initialiseGetOutputStreamForStreamContentInitialisation();
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ZipEntry e = new ZipEntry("content.xml");
        zipOutputStream.putNextEntry(e);
        eo.writeToXMLStream((OutputStream)zipOutputStream, false);
        zipOutputStream.close();
    }
}

