/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.httputil.HTTPUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlienHTTPResponseException
extends IOException {
    private static final ILogger LOGGER = Logger.getLogger(AlienHTTPResponseException.class);
    private final URL url;
    private final String requestMethod;
    private final int responseCode;
    private final String responseMessage;
    private final String contentType;
    private final int contentLength;
    private final Map<String, List<String>> headerFields;
    private final byte[] responseContentBytes;

    public static AlienHTTPResponseException createInstance(HttpURLConnection httpURLConnection, ByteArrayOutputStream responseContent) {
        int responseCode = -1;
        try {
            responseCode = httpURLConnection.getResponseCode();
        }
        catch (IOException e) {
            LOGGER.debug("Error while Retrieving Response code", (Throwable)e);
        }
        String responseMessage = "<not initialized>";
        try {
            responseMessage = httpURLConnection.getResponseMessage();
        }
        catch (IOException e) {
            LOGGER.debug("Error while Retrieving Response Message", (Throwable)e);
        }
        byte[] responseContentBytes = new byte[]{};
        if (responseContent != null) {
            responseContentBytes = responseContent.toByteArray();
        }
        return new AlienHTTPResponseException(httpURLConnection.getURL(), httpURLConnection.getRequestMethod(), responseCode, responseMessage, httpURLConnection.getContentType(), httpURLConnection.getContentLength(), new HashMap<String, List<String>>(httpURLConnection.getHeaderFields()), responseContentBytes);
    }

    public AlienHTTPResponseException(URL url, String requestMethod, int responseCode, String responseMessage, String contentType, int contentLength, Map<String, List<String>> headerFields, byte[] responseContentBytes) {
        this.url = url;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.headerFields = headerFields;
        this.requestMethod = requestMethod;
        this.responseCode = responseCode;
        this.responseContentBytes = responseContentBytes;
        this.responseMessage = responseMessage;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Map<String, List<String>> getHeaderFields() {
        return this.headerFields;
    }

    public byte[] getResponseContentBytes() {
        return this.responseContentBytes;
    }

    public String getResponseContentAsString() {
        return HTTPUtil.convertResponseContentToString(this.responseContentBytes, this.contentType);
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Accessing \"");
        sb.append(this.url);
        sb.append("\" using HTTP method ");
        sb.append(this.requestMethod);
        sb.append(" returned response code ");
        sb.append(this.responseCode);
        sb.append(" - ");
        sb.append(this.responseMessage);
        sb.append("\n");
        sb.append("Response Headers:\n");
        for (Map.Entry<String, List<String>> headerField : this.headerFields.entrySet()) {
            sb.append("    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n");
            List<String> values = headerField.getValue();
            if (values == null) continue;
            for (String value : values) {
                sb.append("        Value: " + (value == null ? " <null> " : value) + "\n");
            }
        }
        sb.append("\n");
        sb.append("Response Content:\n");
        sb.append(this.getResponseContentAsString());
        return sb.toString();
    }
}

