/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.psc.client.communication.AbstractRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.SSLCommunicationException;
import de.plans.psc.client.communication.httputil.BlindTrustSocketFactory;
import de.plans.psc.client.communication.httputil.HTTPUtil;
import de.plans.psc.client.communication.transmissionprocessor.AlienHTTPResponseException;
import de.plans.psc.client.communication.transmissionprocessor.SunJvmBug6514454Workaround;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;

public abstract class AbstractSnoopRequestJobStep
extends AbstractRequestJob
implements ISnoopRequestJob {
    private static final ILogger LOGGER = Logger.getLogger(AbstractSnoopRequestJobStep.class);
    private static final String SNOOP_REQUEST_CONTENT = "SNOOP_REQUEST_CONTENT";
    private IOException ioException;
    protected String authenticatedUsersName;
    private PSCAuthenticator.RequestorInfo authenticationRequestor;
    protected String observedAuthType;

    public AbstractSnoopRequestJobStep() {
        this.clearResult();
    }

    private void clearResult() {
        this.ioException = null;
        this.authenticatedUsersName = null;
        this.authenticationRequestor = null;
        this.observedAuthType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void do_snoop(URL serverURL) {
        this.clearResult();
        Object object = PSCAuthenticator.getUnknownRequestorDiscoverySequencerLock();
        synchronized (object) {
            PSCAuthenticator.forgetLastUnknownRequestor();
            this.sendSnoopRequest(serverURL);
            this.authenticationRequestor = PSCAuthenticator.getLastUnknownRequestor();
            PSCAuthenticator.forgetLastUnknownRequestor();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sendSnoopRequest(URL serverURL) {
        block50: {
            try {
                block51: {
                    block46: {
                        block48: {
                            block47: {
                                try {
                                    httpURLConnection = (HttpURLConnection)serverURL.openConnection();
                                }
                                catch (ClassCastException e) {
                                    msg = "Unsupported communication protocol \"" + serverURL.getProtocol() + "\". Supported Protocols are \"http\" and \"https\"";
                                    ioex = new IOException(msg);
                                    ioex.initCause(e);
                                    throw ioex;
                                }
                                httpURLConnection.setRequestProperty("CONTENT-TYPE", "psc-client-snoop");
                                httpURLConnection.setDoInput(true);
                                httpURLConnection.setDoOutput(true);
                                httpURLConnection.setInstanceFollowRedirects(false);
                                connectIOEx = null;
                                returnIOEx = null;
                                try {
                                    try {
                                        SunJvmBug6514454Workaround.fixHttpsClientSetup(serverURL);
                                        os = httpURLConnection.getOutputStream();
                                        os.write("SNOOP_REQUEST_CONTENT".getBytes("UTF-8"));
                                        os.flush();
                                        httpURLConnection.connect();
                                        break block46;
                                    }
                                    catch (IOException ioex) {
                                        connectIOEx = ioex;
                                        returnIOEx = ioex;
                                        if (connectIOEx != null && httpURLConnection instanceof HttpsURLConnection && connectIOEx instanceof SSLException) {
                                            try {
                                                httpsURLConnection = (HttpsURLConnection)serverURL.openConnection();
                                                serverCertificates = AbstractSnoopRequestJobStep.getServerCertificates(httpsURLConnection);
                                                if (serverCertificates != null && serverCertificates.length > 0) {
                                                    returnIOEx = new SSLCommunicationException((SSLException)connectIOEx, serverCertificates);
                                                }
                                                break block47;
                                            }
                                            catch (Throwable th) {
                                                AbstractSnoopRequestJobStep.LOGGER.debug("Fetching the servers Certificates failed.", th);
                                            }
                                            break block47;
                                        }
                                        responseCode = httpURLConnection.getResponseCode();
                                        if (responseCode == 200) break block47;
                                        msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                                        msg = String.valueOf(msg) + "Response Headers:\n";
                                        ** for (headerField : httpURLConnection.getHeaderFields().entrySet())
                                    }
                                }
                                catch (Throwable var6_44) {
                                    if (connectIOEx != null && httpURLConnection instanceof HttpsURLConnection && connectIOEx instanceof SSLException) {
                                        try {
                                            httpsURLConnection = (HttpsURLConnection)serverURL.openConnection();
                                            serverCertificates = AbstractSnoopRequestJobStep.getServerCertificates(httpsURLConnection);
                                            if (serverCertificates != null && serverCertificates.length > 0) {
                                                returnIOEx = new SSLCommunicationException((SSLException)connectIOEx, serverCertificates);
                                            }
                                            break block48;
                                        }
                                        catch (Throwable th) {
                                            AbstractSnoopRequestJobStep.LOGGER.debug("Fetching the servers Certificates failed.", th);
                                        }
                                        break block48;
                                    }
                                    responseCode = httpURLConnection.getResponseCode();
                                    if (responseCode == 200) break block48;
                                    msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                                    msg = String.valueOf(msg) + "Response Headers:\n";
                                    ** for (headerField : httpURLConnection.getHeaderFields().entrySet())
                                }
lbl-1000:
                                // 1 sources

                                {
                                    msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                                    values = headerField.getValue();
                                    if (values == null) continue;
                                    for (String value : values) {
                                        msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                                    }
                                    continue;
                                }
lbl51:
                                // 1 sources

                                AbstractSnoopRequestJobStep.LOGGER.debug(msg);
                                connectionErrorStream = httpURLConnection.getErrorStream();
                                if (connectionErrorStream != null) {
                                    try {
                                        byteArrayOutputStream = new ByteArrayOutputStream();
                                        DataCopyHelper.copyFile((InputStream)connectionErrorStream, (OutputStream)byteArrayOutputStream);
                                        responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                                        AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: " + responseContentAsString);
                                    }
                                    catch (JvmExternalResourceInteractionException e) {
                                        AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", (Throwable)e);
                                    }
                                } else {
                                    AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: <empty error stream>");
                                }
                            }
                            if (returnIOEx != null) {
                                throw returnIOEx;
                            }
                            break block51;
lbl-1000:
                            // 1 sources

                            {
                                msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                                values = headerField.getValue();
                                if (values == null) continue;
                                for (String value : values) {
                                    msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                                }
                                continue;
                            }
lbl92:
                            // 1 sources

                            AbstractSnoopRequestJobStep.LOGGER.debug(msg);
                            connectionErrorStream = httpURLConnection.getErrorStream();
                            if (connectionErrorStream != null) {
                                try {
                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                    DataCopyHelper.copyFile((InputStream)connectionErrorStream, (OutputStream)byteArrayOutputStream);
                                    responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                                    AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: " + responseContentAsString);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", (Throwable)e);
                                }
                            } else {
                                AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: <empty error stream>");
                            }
                        }
                        if (returnIOEx != null) {
                            throw returnIOEx;
                        }
                        throw var6_44;
                    }
                    if (connectIOEx != null && httpURLConnection instanceof HttpsURLConnection && connectIOEx instanceof SSLException) {
                        try {
                            httpsURLConnection = (HttpsURLConnection)serverURL.openConnection();
                            serverCertificates = AbstractSnoopRequestJobStep.getServerCertificates(httpsURLConnection);
                            if (serverCertificates != null && serverCertificates.length > 0) {
                                returnIOEx = new SSLCommunicationException((SSLException)connectIOEx, serverCertificates);
                            }
                        }
                        catch (Throwable th) {
                            AbstractSnoopRequestJobStep.LOGGER.debug("Fetching the servers Certificates failed.", th);
                        }
                    } else {
                        responseCode = httpURLConnection.getResponseCode();
                        if (responseCode != 200) {
                            msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                            msg = String.valueOf(msg) + "Response Headers:\n";
                            for (Map.Entry<String, List<String>> headerField : httpURLConnection.getHeaderFields().entrySet()) {
                                msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                                values = headerField.getValue();
                                if (values == null) continue;
                                for (String value : values) {
                                    msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                                }
                            }
                            AbstractSnoopRequestJobStep.LOGGER.debug(msg);
                            connectionErrorStream = httpURLConnection.getErrorStream();
                            if (connectionErrorStream != null) {
                                try {
                                    byteArrayOutputStream = new ByteArrayOutputStream();
                                    DataCopyHelper.copyFile((InputStream)connectionErrorStream, (OutputStream)byteArrayOutputStream);
                                    responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                                    AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: " + responseContentAsString);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", (Throwable)e);
                                }
                            } else {
                                AbstractSnoopRequestJobStep.LOGGER.debug("Returned ErrorStream contents: <empty error stream>");
                            }
                        }
                    }
                    if (returnIOEx != null) {
                        throw returnIOEx;
                    }
                }
                SunJvmBug6514454Workaround.fixHttpsClientSetup(serverURL);
                responseStream = httpURLConnection.getInputStream();
                responseContentBytes = HTTPUtil.copyResponseStreamToByteArrayOutputStream(responseStream);
                if (responseContentBytes != null && "SNOOP_RESPONSE_CONTENT".equalsIgnoreCase(responseContentBytes.toString("UTF-8"))) {
                    encodedUsername = httpURLConnection.getHeaderField("AuthenticatedUser");
                    if (encodedUsername != null) {
                        this.authenticatedUsersName = URLDecoder.decode(encodedUsername, "UTF-8");
                    }
                    this.observedAuthType = (encodedAuthType = httpURLConnection.getHeaderField("ObservedAuthType")) != null ? URLDecoder.decode(encodedAuthType, "UTF-8") : "NO_AUTH";
                    break block50;
                }
                alienHTTPResponseException = AlienHTTPResponseException.createInstance(httpURLConnection, responseContentBytes);
                AbstractSnoopRequestJobStep.LOGGER.error((Throwable)alienHTTPResponseException);
                throw alienHTTPResponseException;
            }
            catch (IOException e) {
                this.ioException = e;
            }
            catch (IllegalArgumentException e) {
                this.ioException = new IOException("Wrapped IllegalArgumentException: " + e.getLocalizedMessage());
                this.ioException.setStackTrace(e.getStackTrace());
            }
        }
    }

    public static Certificate[] getServerCertificates(HttpsURLConnection conn) {
        BlindTrustSocketFactory blindTrust = null;
        try {
            blindTrust = new BlindTrustSocketFactory();
        }
        catch (Throwable th) {
            LOGGER.debug("Can not getServerCertificates() because initialization of BlindTrustSocketFactory failed.", th);
            return null;
        }
        try {
            conn.setSSLSocketFactory(blindTrust);
            conn.setInstanceFollowRedirects(false);
            conn.setAllowUserInteraction(false);
            conn.connect();
        }
        catch (Throwable th) {
            LOGGER.debug("Problem while connecting to the server for downloading its Certificates.", th);
        }
        try {
            return conn.getServerCertificates();
        }
        catch (Throwable th) {
            LOGGER.debug("No Certificates could be downloaded.", th);
            return null;
        }
    }

    @Override
    public String getAuthenticatedUsersName() {
        this.waitUntilRequestIsProcessed(0L);
        return this.authenticatedUsersName;
    }

    @Override
    public PSCAuthenticator.RequestorInfo getAuthenticationRequestor() {
        this.waitUntilRequestIsProcessed(0L);
        return this.authenticationRequestor;
    }

    @Override
    public void throwTransmissionExceptions() throws IOException {
        this.waitUntilRequestIsProcessed(0L);
        if (this.ioException != null) {
            throw this.ioException;
        }
    }
}

