/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.PSCEffectiveLicenseInfo;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServer;
import de.plans.psc.shared.message.EOServerInfo;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import java.net.PasswordAuthentication;

public abstract class ServerConnection {
    private static final ILogger logger = Logger.getLogger(ServerConnection.class);
    public static final int LOG_CATEGORY = 171;
    private final String serverID;
    private String serverName;
    private String serverURL;
    private int timerInterval;
    private EOServerInfo serverInfo;
    private EOUserAndGroupAndPermissions userData;
    private PSCEffectiveLicenseInfo licenseInfo;
    private final RequestForwarder requestForwarder;

    public static boolean transmitPasswordsAsCleartext() {
        String sysPropName = "cockpit.transmitPasswordsAsCleartext";
        String sysPropValue = null;
        try {
            sysPropValue = System.getProperty(sysPropName, Boolean.FALSE.toString());
        }
        catch (Throwable th) {
            logger.debug(171, "unable to read System Property " + sysPropName, th);
        }
        return Boolean.parseBoolean(sysPropValue);
    }

    public ServerConnection(EOServer serverData, RequestForwarder requestForwarder) {
        this.serverID = serverData.getServerID();
        this.serverName = serverData.getServerName();
        this.serverURL = serverData.getServerURL();
        this.timerInterval = serverData.getTimerInterval();
        this.requestForwarder = requestForwarder;
    }

    public void shutdownAndFreeResources() {
    }

    public String getURL() {
        return this.serverURL;
    }

    public void setURL(String s) {
        this.serverURL = s;
    }

    public int getTimerInterval() {
        return this.timerInterval;
    }

    public void setTimerInterval(int interval) {
        this.timerInterval = interval;
    }

    public abstract String getUserName();

    public String getServerID() {
        return this.serverID;
    }

    public EOServer getServerData() {
        return this.requestForwarder.getServerConfigurationParameters(this.serverID);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public boolean isConnected() {
        return this.requestForwarder.isConnected(this);
    }

    public EOUserAndGroupAndPermissions getUserData() {
        return this.userData;
    }

    public void setUserData(EOUserAndGroupAndPermissions u) {
        this.userData = u;
    }

    public PSCEffectiveLicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public void setLicenseInfo(PSCEffectiveLicenseInfo licenseInfo) {
        this.licenseInfo = licenseInfo;
    }

    public EOServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(EOServerInfo si) {
        this.serverInfo = si;
    }

    protected abstract void startNotificationEnquiry();

    protected abstract void stopNotificationEnquiry();

    protected abstract ServerNotAvailableException translateTransmissionException(EOClientRequest var1, Exception var2, boolean var3);

    protected abstract ISnoopRequestJob chargeSnoopRequest();

    protected abstract IRequestJob chargeLoginRequest(PSCApplicationIdentifier var1, PSCClientLicenseInfo var2, PasswordAuthentication var3, PSCAuthenticator.RequestorInfo var4, String var5, String var6);

    protected abstract IRequestJob chargeRequest(EOClientRequest var1);

    protected abstract IRequestJob chargeDisconnectRequest();

    public abstract String getDirectoryType();

    public abstract String getDirectoryNameOrURL();

    public abstract String getDistinguishedName();

    public abstract String getLoginID();

    public abstract String getRealName();

    public abstract String getClientLocation();
}

