/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.parameter.EOParameterSetRoot;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.EOClientParameter;
import de.plans.psc.client.PSCAbstractGUIFactory;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLogMgr;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.dialogs.CtrlLogin;
import de.plans.psc.client.dialogs.DlgLoginIF;
import de.plans.psc.client.dialogs.admin.CtrlAdminGroups;
import de.plans.psc.client.dialogs.admin.CtrlAdminUsers;
import de.plans.psc.client.dialogs.admin.CtrlChangePassword;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import de.plans.psc.shared.serverexceptions.PSCAbstractExceptionDecoder;
import java.io.File;
import java.io.FileNotFoundException;

public abstract class PSCAbstractClientFactory
implements IEncodableObjectFactory {
    private static final ILogger logger = Logger.getLogger(PSCAbstractClientFactory.class);
    protected static PSCAbstractClientFactory cf;
    protected PSCAbstractGUIFactory guiFactory;
    protected RequestForwarder requestForwarder;
    protected XMLConfigParameterMgr parameterMgr;
    File rootDir;
    private final EOClientParameter clientParameter = new EOClientParameter();
    private final PSCAbstractExceptionDecoder exceptionDecoder;
    private PSCClientLogMgr logMgr;
    private final PSCAbstractMessageDataFactory msgFactory;
    private CtrlAdminUsers userAdminDialog;
    private CtrlAdminGroups groupAdminDialog;
    private CtrlChangePassword changePasswordDialog;

    protected PSCAbstractClientFactory(PSCAbstractGUIFactory guiFactory, PSCAbstractMessageDataFactory msgFactory, PSCAbstractExceptionDecoder exceptionDecoder) {
        this.guiFactory = guiFactory;
        this.msgFactory = msgFactory;
        this.exceptionDecoder = exceptionDecoder;
        cf = this;
    }

    protected PSCClientServiceFacade setUpClient() {
        this.createStaticObjects();
        this.registerParameterSets();
        this.loadParameters();
        PSCClientServiceFacade serviceFacade = this.constructClient();
        this.startClient();
        return serviceFacade;
    }

    protected PSCClientServiceFacade setUpClient(File rootDir) {
        this.rootDir = rootDir;
        this.createStaticObjects();
        this.registerParameterSets();
        this.loadParameters();
        PSCClientServiceFacade serviceFacade = this.constructClient();
        this.startClient();
        return serviceFacade;
    }

    public static PSCAbstractClientFactory getClientFactory() {
        return cf;
    }

    protected void createStaticObjects() {
        this.requestForwarder = new RequestForwarder();
        this.parameterMgr = new XMLConfigParameterMgr();
        this.logMgr = new PSCClientLogMgr();
        this.userAdminDialog = new CtrlAdminUsers(this.guiFactory.getAdminDialogFactory());
        this.groupAdminDialog = new CtrlAdminGroups(this.guiFactory.getAdminDialogFactory());
        this.changePasswordDialog = new CtrlChangePassword(this.guiFactory.getAdminDialogFactory());
        this.createStaticApplObjects();
    }

    protected void registerParameterSets() {
        this.parameterMgr.setRootElement((EOParameterSetRoot)this.clientParameter);
        this.parameterMgr.registerEncodableObjectFactory(this.clientParameter.getTag(), (IEncodableObjectFactory)this);
        this.logMgr.registerParameterSets(this.parameterMgr);
        this.requestForwarder.registerParameterSets(this.parameterMgr);
        this.registerApplParameterSets();
    }

    protected void loadParameters() {
        File pFile = null;
        String pFileName = System.getProperty(this.getParameterFilePropertyName());
        pFile = pFileName != null ? new File(pFileName) : (this.rootDir != null ? new File(this.rootDir, this.getDefaultParameterFileName()) : new File(System.getProperty("user.home"), this.getDefaultParameterFileName()));
        this.loadParameters(pFile);
    }

    protected void loadParameters(File pFile) {
        this.parameterMgr.setParameterFile(pFile);
        if (pFile.exists()) {
            try {
                this.parameterMgr.readParameters();
                this.logMgr.setup();
                if (logger.isDebugEnabled()) {
                    logger.debug("loadParameters() - Loaded parameters from file:" + pFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                this.logMgr.constructWithDefaults(this.getApplicationIdentifier());
                logger.error("loadParameters() - Could not find parameter file.", (Throwable)e);
            }
            catch (EXDecoderException e) {
                this.logMgr.constructWithDefaults(this.getApplicationIdentifier());
                logger.error("loadParameters() - Could not read parameter file.", (Throwable)e);
            }
        } else {
            this.logMgr.constructWithDefaults(this.getApplicationIdentifier());
            logger.debug("loadParameters() - Could not find parameter file. Using defaults." + this.getApplicationIdentifier().getApplicationId());
        }
    }

    private String getParameterFilePropertyName() {
        return String.valueOf(this.getApplicationIdentifier().getApplicationId()) + ".param";
    }

    private String getDefaultParameterFileName() {
        return String.valueOf(this.getApplicationIdentifier().getApplicationId()) + ".xml";
    }

    public EncodableObjectBase createEncodableObject(String elementName, XMLContext context) throws EXDecoderException {
        if (this.clientParameter.getTag().equals(elementName)) {
            return this.clientParameter;
        }
        return null;
    }

    protected PSCClientServiceFacade constructClient() {
        this.requestForwarder.construct(this.msgFactory, this.exceptionDecoder, this.guiFactory, this.getApplicationIdentifier());
        PSCClientServiceFacade serviceFacade = new PSCClientServiceFacade();
        serviceFacade.construct(this.requestForwarder, this.parameterMgr, this.rootDir, this.getApplicationIdentifier());
        this.userAdminDialog.construct();
        this.groupAdminDialog.construct();
        this.changePasswordDialog.construct();
        return serviceFacade;
    }

    protected void startClient() {
        this.startAppl();
    }

    public RequestForwarder getRequestForwarder() {
        return this.requestForwarder;
    }

    public PSCClientLogMgr getClientLogMgr() {
        return this.logMgr;
    }

    protected abstract void createStaticApplObjects();

    protected abstract void registerApplParameterSets();

    protected abstract void constructApplClient();

    protected abstract void startAppl();

    protected abstract PSCApplicationIdentifier getApplicationIdentifier();

    public CtrlLogin getLoginDialog() {
        DlgLoginIF dlg = this.guiFactory.getLoginDialog();
        CtrlLogin ctrl = new CtrlLogin(dlg);
        return ctrl;
    }
}

