/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.eclipse;

import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PlugInClassExtensionFactory {
    private final boolean useCache;
    private final String classAttributeName;
    private final HashMap extensions = new HashMap();
    private HashMap objectCache;

    public PlugInClassExtensionFactory(boolean useCache, String plugInID, String extensionPointID, String keyAttributeName, String classAttributeName) throws PlugInClassExtensionFactoryException {
        assert (plugInID != null) : "plugInID must not be null";
        assert (extensionPointID != null) : "extensionPointID must not be null";
        assert (keyAttributeName != null) : "keyAttributeName must not be null";
        assert (classAttributeName != null) : "classAttributeName must not be null";
        this.useCache = useCache;
        this.fetchExtensions(plugInID, extensionPointID, keyAttributeName);
        if (useCache) {
            this.objectCache = new HashMap();
        }
        this.classAttributeName = classAttributeName;
    }

    private void fetchExtensions(String plugInID, String extensionPointID, String keyAttributeName) throws PlugInClassExtensionFactoryException {
        IExtension[] extensions_;
        assert (plugInID != null) : "plugInID must not be null";
        assert (extensionPointID != null) : "extensionPointID must not be null";
        assert (keyAttributeName != null) : "keyAttributeName must not be null";
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(plugInID, extensionPointID);
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions_ = extensionPoint.getExtensions();
        int n = extensions_.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                String key = currentConfigElement.getAttribute(keyAttributeName);
                if (key == null) {
                    throw new PlugInClassExtensionFactoryException("Attribute " + keyAttributeName + " either empty or omitted");
                }
                if (this.extensions.containsKey(key)) {
                    throw new PlugInClassExtensionFactoryException("Duplicate registration of classes for type " + key + ". Only first is considered.");
                }
                this.extensions.put(key, currentConfigElement);
                ++n4;
            }
            ++n2;
        }
    }

    public Object create(String key) throws PlugInClassExtensionFactoryException, CoreException {
        assert (key != null) : "key must not ne null";
        Object instance = null;
        if (this.useCache) {
            instance = this.objectCache.get(key);
        }
        if (instance == null) {
            IConfigurationElement extension = (IConfigurationElement)this.extensions.get(key);
            if (extension == null) {
                throw new PlugInClassExtensionFactoryException("No extension registered for " + key);
            }
            instance = extension.createExecutableExtension(this.classAttributeName);
        }
        if (this.useCache) {
            this.objectCache.put(key, instance);
        }
        return instance;
    }

    public Collection getRegisteredExtensions() {
        return this.extensions.keySet();
    }
}

