/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.Collection;

public class SingleChoiceWidgetSingleChoicePropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(SingleChoiceWidgetSingleChoicePropertyWidgetAdapter.class);
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public SingleChoiceWidgetSingleChoicePropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        String value = (String)this.playground.getValue();
        IList_ valueRange = this.playground.getValueRange();
        SortedSet_ enumerationItems = new SortedSet_((IComparator_)new IComparator_<EnumerationItem>(){

            public int getHashCode(EnumerationItem enumerationItem) {
                return 0;
            }

            public int sgn(EnumerationItem enumerationItem1, EnumerationItem enumerationItem2) {
                return 1;
            }
        });
        if (!valueRange.isEmpty()) {
            enumerationItems.add((Object)new EnumerationItem(null, "", null, false));
        }
        for (String key : valueRange) {
            boolean checked = false;
            if (key.equals(value)) {
                checked = true;
            }
            enumerationItems.add((Object)new EnumerationItem(key, this.playground.getLabel(key), null, checked));
        }
        return enumerationItems;
    }

    public IHasher_<Object> getKeyHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            String selectedKey = (String)widget.getCurrentValue();
            this.playground.setValue(selectedKey, this);
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            this.playground.setError(new PlaygroundError(IMessageLevel.NORMAL, new ConstantTextProvider(e.getLocalizedMessage())));
            logger.error("Wrong value in single choice widget for enumerations.", (Throwable)e);
        }
    }
}

