/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.parameters.DateWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.Collection;
import java.util.Date;

public class DateWidgetDatePropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(DateWidgetDatePropertyWidgetAdapter.class);
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public DateWidgetDatePropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public IDataWidget createWidget(IWidgetTypeID widgetTypeID, WidgetFactoryController widgetFactory, WidgetParameters parameters, ICompositeWidget parentWidget) {
        DateWidgetParameters dateWidgetParameters = new DateWidgetParameters(parameters.getLabel(), parameters.getTooltip(), parameters.isEditable(), this.playground.isWithTimeComponent(), parameters.getColSpan(), parameters.getRowSpan(), parameters.showLabel());
        return super.createWidget(widgetTypeID, widgetFactory, dateWidgetParameters, parentWidget);
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        return this.playground.getValue();
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        try {
            this.removeWidgetAdapterError();
            Date newValue = (Date)widget.getCurrentValue();
            this.playground.setValue(newValue, this);
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            this.playground.setError(new PlaygroundError(IMessageLevel.NORMAL, new ConstantTextProvider(e.getLocalizedMessage())));
            logger.error("Wrong value in date widget.", (Throwable)e);
        }
    }
}

