/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor;

import com.arcway.lib.Messages;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.IEditorClosingDecider;
import com.arcway.lib.ui.editor.IEditorController;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.UITypeID;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.WidgetReference;
import com.arcway.lib.ui.editor.datatype.EditorMessageWithoutText;
import com.arcway.lib.ui.editor.datatype.IComplexWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IEditor;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.INonPageWidget;
import com.arcway.lib.ui.editor.datatype.IPageWidget;
import com.arcway.lib.ui.editor.datatype.IPropertyOrCategoryWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.IRelationWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.datatype.IWidget;
import com.arcway.lib.ui.editor.datatype.IWidgetAdapterFactory;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXRepositoryException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.manager.PlaygroundFactoryManager;
import com.arcway.lib.ui.editor.manager.WidgetAdapterFactoryManager;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.IObjectTypeCategoryPlaygroundFactory;
import com.arcway.lib.ui.editor.playground.IPropertyPlaygroundFactory;
import com.arcway.lib.ui.editor.playground.IRelationPlayground;
import com.arcway.lib.ui.editor.playground.IRelationPlaygroundFactory;
import com.arcway.lib.ui.editor.playground.ObjectTypeCategoryPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.playground.RelationPlayground;
import com.arcway.lib.ui.editor.test.IEditorFrameworkTestManager;
import com.arcway.lib.ui.editor.widgetAdapter.IComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import com.arcway.lib.ui.editor.widgetAdapter.WidgetAdapterError;
import com.arcway.lib.ui.modelaccess.ILayout;
import com.arcway.lib.ui.modelaccess.IModelAccess;
import com.arcway.lib.ui.modelaccess.IModelAccessListener;
import com.arcway.lib.ui.modelaccess.agent.IContentReferenceInterpreter;
import com.arcway.lib.ui.window.IWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class PlaygroundManager<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE>
implements IEditorController,
IPlaygroundManager,
IWidgetAdapterManager,
IModelAccessListener,
IEditorFrameworkTestManager {
    private static final ILogger logger = Logger.getLogger(PlaygroundManager.class);
    private final IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccess;
    private final IEditorClosingDecider editorClosingDecider;
    private final IMapRW_<PROPERTY_REFERENCE, PropertyPlayground<?, ?, ?, ?>> propertyPlaygrounds;
    private final IMapRW_<OBJECT_TYPE_CATEGORY_REFERENCE, ObjectTypeCategoryPlayground<?, ?, ?, ?>> objectTypeCategoryPlaygrounds;
    private final IMapRW_<Object, IRelationPlayground> relationPlaygrounds;
    private final WidgetFactoryController widgetFactory;
    private final IEditor editor;
    private final ILayout layout;
    private final Collection<IPageWidget> pages = new ArrayList<IPageWidget>();
    private boolean isModificationLocked;
    private boolean isDirty = false;
    private ITextProvider lockMessage;
    private final HashMap<Object, Tuple<List<String>, IEditorMessage>> errors = new HashMap();
    private final Map<IWidgetAdapter, ITextProvider> closeVetos = new HashMap<IWidgetAdapter, ITextProvider>();
    private static final WidgetFactoryController testWidgetFactory = new WidgetFactoryController(UITypeID.TESTEDITOR);
    private final Iterable<IEditorPlayground<?>> ALL_PLAYGROUNDS_ITERABLE = new Iterable<IEditorPlayground<?>>(){

        @Override
        public Iterator<IEditorPlayground<?>> iterator() {
            return new Iterator<IEditorPlayground<?>>(){
                private int currentState = 0;
                private Iterator<? extends IEditorPlayground<?>> currentCollection = null;

                @Override
                public boolean hasNext() {
                    this.switchToNextCollectionIfNecessary();
                    return this.currentState != -1;
                }

                @Override
                public IEditorPlayground<?> next() {
                    this.switchToNextCollectionIfNecessary();
                    if (this.currentState != -1) {
                        return this.currentCollection.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private void switchToNextCollectionIfNecessary() {
                    while (this.currentState == 0 || this.currentState != -1 && !this.currentCollection.hasNext()) {
                        if (this.currentState == 0) {
                            this.currentCollection = PlaygroundManager.this.objectTypeCategoryPlaygrounds.values().iterator();
                            ++this.currentState;
                            continue;
                        }
                        if (this.currentState == 1) {
                            this.currentCollection = PlaygroundManager.this.propertyPlaygrounds.values().iterator();
                            ++this.currentState;
                            continue;
                        }
                        if (this.currentState == 2) {
                            this.currentCollection = PlaygroundManager.this.relationPlaygrounds.values().iterator();
                            ++this.currentState;
                            continue;
                        }
                        if (this.currentState != 3) continue;
                        this.currentState = -1;
                    }
                }
            };
        }
    };

    public PlaygroundManager(IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccess, ILayout layout, WidgetFactoryController widgetFactory, IEditor editor, IEditorClosingDecider editorClosingDecider) {
        this.modelAccess = modelAccess;
        this.layout = layout;
        this.editorClosingDecider = editorClosingDecider;
        modelAccess.setupModelAccessListener(this);
        this.widgetFactory = widgetFactory;
        this.editor = editor;
        IContentReferenceInterpreter contentReferenceInterpreter = modelAccess.getContentReferenceInterpreter();
        this.propertyPlaygrounds = new HashMap_(contentReferenceInterpreter.getPropertyReferenceHasher());
        this.objectTypeCategoryPlaygrounds = new HashMap_(contentReferenceInterpreter.getObjectTypeCategoryReferenceHasher());
        this.relationPlaygrounds = new HashMap_(contentReferenceInterpreter.getRelationTypeIDHasher());
        this.createStartupRelations(modelAccess.getInitialRelationSamples());
        this.updatePresentationContext();
    }

    private void createStartupRelations(ICollection_<? extends Object> relationSamplesForInitialRelations) {
        for (Object relationSample : relationSamplesForInitialRelations) {
            Object relationTypeID = this.modelAccess.getContentReferenceInterpreter().getRelationTypeIDFromRelationSample(relationSample);
            RelationPlayground playground = (RelationPlayground)this.getRelationPlaygroundForRelationTypeID(relationTypeID);
            playground.addRelation(relationSample);
        }
    }

    @Override
    public void dispose(boolean isEditorClosing) {
        for (IPageWidget iPageWidget : this.pages) {
            iPageWidget.disposeContents(isEditorClosing);
        }
        for (IEditorPlayground iEditorPlayground : this.ALL_PLAYGROUNDS_ITERABLE) {
            iEditorPlayground.dispose();
        }
    }

    private void setDirty(boolean newDirty) {
        if (newDirty != this.isDirty) {
            this.isDirty = newDirty;
            this.editor.dirtyChanged();
        }
        this.editor.updateInfoLabel();
    }

    @Override
    public boolean save() {
        if (!this.hasError() && !this.hasCloseVetos()) {
            try {
                this.modelAccess.getModelChangeExecutionAgent().executeTransactions();
                this.isDirty = false;
                this.editor.turnCreateEditorToEditEditor();
                return true;
            }
            catch (EEXRepositoryAccessException e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.ERROR_WHILE_SAVING, new PlaygroundError(IMessageLevel.NORMAL, this.getMessageForException(e)));
                return false;
            }
            catch (EEXNotReproducibleSnapshot e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.FATAL_ERROR, new PlaygroundError(e));
                return false;
            }
            catch (EEXSnapshotClosed e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.FATAL_ERROR, new PlaygroundError(e));
                return false;
            }
        }
        this.handlePlaygroundManagerError(PlaygroundManagerError.SAVING_NOT_POSSIBLE, new EditorMessageWithoutText(IMessageLevel.NORMAL));
        return false;
    }

    private void handlePlaygroundManagerError(PlaygroundManagerError errorType, IEditorMessage message) {
        List labels = Collections.emptyList();
        Tuple labelsAndMessage = new Tuple(labels, (Object)message);
        this.errors.put((Object)errorType, (Tuple<List<String>, IEditorMessage>)labelsAndMessage);
        this.editor.updateInfoLabel();
        this.editor.bringToTop();
    }

    @Override
    public void reset() {
        this.modelAccess.getModelChangeExecutionAgent().reset();
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            playground.removeError();
            playground.updateAdapters(null);
        }
        this.errors.clear();
    }

    @Override
    public Collection<IPageWidget> createWidgetTree() {
        this.pages.clear();
        for (WidgetReference widgetReference : this.layout.getLayout()) {
            IWidget page = this.createWidgetTree(widgetReference, null);
            assert (page instanceof IPageWidget);
            this.pages.add((IPageWidget)page);
        }
        if (this.editor.needsLocks()) {
            this.getLocks();
        }
        this.playgroundDataChanged(true);
        return this.pages;
    }

    private IWidget createWidgetTree(WidgetReference widgetReference, ICompositeWidget parentWidget) {
        IWidget widget = this.createWidget(widgetReference, parentWidget);
        if (!widgetReference.getChildren().isEmpty()) {
            assert (widget instanceof ICompositeWidget);
            ICompositeWidget compositeWidget = (ICompositeWidget)widget;
            for (WidgetReference childWidgetReference : widgetReference.getChildren()) {
                IWidget childWidget = this.createWidgetTree(childWidgetReference, compositeWidget);
                assert (childWidget instanceof INonPageWidget);
                compositeWidget.addChildWidget((INonPageWidget)childWidget);
            }
        }
        return widget;
    }

    private IWidget createWidget(WidgetReference widgetReference, ICompositeWidget parentWidget) {
        IWidgetAdapterFactory widgetAdapterFactory;
        IWidgetTypeID widgetTypeID = widgetReference.getWidgetTypeID();
        IContentReferenceInterpreter contentReferenceInterpreter = this.modelAccess.getContentReferenceInterpreter();
        WidgetAdapterFactoryManager widgetAdapterFactoryManager = WidgetAdapterFactoryManager.getInstance();
        Collection<?> references = widgetReference.getContentReferences();
        ArrayList<IEditorPlayground> playgrounds = new ArrayList<IEditorPlayground>();
        ArrayList<String> editorDataTypeIDs = new ArrayList<String>();
        boolean isRelationsReference = false;
        Object singleRelationsReference = null;
        if (references != null && !references.isEmpty()) {
            for (Object reference : references) {
                if (contentReferenceInterpreter.referenceIsPropertyReference(reference)) {
                    Object propertyReference = reference;
                    playgrounds.add(this.getPropertyPlayground(propertyReference));
                    editorDataTypeIDs.add(contentReferenceInterpreter.getEditorDataTypeID(propertyReference));
                    continue;
                }
                if (contentReferenceInterpreter.referenceIsObjectTypeCategoryReference(reference)) {
                    Object objectTypeCategoryReference = reference;
                    playgrounds.add(this.getObjectTypeCategoryPlayground(objectTypeCategoryReference));
                    editorDataTypeIDs.add("objecttypecategory");
                    continue;
                }
                if (contentReferenceInterpreter.referenceIsRelationsReference(reference)) {
                    assert (references.size() == 1) : "More than 1 content reference for a relation widget";
                    isRelationsReference = true;
                    singleRelationsReference = reference;
                    playgrounds.add(this.getRelationPlayground(reference));
                    editorDataTypeIDs.add("relation");
                    continue;
                }
                assert (false) : "Unknown content reference type";
            }
        }
        if ((widgetAdapterFactory = widgetAdapterFactoryManager.findWidgetAdapterFactory(editorDataTypeIDs, widgetTypeID)) != null) {
            IWidgetAdapter widgetAdapter = null;
            if (widgetAdapterFactory instanceof IRelationWidgetAdapterFactory) {
                assert (isRelationsReference);
                widgetAdapter = ((IRelationWidgetAdapterFactory)widgetAdapterFactory).createWidgetAdapter(this, playgrounds, contentReferenceInterpreter.getObjectIDFromRelationsReference(singleRelationsReference), contentReferenceInterpreter.getRoleIDFromRelationsReference(singleRelationsReference));
            } else {
                assert (!isRelationsReference);
                if (widgetAdapterFactory instanceof IPropertyOrCategoryWidgetAdapterFactory) {
                    widgetAdapter = ((IPropertyOrCategoryWidgetAdapterFactory)widgetAdapterFactory).createWidgetAdapter(this, playgrounds);
                } else if (widgetAdapterFactory instanceof IComplexWidgetAdapterFactory) {
                    widgetAdapter = ((IComplexWidgetAdapterFactory)widgetAdapterFactory).createWidgetAdapter(this, playgrounds, widgetAdapterFactoryManager, editorDataTypeIDs, widgetReference.getWidgetParameters().getWidgetSubTypeID());
                }
            }
            Assert.checkArgumentBeeingNotNull(widgetAdapter);
            for (IEditorPlayground editorPlayground : playgrounds) {
                editorPlayground.addWidgetAdapter(widgetAdapter);
            }
            if (widgetAdapter instanceof IDataWidgetAdapter) {
                return widgetAdapter.createWidget(widgetTypeID, this.widgetFactory, widgetReference.getWidgetParameters(), parentWidget);
            }
            if (widgetAdapter instanceof IComplexWidgetAdapter) {
                return ((IComplexWidgetAdapter)widgetAdapter).createWidget(widgetTypeID, this.widgetFactory, widgetReference.getWidgetParameters(), parentWidget);
            }
            assert (false) : "Unknown or invalid widget adapter type";
            return null;
        }
        assert (editorDataTypeIDs.isEmpty());
        return this.widgetFactory.createLayoutWidget(widgetTypeID, widgetReference.getWidgetParameters(), this.getCurrentPresentationContext().getLocale(), parentWidget);
    }

    @Override
    public void updateWidgetMessages() throws EEXNotReproducibleSnapshot {
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            playground.updateWidgetMessages();
        }
    }

    private PropertyPlayground<?, ?, ?, ?> getPropertyPlayground(PROPERTY_REFERENCE reference) {
        PropertyPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> playground = null;
        if (this.propertyPlaygrounds.getByKey(reference) != null) {
            playground = (PropertyPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE>)this.propertyPlaygrounds.getByKey(reference);
        } else {
            PlaygroundFactoryManager playgroundFactoryManager = PlaygroundFactoryManager.getInstance();
            IPropertyPlaygroundFactory factory = playgroundFactoryManager.getPropertyPlaygroundFactory();
            if (factory != null) {
                playground = factory.createPropertyPlayground(reference, this.modelAccess, this);
            }
        }
        this.propertyPlaygrounds.put(reference, (Object)playground);
        return playground;
    }

    private ObjectTypeCategoryPlayground<?, ?, ?, ?> getObjectTypeCategoryPlayground(OBJECT_TYPE_CATEGORY_REFERENCE reference) {
        ObjectTypeCategoryPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> playground = null;
        if (this.objectTypeCategoryPlaygrounds.getByKey(reference) != null) {
            playground = (ObjectTypeCategoryPlayground<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE>)this.objectTypeCategoryPlaygrounds.getByKey(reference);
        } else {
            PlaygroundFactoryManager playgroundFactoryManager = PlaygroundFactoryManager.getInstance();
            IObjectTypeCategoryPlaygroundFactory factory = playgroundFactoryManager.getObjectTypeCategoryPlaygroundFactory();
            if (factory != null) {
                playground = factory.createObjectTypeCategoryPlayground(reference, this.modelAccess, this);
            }
        }
        this.objectTypeCategoryPlaygrounds.put(reference, (Object)playground);
        return playground;
    }

    private IRelationPlayground getRelationPlayground(Object reference) {
        Object relationTypeID = this.modelAccess.getContentReferenceInterpreter().getRelationTypeIDFromRelationsReference(reference);
        return this.getRelationPlaygroundForRelationTypeID(relationTypeID);
    }

    private IRelationPlayground getRelationPlaygroundForRelationTypeID(Object relationTypeID) {
        IRelationPlayground playground = (IRelationPlayground)this.relationPlaygrounds.getByKey(relationTypeID);
        if (playground == null) {
            PlaygroundFactoryManager playgroundFactoryManager = PlaygroundFactoryManager.getInstance();
            IRelationPlaygroundFactory factory = playgroundFactoryManager.getRelationPlaygroundFactory();
            if (factory != null) {
                playground = factory.createRelationPlayground(relationTypeID, this.modelAccess, this);
                for (Object subRelationTypeID : this.modelAccess.getContentReferenceInterpreter().getSubRelationTypes(relationTypeID)) {
                    IRelationPlayground subRelationPlayground = this.getRelationPlaygroundForRelationTypeID(subRelationTypeID);
                    if (subRelationPlayground == null) continue;
                    playground.addSubRelationPlayground(subRelationTypeID, subRelationPlayground);
                    subRelationPlayground.setSuperRelationPlayground(playground);
                }
            }
            this.relationPlaygrounds.put(relationTypeID, (Object)playground);
        }
        return playground;
    }

    @Override
    public void playgroundDataChanged(boolean hasInfluenceOnPlaygroundVisibility) {
        boolean newDirtyState = false;
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            if (playground.valueSet()) {
                newDirtyState = true;
            }
            if (!playground.hasError()) continue;
            this.errorInPlayground(playground, playground.getError());
            newDirtyState = true;
            break;
        }
        this.checkIfPlaygroundManagerErrorsCanBeRemoved();
        this.setDirty(newDirtyState);
        if (hasInfluenceOnPlaygroundVisibility) {
            this.setPlaygroundVisibility();
        }
    }

    private void checkIfPlaygroundManagerErrorsCanBeRemoved() {
        boolean containsNonFatalPlaygroundManagerErrorsOnly = true;
        HashSet<PlaygroundManagerError> nonFatalPlaygroundManagerErrorsFound = new HashSet<PlaygroundManagerError>(PlaygroundManagerError.values().length);
        if (this.hasCloseVetos()) {
            containsNonFatalPlaygroundManagerErrorsOnly = false;
        } else {
            for (Map.Entry<Object, Object> entry : this.errors.entrySet()) {
                if (entry.getKey() instanceof PlaygroundManagerError && !((PlaygroundManagerError)((Object)entry.getKey())).isFatal()) {
                    nonFatalPlaygroundManagerErrorsFound.add((PlaygroundManagerError)((Object)entry.getKey()));
                    continue;
                }
                containsNonFatalPlaygroundManagerErrorsOnly = false;
                break;
            }
        }
        if (containsNonFatalPlaygroundManagerErrorsOnly) {
            for (PlaygroundManagerError playgroundManagerError : nonFatalPlaygroundManagerErrorsFound) {
                this.errors.remove((Object)playgroundManagerError);
            }
        }
    }

    public void refreshAllPlaygrounds() {
        this.updatePresentationContext();
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            playground.refreshPlayground();
            if (!playground.hasError()) continue;
            this.errorInPlayground(playground, playground.getError());
        }
    }

    private void setPlaygroundVisibility() {
        for (IEntry_ pair_propertyReference_propertyPlayground : this.propertyPlaygrounds) {
            try {
                boolean isPlaygroundVisible = this.modelAccess.getCurrentModelAndModificationsAccessAgent().isPropertyVisibleForCurrentCategory(pair_propertyReference_propertyPlayground.getKey());
                ((PropertyPlayground)pair_propertyReference_propertyPlayground.getValue()).setVisible(isPlaygroundVisible);
            }
            catch (EEXObjectReferenceCannotBeResolved e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.FATAL_ERROR, new PlaygroundError(IMessageLevel.NORMAL, this.getMessageForException(e)));
            }
            catch (EEXSnapshotClosed e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.FATAL_ERROR, new PlaygroundError(e));
            }
            catch (EEXNotReproducibleSnapshot e) {
                this.handlePlaygroundManagerError(PlaygroundManagerError.FATAL_ERROR, new PlaygroundError(e));
            }
        }
        for (IPageWidget page : this.pages) {
            page.recreatePageWidget();
        }
    }

    @Override
    public Locale getContentLocale() {
        return this.modelAccess.getContentLocale();
    }

    @Override
    public PresentationContext getCurrentPresentationContext() {
        return this.editor.getCurrentPresentationContext();
    }

    @Override
    public ITextProvider getMessageForException(EEXRepositoryException e) {
        return this.modelAccess.getMessageForException(e);
    }

    @Override
    public IMessageLevel getErrorLevelForException(EEXRepositoryAccessException e) {
        return this.modelAccess.getErrorLevelForException(e);
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isModificationPermitted() {
        return true;
    }

    @Override
    public boolean isModificationLocked() {
        return this.isModificationLocked;
    }

    @Override
    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public Collection<Tuple<List<String>, IEditorMessage>> getErrors() {
        return this.errors.values();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ThreeTuple<String, IMessageLevel, List<Tuple<List<String>, IEditorMessage>>> getErrorMessagesToDisplay() {
        if (this.hasError() || this.hasCloseVetos()) {
            void var5_15;
            IMessageLevel highestLevel = IMessageLevel.INFORMATION;
            LinkedList<Object> errorMessageList = new LinkedList<Object>();
            ThreeTuple mostImportantPlaygroundManagerError = null;
            ArrayList<ThreeTuple> playgroundManagerErrorsWithMessage = new ArrayList<ThreeTuple>();
            for (Map.Entry<Object, Tuple<List<String>, IEditorMessage>> entry : this.errors.entrySet()) {
                if (entry.getKey() instanceof PlaygroundManagerError) {
                    PlaygroundManagerError playgroundManagerErrorType = (PlaygroundManagerError)((Object)entry.getKey());
                    ThreeTuple playgroundManagerError = new ThreeTuple((Object)playgroundManagerErrorType, (Object)((List)entry.getValue().getT1()), (Object)((IEditorMessage)entry.getValue().getT2()));
                    if (((IEditorMessage)entry.getValue().getT2()).getMessageText(this.getCurrentPresentationContext()) != null) {
                        playgroundManagerErrorsWithMessage.add(playgroundManagerError);
                    }
                    if (mostImportantPlaygroundManagerError == null || ((PlaygroundManagerError)((Object)mostImportantPlaygroundManagerError.getComponent1())).ordinal() > playgroundManagerErrorType.ordinal()) {
                        mostImportantPlaygroundManagerError = playgroundManagerError;
                    }
                } else {
                    errorMessageList.add(entry.getValue());
                }
                if (((IEditorMessage)entry.getValue().getT2()).getMessageLevel().compareTo(highestLevel) <= 0) continue;
                highestLevel = ((IEditorMessage)entry.getValue().getT2()).getMessageLevel();
            }
            for (Tuple tuple : this.getAllCloseVetos()) {
                errorMessageList.add(new Tuple(Collections.singletonList((String)tuple.getT1()), (Object)new WidgetAdapterError(IMessageLevel.INFORMATION, (ITextProvider)tuple.getT2())));
            }
            Collections.sort(playgroundManagerErrorsWithMessage, new Comparator<ThreeTuple<PlaygroundManagerError, List<String>, IEditorMessage>>(){

                @Override
                public int compare(ThreeTuple<PlaygroundManagerError, List<String>, IEditorMessage> o1, ThreeTuple<PlaygroundManagerError, List<String>, IEditorMessage> o2) {
                    return ((PlaygroundManagerError)((Object)o2.getComponent1())).ordinal() - ((PlaygroundManagerError)((Object)o1.getComponent1())).ordinal();
                }
            });
            for (ThreeTuple threeTuple : playgroundManagerErrorsWithMessage) {
                errorMessageList.add(0, new Tuple((Object)((List)threeTuple.getComponent2()), (Object)((IEditorMessage)threeTuple.getComponent3())));
            }
            if (mostImportantPlaygroundManagerError != null) {
                String baseMessage = Messages.getString(((PlaygroundManagerError)((Object)mostImportantPlaygroundManagerError.getComponent1())).getErrorMessageKey(), this.getCurrentPresentationContext().getLocale());
                String errorSpecificMessage = ((IEditorMessage)mostImportantPlaygroundManagerError.getComponent3()).getMessageText(this.getCurrentPresentationContext());
                if (errorSpecificMessage != null) {
                    String string = String.valueOf(baseMessage) + ": " + errorSpecificMessage;
                } else {
                    String string = String.valueOf(baseMessage) + ".";
                }
            } else if (errorMessageList.size() > 1) {
                String string = Messages.getString("Editor.multipleErrors", this.getCurrentPresentationContext().getLocale());
            } else {
                String string = ((IEditorMessage)((Tuple)errorMessageList.iterator().next()).getT2()).getMessageText(this.getCurrentPresentationContext());
            }
            return new ThreeTuple((Object)var5_15, (Object)highestLevel, errorMessageList);
        }
        return null;
    }

    @Override
    public String getLockMessage() {
        return this.lockMessage == null ? null : this.lockMessage.getText(this.getCurrentPresentationContext());
    }

    @Override
    public boolean getLocks() {
        boolean hasLock = true;
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            if (hasLock) {
                try {
                    playground.checkLock();
                    this.lockMessage = null;
                }
                catch (EEXLockDenied e) {
                    this.lockMessage = this.getMessageForException(e);
                    hasLock = false;
                }
                continue;
            }
            playground.setLockMessageText(this.lockMessage);
        }
        this.isModificationLocked = hasLock;
        return this.isModificationLocked;
    }

    @Override
    public void releaseLocks() {
        this.modelAccess.getLockAndPermissionProvider().releaseAllLocks();
        for (IEditorPlayground<?> playground : this.ALL_PLAYGROUNDS_ITERABLE) {
            playground.releaseLock();
        }
    }

    @Override
    public void newSnapshotAvailable() {
        if (this.editorClosingDecider.isEditorToClose()) {
            this.editor.closeEditor(false, false);
        } else {
            this.updatePresentationContext();
            this.editor.refresh(false);
            this.playgroundDataChanged(true);
        }
    }

    @Override
    public void closeModelAccessUI(boolean isEditorClosing) {
        this.editor.closeEditor(false, isEditorClosing);
    }

    private void updatePresentationContext() {
        this.editor.updatePresentationContextToNow();
    }

    @Override
    public IDataWidget createTestWidget(Collection<?> references, IWidgetTypeID widgetTypeID) {
        IContentReferenceInterpreter contentReferenceInterpreter = this.modelAccess.getContentReferenceInterpreter();
        ArrayList<IEditorPlayground> playgrounds = new ArrayList<IEditorPlayground>();
        ArrayList<String> editorDataTypeIDs = new ArrayList<String>();
        boolean isRelationsReference = false;
        PROPERTY_REFERENCE contentReference2 = null;
        for (PROPERTY_REFERENCE contentReference2 : references) {
            if (contentReferenceInterpreter.referenceIsPropertyReference(contentReference2)) {
                PROPERTY_REFERENCE propertyReference = contentReference2;
                playgrounds.add(this.getPropertyPlayground(propertyReference));
                editorDataTypeIDs.add(contentReferenceInterpreter.getEditorDataTypeID(contentReference2));
                continue;
            }
            if (!contentReferenceInterpreter.referenceIsRelationsReference(contentReference2)) continue;
            isRelationsReference = true;
            playgrounds.add(this.getRelationPlayground(contentReference2));
            editorDataTypeIDs.add("relation");
        }
        if (!playgrounds.isEmpty()) {
            WidgetAdapterFactoryManager widgetAdapterFactoryManager = WidgetAdapterFactoryManager.getInstance();
            IWidgetAdapterFactory widgetAdapterFactory = widgetAdapterFactoryManager.findWidgetAdapterFactory(editorDataTypeIDs, widgetTypeID);
            Assert.checkArgumentBeeingNotNull((Object)widgetAdapterFactory);
            IDataWidgetAdapter widgetAdapter = null;
            widgetAdapter = isRelationsReference ? ((IRelationWidgetAdapterFactory)widgetAdapterFactory).createWidgetAdapter(this, playgrounds, contentReferenceInterpreter.getObjectIDFromRelationsReference(contentReference2), contentReferenceInterpreter.getRoleIDFromRelationsReference(contentReference2)) : ((IPropertyOrCategoryWidgetAdapterFactory)widgetAdapterFactory).createWidgetAdapter(this, playgrounds);
            Assert.checkArgumentBeeingNotNull((Object)widgetAdapter);
            for (IEditorPlayground editorPlayground : playgrounds) {
                editorPlayground.addWidgetAdapter(widgetAdapter);
            }
            return widgetAdapter.createTestWidget(widgetTypeID, testWidgetFactory);
        }
        return null;
    }

    @Override
    public void errorInPlayground(IEditorPlayground<?> playground, IEditorMessage playgroundError) {
        if (playgroundError != null) {
            Collection<?> widgetAdapters = playground.getWidgetAdapters();
            ArrayList<String> labels = new ArrayList<String>(widgetAdapters.size());
            for (IWidgetAdapter widgetAdapter : widgetAdapters) {
                String label = widgetAdapter.getWidget().getLabel();
                if (label == null || label.length() <= 0) continue;
                labels.add(label);
            }
            Tuple labelsAndMessage = new Tuple(labels, (Object)playgroundError);
            this.errors.put(playground, (Tuple<List<String>, IEditorMessage>)labelsAndMessage);
        }
    }

    @Override
    public void errorInWidgetAdapter(IWidgetAdapter widgetAdapter, IEditorMessage widgetAdapterError) {
        if (widgetAdapterError != null) {
            String label = widgetAdapter.getWidget().getLabel();
            List<Object> labels = label != null && label.length() > 0 ? Collections.singletonList(label) : Collections.emptyList();
            Tuple labelsAndMessage = new Tuple(labels, (Object)widgetAdapterError);
            this.errors.put(widgetAdapter, (Tuple<List<String>, IEditorMessage>)labelsAndMessage);
            this.editor.updateInfoLabel();
        }
    }

    @Override
    public void removeError(IEditorPlayground<?> playground) {
        this.errors.remove(playground);
    }

    @Override
    public void removeError(IWidgetAdapter widgetAdapter) {
        if (this.errors.remove(widgetAdapter) != null) {
            this.editor.updateInfoLabel();
        }
    }

    @Override
    public IModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> getModelAccess() {
        return this.modelAccess;
    }

    @Override
    public IWindow getWindow() {
        return this.editor.getWindow();
    }

    @Override
    public void addScheduledTask(Runnable task) {
        this.editor.addScheduledTask(task);
    }

    @Override
    public void removeScheduledTask(Runnable task) {
        this.editor.removeScheduledTask(task);
    }

    @Override
    public void addCloseVeto(IWidgetAdapter widgetAdapter, ITextProvider veto) {
        assert (widgetAdapter != null);
        this.closeVetos.put(widgetAdapter, veto);
        this.editor.handleCloseVetosChanged();
    }

    @Override
    public void removeCloseVeto(IWidgetAdapter widgetAdapter) {
        assert (widgetAdapter != null);
        this.closeVetos.remove(widgetAdapter);
        this.checkIfPlaygroundManagerErrorsCanBeRemoved();
        this.editor.handleCloseVetosChanged();
    }

    @Override
    public boolean hasCloseVetos() {
        return !this.closeVetos.isEmpty();
    }

    @Override
    public Collection<Tuple<String, ITextProvider>> getAllCloseVetos() {
        ArrayList<Tuple<String, ITextProvider>> vetosToReturn = new ArrayList<Tuple<String, ITextProvider>>(this.closeVetos.size());
        for (Map.Entry<IWidgetAdapter, ITextProvider> veto : this.closeVetos.entrySet()) {
            vetosToReturn.add((Tuple<String, ITextProvider>)new Tuple((Object)veto.getKey().getWidget().getLabel(), (Object)veto.getValue()));
        }
        return vetosToReturn;
    }

    private static enum PlaygroundManagerError {
        FATAL_ERROR(true, "Editor.fatalError"),
        ERROR_WHILE_SAVING(false, "Editor.errorWhileSaving"),
        SAVING_NOT_POSSIBLE(false, "Editor.savingNotPossible");

        private final boolean isFatal;
        private final String errorMessageKey;

        private PlaygroundManagerError(boolean isFatal, String errorMessageKey) {
            this.isFatal = isFatal;
            this.errorMessageKey = errorMessageKey;
        }

        public boolean isFatal() {
            return this.isFatal;
        }

        public String getErrorMessageKey() {
            return this.errorMessageKey;
        }
    }
}

