/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

import com.arcway.lib.graphics.saveimage.ImageInputStreamImpl;
import com.arcway.lib.graphics.saveimage.ImageOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        } else {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        } else {
            this.write(v >>> 0 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 24 & 0xFF);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.write((int)(v >>> 56) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 0) & 0xFF);
        } else {
            this.write((int)(v >>> 0) & 0xFF);
            this.write((int)(v >>> 8) & 0xFF);
            this.write((int)(v >>> 16) & 0xFF);
            this.write((int)(v >>> 24) & 0xFF);
            this.write((int)(v >>> 32) & 0xFF);
            this.write((int)(v >>> 40) & 0xFF);
            this.write((int)(v >>> 48) & 0xFF);
            this.write((int)(v >>> 56) & 0xFF);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write((byte)s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                char v = s.charAt(i);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                char v = s.charAt(i);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                ++i;
            }
        }
        this.write(b, 0, len * 2);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        char c;
        int strlen = s.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int boff = 0;
        s.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("utflen > 65536!");
        }
        byte[] b = new byte[utflen + 2];
        b[boff++] = (byte)(utflen >>> 8 & 0xFF);
        b[boff++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                b[boff++] = (byte)c;
            } else if (c > '\u07ff') {
                b[boff++] = (byte)(0xE0 | c >> 12 & 0xF);
                b[boff++] = (byte)(0x80 | c >> 6 & 0x3F);
                b[boff++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                b[boff++] = (byte)(0xC0 | c >> 6 & 0x1F);
                b[boff++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        this.write(b, 0, utflen + 2);
    }

    @Override
    public void writeShorts(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                short v = s[off + i];
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                short v = s[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                ++i;
            }
        }
        this.write(b, 0, len * 2);
    }

    @Override
    public void writeChars(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        byte[] b = new byte[len * 2];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                char v = c[off + i];
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                char v = c[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                ++i;
            }
        }
        this.write(b, 0, len * 2);
    }

    @Override
    public void writeInts(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 4];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int j = 0;
            while (j < len) {
                int v = i[off + j];
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++j;
            }
        } else {
            int j = 0;
            while (j < len) {
                int v = i[off + j];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                ++j;
            }
        }
        this.write(b, 0, len * 4);
    }

    @Override
    public void writeLongs(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        byte[] b = new byte[len * 8];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                long v = l[off + i];
                b[boff++] = (byte)(v >>> 56);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                long v = l[off + i];
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 56);
                ++i;
            }
        }
        this.write(b, 0, len * 8);
    }

    @Override
    public void writeFloats(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        byte[] b = new byte[len * 4];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                int v = Float.floatToIntBits(f[off + i]);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                int v = Float.floatToIntBits(f[off + i]);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                ++i;
            }
        }
        this.write(b, 0, len * 4);
    }

    @Override
    public void writeDoubles(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        byte[] b = new byte[len * 8];
        int boff = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int i = 0;
            while (i < len) {
                long v = Double.doubleToLongBits(d[off + i]);
                b[boff++] = (byte)(v >>> 56);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                long v = Double.doubleToLongBits(d[off + i]);
                b[boff++] = (byte)(v >>> 0);
                b[boff++] = (byte)(v >>> 8);
                b[boff++] = (byte)(v >>> 16);
                b[boff++] = (byte)(v >>> 24);
                b[boff++] = (byte)(v >>> 32);
                b[boff++] = (byte)(v >>> 40);
                b[boff++] = (byte)(v >>> 48);
                b[boff++] = (byte)(v >>> 56);
                ++i;
            }
        }
        this.write(b, 0, len * 8);
    }

    @Override
    public void writeBit(int bit) throws IOException {
        this.writeBits(1L & (long)bit, 1);
    }

    @Override
    public void writeBits(long bits, int numBits) throws IOException {
        int shift;
        int numBitsTemp = numBits;
        this.checkClosed();
        if (numBitsTemp < 0 || numBitsTemp > 64) {
            throw new IllegalArgumentException("Bad value for numBits!");
        }
        if (numBitsTemp == 0) {
            return;
        }
        if (this.getStreamPosition() > 0L || this.bitOffset > 0) {
            int mask;
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partialByte = 0;
            }
            if (numBitsTemp + offset < 8) {
                shift = 8 - (offset + numBitsTemp);
                mask = -1 >>> 32 - numBitsTemp;
                partialByte &= ~(mask << shift);
                partialByte = (int)((long)partialByte | (bits & (long)mask) << shift);
                this.write(partialByte);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = offset + numBitsTemp;
                numBitsTemp = 0;
            } else {
                int num = 8 - offset;
                mask = -1 >>> 32 - num;
                partialByte &= ~mask;
                partialByte = (int)((long)partialByte | bits >> numBitsTemp - num & (long)mask);
                this.write(partialByte);
                numBitsTemp -= num;
            }
        }
        if (numBitsTemp > 7) {
            int extra = numBitsTemp % 8;
            int numBytes = numBitsTemp / 8;
            while (numBytes > 0) {
                shift = (numBytes - 1) * 8 + extra;
                int value = (int)(shift == 0 ? bits & 0xFFL : bits >> shift & 0xFFL);
                this.write(value);
                --numBytes;
            }
            numBitsTemp = extra;
        }
        if (numBitsTemp != 0) {
            int partialByte = 0;
            partialByte = this.read();
            if (partialByte != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                partialByte = 0;
            }
            int shift2 = 8 - numBitsTemp;
            int mask = -1 >>> 32 - numBitsTemp;
            partialByte &= ~(mask << shift2);
            partialByte = (int)((long)partialByte | (bits & (long)mask) << shift2);
            this.write(partialByte);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = numBitsTemp;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte < 0) {
                partialByte = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                partialByte &= -1 << 8 - offset;
            }
            this.write(partialByte);
        }
    }
}

