/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.fillstyles;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;

public abstract class FillStyleHatching
extends FillStyle {
    @Override
    public void draw(Device device, Polygon polygon, FillColor fillColor) {
        if (fillColor.backgroundAlpha > 0) {
            device.polygon(polygon, fillColor.backgroundColor, fillColor.backgroundAlpha);
        }
        if (fillColor.foregroundAlpha > 0) {
            HatchingContext hatchingContext = new HatchingContext(device, polygon, fillColor.foregroundColor);
            Rectangle bounds = polygon.getBounds();
            this.drawHatching(bounds, hatchingContext);
        }
    }

    protected abstract void drawHatching(Rectangle var1, HatchingContext var2);

    protected final void drawEven(StraightLine even, double lineSize, HatchingContext hatchingContext) {
        Device device = hatchingContext.getDevice();
        Polygon polygon = hatchingContext.getPolygon();
        Color fillColor = hatchingContext.getFillColor();
        Points intersectionPoints = even.getIntersectionPoints(polygon);
        while (intersectionPoints.size() >= 2) {
            int p1 = this.getNextPoint(intersectionPoints);
            intersectionPoints.remove(p1);
            int p2 = this.getNextPoint(intersectionPoints);
            intersectionPoints.remove(p2);
            Corners polylineCorners = new Corners(2);
            polylineCorners.add(new Corner(p1, 0.0));
            polylineCorners.add(new Corner(p2, 0.0));
            device.polyline(polylineCorners, lineSize, fillColor, LineStyle.SOLID);
        }
    }

    private int getNextPoint(Points points) {
        int nextPointIndex = 0;
        Point nextPoint = points.get(nextPointIndex);
        int i = 1;
        while (i < points.size()) {
            Point currentPoint = points.get(i);
            if (Geo.equals(currentPoint.y, nextPoint.y)) {
                if (currentPoint.x < nextPoint.x) {
                    nextPoint = currentPoint;
                    nextPointIndex = i;
                }
            } else if (currentPoint.y > nextPoint.y) {
                nextPoint = currentPoint;
                nextPointIndex = i;
            }
            ++i;
        }
        return nextPointIndex;
    }

    protected final class HatchingContext {
        private final Device device;
        private final Polygon polygon;
        private final Color fillColor;

        private HatchingContext(Device device, Polygon polygon, Color fillColor) {
            this.device = device;
            this.polygon = polygon;
            this.fillColor = fillColor;
        }

        private Polygon getPolygon() {
            return this.polygon;
        }

        private Device getDevice() {
            return this.device;
        }

        private Color getFillColor() {
            return this.fillColor;
        }
    }
}

