/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.device;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonProcessor;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.LinePieceProcessor;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class PolygonProcessorPolygonDraw
extends PolygonProcessor {
    private final LinePieceProcessor lpp;

    public PolygonProcessorPolygonDraw(Polygon polygon, ILineDrawProcessor lineDrawProcessor, LineStyle lineStyle, double lineScale, double skipAtBeginning, double skipAtEnd) {
        this.lpp = new LinePieceProcessor(lineDrawProcessor, lineStyle, lineScale, polygon.arcLength(), skipAtBeginning, skipAtEnd, polygon.isClosed());
    }

    @Override
    public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
        this.lpp.process_arc(arc.center.x, arc.center.y, arc.rx, arc.ry, comingFrom.getAngle(), arc.angleStart, arc.angleEnd, goingTo.getAngle());
    }

    @Override
    public void processLine(Direction comingFrom, Line line, Direction goingTo) {
        this.lpp.process_line(comingFrom.getAngle(), line.start.x, line.start.y, line.end.x, line.end.y, goingTo.getAngle());
    }

    @Override
    public void processPoint(Point point) {
        this.lpp.process_point(point.x, point.y);
    }
}

