/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics;

import com.arcway.lib.graphics.Color;

public class FillColor {
    public static final FillColor BLACK = new FillColor(Color.BLACK);
    public static final FillColor WHITE = new FillColor(Color.WHITE);
    public static final FillColor TRANSPARENT = new FillColor(new Color(0, 0, 0), 0, new Color(0, 0, 0), 0);
    public Color foregroundColor;
    public int foregroundAlpha;
    public Color backgroundColor;
    public int backgroundAlpha;

    public FillColor(FillColor fillColor) {
        assert (fillColor != null) : "fillColor = null";
        this.foregroundColor = new Color(fillColor.foregroundColor);
        this.foregroundAlpha = fillColor.foregroundAlpha;
        this.backgroundColor = new Color(fillColor.backgroundColor);
        this.backgroundAlpha = fillColor.backgroundAlpha;
    }

    public FillColor(Color foregroundColor, int foregroundAlpha, Color backgroundColor, int backgroundAlpha) {
        assert (foregroundColor != null) : "foregroundColor = null";
        assert (backgroundColor != null) : "backgroundColor = null";
        assert (foregroundAlpha >= 0 && foregroundAlpha < 256) : "foregroundAlpha out of range";
        assert (backgroundAlpha >= 0 && backgroundAlpha < 256) : "backgroundAlpha out of range";
        this.foregroundColor = new Color(foregroundColor);
        this.foregroundAlpha = foregroundAlpha;
        this.backgroundColor = new Color(backgroundColor);
        this.backgroundAlpha = backgroundAlpha;
    }

    public FillColor(Color foregroundColor, Color backgroundColor) {
        assert (foregroundColor != null) : "foregroundColor = null";
        assert (backgroundColor != null) : "backgroundColor = null";
        this.foregroundColor = new Color(foregroundColor);
        this.foregroundAlpha = 255;
        this.backgroundColor = new Color(backgroundColor);
        this.backgroundAlpha = 255;
    }

    public FillColor(int fgR, int fgG, int fgB, int foregroundAlpha, int bgR, int bgG, int bgB, int backgroundAlpha) {
        assert (fgR >= 0 && fgR < 256) : "fgR out of range";
        assert (fgG >= 0 && fgG < 256) : "fgG out of range";
        assert (fgB >= 0 && fgB < 256) : "fgB out of range";
        assert (foregroundAlpha >= 0 && foregroundAlpha < 256) : "foregroundAlpha out of range";
        assert (bgR >= 0 && bgR < 256) : "bgR out of range";
        assert (bgG >= 0 && bgG < 256) : "bgG out of range";
        assert (bgB >= 0 && bgB < 256) : "bgB out of range";
        assert (backgroundAlpha >= 0 && backgroundAlpha < 256) : "backgroundAlpha out of range";
        this.foregroundColor = new Color(fgR, fgG, fgB);
        this.foregroundAlpha = foregroundAlpha;
        this.backgroundColor = new Color(bgR, bgG, bgB);
        this.backgroundAlpha = backgroundAlpha;
    }

    public FillColor(int fgR, int fgG, int fgB, int bgR, int bgG, int bgB) {
        assert (fgR >= 0 && fgR < 256) : "fgR out of range";
        assert (fgG >= 0 && fgG < 256) : "fgG out of range";
        assert (fgB >= 0 && fgB < 256) : "fgB out of range";
        assert (bgR >= 0 && bgR < 256) : "bgR out of range";
        assert (bgG >= 0 && bgG < 256) : "bgG out of range";
        assert (bgB >= 0 && bgB < 256) : "bgB out of range";
        this.foregroundColor = new Color(fgR, fgG, fgB);
        this.foregroundAlpha = 255;
        this.backgroundColor = new Color(bgR, bgG, bgB);
        this.backgroundAlpha = 255;
    }

    public FillColor(Color color, int alpha) {
        assert (color != null) : "color = null";
        assert (alpha >= 0 && alpha < 256) : "alpha out of range";
        this.foregroundColor = new Color(color);
        this.foregroundAlpha = alpha;
        this.backgroundColor = new Color();
        this.backgroundAlpha = 0;
    }

    public FillColor(Color color) {
        assert (color != null) : "color = null";
        this.foregroundColor = new Color(color);
        this.foregroundAlpha = 255;
        this.backgroundColor = new Color();
        this.backgroundAlpha = 0;
    }

    public FillColor(int r, int g, int b, int alpha) {
        assert (r >= 0 && r < 256) : "r out of range";
        assert (g >= 0 && g < 256) : "g out of range";
        assert (b >= 0 && b < 256) : "b out of range";
        assert (alpha >= 0 && alpha < 256) : "alpha out of range";
        this.foregroundColor = new Color(r, g, b);
        this.foregroundAlpha = alpha;
        this.backgroundColor = new Color();
        this.backgroundAlpha = 0;
    }

    public FillColor(int r, int g, int b) {
        assert (r >= 0 && r < 256) : "r out of range";
        assert (g >= 0 && g < 256) : "g out of range";
        assert (b >= 0 && b < 256) : "b out of range";
        this.foregroundColor = new Color(r, g, b);
        this.foregroundAlpha = 255;
        this.backgroundColor = new Color();
        this.backgroundAlpha = 0;
    }

    public FillColor() {
        this.foregroundColor = new Color();
        this.foregroundAlpha = 255;
        this.backgroundColor = new Color();
        this.backgroundAlpha = 0;
    }

    public boolean isTransparent() {
        return this.foregroundAlpha == 0 && this.backgroundAlpha == 0;
    }

    public boolean equalsFillColor(FillColor color) {
        boolean isEqual = true;
        if (this.foregroundAlpha != 0 || color.foregroundAlpha != 0) {
            isEqual &= this.foregroundAlpha == color.foregroundAlpha;
            isEqual &= this.foregroundColor.equalsColor(color.foregroundColor);
        } else if (this.backgroundAlpha != 0 || color.backgroundAlpha != 0) {
            isEqual &= this.backgroundAlpha == color.backgroundAlpha;
            isEqual &= this.backgroundColor.equalsColor(color.backgroundColor);
        }
        return isEqual;
    }

    public int hashCodeEqualsFillColor() {
        int hashCode = 1;
        if (this.foregroundAlpha != 0) {
            hashCode ^= this.foregroundAlpha ^ ((Object)this.foregroundColor).hashCode();
        }
        if (this.backgroundAlpha != 0) {
            hashCode ^= this.backgroundAlpha ^ ((Object)this.backgroundColor).hashCode();
        }
        return hashCode;
    }

    @Deprecated
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof FillColor) {
            FillColor color = (FillColor)object;
            return this.equalsFillColor(color);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        return this.hashCodeEqualsFillColor();
    }

    public FillColor changeOpacity(double opacity) {
        int newForegroundAlpha = FillColor.applyOpacity(this.foregroundColor, this.foregroundAlpha, opacity);
        int newBackgroundAlpha = FillColor.applyOpacity(this.backgroundColor, this.backgroundAlpha, opacity);
        return new FillColor(this.foregroundColor, newForegroundAlpha, this.backgroundColor, newBackgroundAlpha);
    }

    public FillColor changeForegroundOpacity(double opacity) {
        int newForegroundAlpha = FillColor.applyOpacity(this.foregroundColor, this.foregroundAlpha, opacity);
        return new FillColor(this.foregroundColor, newForegroundAlpha, this.backgroundColor, this.backgroundAlpha);
    }

    public FillColor replaceForegroundOpacity(int newForegroundAlpha) {
        return new FillColor(this.foregroundColor, newForegroundAlpha, this.backgroundColor, this.backgroundAlpha);
    }

    private static int applyOpacity(Color oldColor, int oldAlpha, double opacity) {
        return FillColor.applyOpacity(oldColor.transparent ? 0 : oldAlpha, opacity);
    }

    private static int applyOpacity(int oldAlpha, double opacity) {
        double range;
        double lambda;
        double offset = oldAlpha;
        if (opacity < 0.0) {
            lambda = -opacity;
            range = -oldAlpha;
        } else if (opacity > 0.0) {
            lambda = opacity;
            range = 255.0 - (double)oldAlpha;
        } else {
            lambda = 0.0;
            range = 0.0;
        }
        int newAlpha = (int)Math.round(offset + lambda * range);
        return newAlpha;
    }

    public String toString() {
        return String.format("FillColor(foregroundColor=%s,foregroundAlpha=%03d,backgroundColor=%s,backgroundAlpha=%03d)", this.foregroundColor, this.foregroundAlpha, this.backgroundColor, this.backgroundAlpha);
    }
}

