/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Dimension;

public class Geo {
    public static final double NEARLY_ZERO = 1.0E-10;
    public static final double CM_PER_M = 100.0;
    public static final double M_PER_INCH = 0.0254;
    public static final double CM_PER_INCH = 2.54;
    public static final double MM_PER_INCH = 25.4;
    public static final double INCH_PER_M = 39.37007874015748;
    public static final double INCH_PER_MM = 0.03937007874015748;
    public static final double POINTSPOSTSCRIPT_PER_INCH = 72.0;
    public static final double DPI_RATIO = 1.3333333333333333;
    public static final double POINTSPOSTSCRIPT_PER_M = 2834.645669291339;
    public static final double POINTSPOSTSCRIPT_PER_MM = 2.8346456692913384;
    public static final double POINTSDIDOT_PER_MM = 2.6595744680851063;
    public static final double POINTSDIDOT_PER_M = 2659.574468085106;
    public static final double WINDOWS_HG_HEIGHT_PER_LINE_HEIGHT = 0.8075987144168962;
    public static final double DIN_A_RELATION = Math.sqrt(2.0);
    public static final double DIN_A0_AREA_IN_MMMM = 1000000.0;
    public static final Dimension DIN_A0_IN_MM = Geo.getPageDimension(1000000.0, DIN_A_RELATION);

    public static Dimension getPageDimension(double area, double relationWidthToHeight) {
        assert (relationWidthToHeight >= 1.0E-10);
        if (Geo.equals(area, 0.0)) {
            return new Dimension(0.0, 0.0);
        }
        double h = Math.sqrt(area / relationWidthToHeight);
        double w = Math.sqrt(area * relationWidthToHeight);
        assert (Geo.equals(h * w, area));
        return new Dimension(w, h);
    }

    public static double arcLengthLine(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double arcLengthArc(double rx, double ry, double a1, double a2) {
        assert (rx > -1.0E-10) : "rx < 0";
        assert (ry > -1.0E-10) : "ry < 0";
        return Math.abs(Math.toRadians(a2 - a1)) * Math.max(rx, ry);
    }

    public static double angleArc(double rx, double ry, double a1, double arcLength) {
        assert (Math.abs(Math.max(rx, ry)) > 1.0E-10) : "rx and ry <= 0";
        return Math.toDegrees(arcLength / Math.max(rx, ry));
    }

    public static int sgn(double value) {
        if (value > 1.0E-10) {
            return 1;
        }
        if (value < -1.0E-10) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(double a, double b) {
        double diff = a - b;
        if (diff > 1.0E-10) {
            return false;
        }
        return !(diff < -1.0E-10);
    }

    public static boolean isZero(double a) {
        if (a > 1.0E-10) {
            return false;
        }
        return !(a < -1.0E-10);
    }

    public static boolean isZeroOrGreaterThanZero(double a) {
        return a > -1.0E-10;
    }

    public static boolean isGreaterThanZero(double a) {
        return a > 1.0E-10;
    }

    public static boolean isModuloZero(double divisor, double dividend) {
        double rest = divisor % dividend;
        if (rest < 1.0E-10) {
            rest += dividend;
        }
        if (rest > dividend / 2.0) {
            rest -= dividend;
        }
        return Geo.equals(rest, 0.0);
    }

    public static boolean isInClosedIntervall(double a, double start, double end) {
        boolean isInIntervall = Geo.equals(a, start) ? true : (Geo.equals(a, end) ? true : (end > start ? start <= a && a <= end : (end < start ? end <= a && a <= start : false)));
        return isInIntervall;
    }

    public static boolean isInClosedAngleIntervall(double normalizedAngle, double start, double end) {
        double endNormalized;
        double startNormalized = Geo.getNormalizedAngle(start);
        if (Geo.equalsNormalizedAngles(startNormalized, endNormalized = Geo.getNormalizedAngle(end))) {
            return Geo.equalsNormalizedAngles(normalizedAngle, startNormalized) || Geo.equalsNormalizedAngles(normalizedAngle, endNormalized);
        }
        if (endNormalized < startNormalized) {
            endNormalized += 360.0;
        }
        boolean isInIntervall = false;
        isInIntervall |= Geo.isInClosedIntervall(normalizedAngle, startNormalized, endNormalized);
        return isInIntervall |= Geo.isInClosedIntervall(normalizedAngle, startNormalized -= 360.0, endNormalized -= 360.0);
    }

    public static double getNormalizedAngle(double angle) {
        double normalizedAngle = angle;
        if ((normalizedAngle %= 360.0) < 0.0 && (normalizedAngle += 360.0) == 360.0) {
            normalizedAngle = 0.0;
        }
        return normalizedAngle;
    }

    public static boolean equalsNormalizedAngles(double angle1, double angle2) {
        assert (angle1 >= -1.0E-10 && angle1 < 360.0000000001) : "angle1 is out of range";
        assert (angle2 >= -1.0E-10 && angle2 < 360.0000000001) : "angle2 is out of range";
        if (Geo.equals(angle1, angle2)) {
            return true;
        }
        if (Geo.equals(angle1 + 360.0, angle2)) {
            return true;
        }
        return Geo.equals(angle1, angle2 + 360.0);
    }

    public static double getNormalizedStraightLineAngle(double angle) {
        double normalizedAngle = angle;
        if ((normalizedAngle %= 180.0) < 0.0) {
            normalizedAngle += 180.0;
        }
        return normalizedAngle;
    }

    public static boolean equalsNormalizedStraightLineAngles(double angle1, double angle2) {
        assert (angle1 >= 0.0 && angle1 < 180.0) : "angle1 is out of range";
        assert (angle2 >= 0.0 && angle2 < 180.0) : "angle2 is out of range";
        if (Geo.equals(angle1, angle2)) {
            return true;
        }
        if (Geo.equals(angle1 + 180.0, angle2)) {
            return true;
        }
        return Geo.equals(angle1, angle2 + 180.0);
    }
}

