/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.extensions;

import com.arcway.lib.extensioning.AbstractExtensioningImplSingletonLoader;
import com.arcway.lib.extensions.IARCWAYLibLoggerManagerExtensionPoint;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.ILoggerManager;
import com.arcway.lib.logging.StdOutStdErrLogger;
import com.arcway.lib.logging.StdOutStdErrLoggerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class ARCWAYLibLoggerManagerExtensionPoint
implements IARCWAYLibLoggerManagerExtensionPoint {
    private static final ILogger logger = new StdOutStdErrLogger(ARCWAYLibLoggerManagerExtensionPoint.class);
    private static final IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
    private static final String EXTENSION_POINT_ID = "loggermanager";
    private static final String CONFIG_ELEMENT_ID = "loggermanager";
    private static final String ATTRIBUTE_NAME_LOGGER_MANAGER_CLASS = "classname";
    private static Collection loggerManagers = null;

    public synchronized Collection getLoggerManagers() {
        if (loggerManagers == null) {
            ARCWAYLibLoggerManagerExtensionPoint.readLoggingManagersExtensionPoint();
        }
        if (loggerManagers.isEmpty()) {
            loggerManagers = Collections.singleton(new StdOutStdErrLoggerManager());
        }
        return loggerManagers;
    }

    private static void readLoggingManagersExtensionPoint() {
        loggerManagers = new ArrayList();
        try {
            IExtension[] extensions;
            assert (AbstractExtensioningImplSingletonLoader.ARCWAYLibPluginRepresentative != null) : "ACWAYLibPlugin has not been initialized yet. Check if the Bundleinitializer has been run before.";
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(AbstractExtensioningImplSingletonLoader.ARCWAYLibPluginRepresentative.getPluginID(), "loggermanager");
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if ("loggermanager".equals(currentConfigElement.getName())) {
                        try {
                            ILoggerManager registeredLoggingManager = (ILoggerManager)currentConfigElement.createExecutableExtension(ATTRIBUTE_NAME_LOGGER_MANAGER_CLASS);
                            loggerManagers.add(registeredLoggingManager);
                        }
                        catch (CoreException e) {
                            logger.error("Error while creating object instance " + e.getStatus(), (Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (RuntimeException e1) {
            logger.error("Exception when reading Logging Manager Extension Point. Adding StdOut/StdErrLoggerManager. This exception may be caused by an invalid class path (e.g. a non eclipse project has included the ARCWAYLib/sources-eclipse classes). Ask Rudi. :-)", (Throwable)e1);
            loggerManagers.add(new StdOutStdErrLoggerManager());
            return;
        }
    }
}

