/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.gui.DecoratedImageDescriptorForGIFs;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.ui.editor.EnumerationItem_WithLabelIconDecorationsAndSelectability;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.MultipleChoiceWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class MultipleChoiceWidget
extends AbstractDataWidget
implements SelectionListener {
    private static final IStreamResource icon_checkbox_checked = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/checkbox_checked.gif"));
    private static final IStreamResource icon_checkbox_unchecked = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/checkbox_unchecked.gif"));
    private static final IStreamResource icon_checkbox_disabled_checked = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/checkbox_disabled_checked.gif"));
    private static final IStreamResource icon_checkbox_disabled_unchecked = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/checkbox_disabled_unchecked.gif"));
    private static final int COLUMN_WIDTH_ICON = 25;
    private Composite widgetComposite;
    private TableViewer tableViewer;
    private int checkBoxColumnIndex;
    private int labelColumnIndex;
    private final boolean showRecommendedSelectableValuesOnly;
    private boolean editableControl;
    private Filter filter;
    private ISetRW_<Object> currentValue;

    public MultipleChoiceWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
        this.showRecommendedSelectableValuesOnly = parameters instanceof MultipleChoiceWidgetParameters && ((MultipleChoiceWidgetParameters)parameters).showRecommendedSelectableValuesOnly();
    }

    private boolean mayHaveEditableControl() {
        return this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked();
    }

    @Override
    public void createControl(Composite parentComposite) {
        this.widgetComposite = parentComposite;
        this.createControl();
        this.setValueInWidget((ISet_<Object>)((ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE)));
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
            this.setValueRangeInWidget((List)this.getWidgetAdapter().getValueRange());
            this.setValueInWidget((ISet_<Object>)((ISet_)this.getWidgetAdapter().getValue(mode)));
        } else {
            this.tableViewer.refresh();
        }
        this.updateWidgetMessageDisplay();
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            this.tableViewer.getTable().dispose();
            this.createControl();
            this.setValueInWidget((ISet_<Object>)((ISet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE)));
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void setValue(Object value) {
        this.setValueInWidget((ISet_<Object>)((ISet_)value));
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void createControl() {
        List valueRange = (List)this.getWidgetAdapter().getValueRange();
        assert (valueRange != null);
        FormToolkit toolkit = this.getFormToolkit();
        if (this.mayHaveEditableControl() && !valueRange.isEmpty()) {
            this.createControl(toolkit, valueRange, true);
        } else {
            this.createControl(toolkit, valueRange, false);
        }
    }

    private void createControl(FormToolkit toolkit, List<EnumerationItem_WithLabelIconDecorationsAndSelectability> valueRange, boolean editableControl_) {
        toolkit.setBorderStyle(0);
        this.editableControl = editableControl_;
        final Table table = toolkit.createTable(this.widgetComposite, 98306);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        td.grabVertical = true;
        table.setLayoutData((Object)td);
        table.setLinesVisible(false);
        table.setEnabled(true);
        this.tableViewer = new TableViewer(table);
        if (editableControl_) {
            TableColumn checkBoxColumn = new TableColumn(table, 0x1000000);
            checkBoxColumn.setWidth(25);
            TableViewerColumn checkBoxColumnAsViewerColumn = new TableViewerColumn(this.tableViewer, checkBoxColumn);
            checkBoxColumnAsViewerColumn.setEditingSupport((org.eclipse.jface.viewers.EditingSupport)new EditingSupport((ColumnViewer)this.tableViewer));
            this.checkBoxColumnIndex = 0;
            this.labelColumnIndex = 1;
        } else {
            this.checkBoxColumnIndex = -1;
            this.labelColumnIndex = 0;
        }
        final TableColumn labelColumn = new TableColumn(table, 16384);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                labelColumn.setWidth(table.getBounds().width - 25 - 10);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(this.getFormToolkit()));
        this.filter = new Filter(this.editableControl, this.showRecommendedSelectableValuesOnly);
        this.tableViewer.addFilter((ViewerFilter)this.filter);
        this.currentValue = new HashSet_(this.getWidgetAdapter().getKeyHasher());
        this.setValueRangeInWidget(valueRange);
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    private void setValueRangeInWidget(List<EnumerationItem_WithLabelIconDecorationsAndSelectability> valueRange) {
        ArrayList<EnumerationItem_WithLabelIconDecorationsAndSelectability> actualValueRange = new ArrayList<EnumerationItem_WithLabelIconDecorationsAndSelectability>(valueRange);
        if (!this.editableControl) {
            actualValueRange.add(new EnumerationItem_WithLabelIconDecorationsAndSelectability(null, "-", null, EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_CHECKED));
        }
        this.tableViewer.setInput(actualValueRange);
    }

    private void setValueInWidget(ISet_<Object> value) {
        this.currentValue.clear();
        this.currentValue.addAll(value);
        this.tableViewer.refresh();
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class EditingSupport
    extends org.eclipse.jface.viewers.EditingSupport {
        public EditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(final Object element) {
            CheckboxCellEditor checkBoxCellEditor = new CheckboxCellEditor();
            checkBoxCellEditor.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                    EnumerationItem_WithLabelIconDecorationsAndSelectability enumItem = (EnumerationItem_WithLabelIconDecorationsAndSelectability)element;
                    if (MultipleChoiceWidget.this.currentValue.contains(enumItem.getKey())) {
                        MultipleChoiceWidget.this.currentValue.remove(enumItem.getKey());
                    } else {
                        MultipleChoiceWidget.this.currentValue.add(enumItem.getKey());
                    }
                    MultipleChoiceWidget.this.tableViewer.refresh();
                    MultipleChoiceWidget.this.getWidgetAdapter().widgetModified();
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                }
            });
            return checkBoxCellEditor;
        }

        protected boolean canEdit(Object element) {
            EnumerationItem_WithLabelIconDecorationsAndSelectability enumItem = (EnumerationItem_WithLabelIconDecorationsAndSelectability)element;
            return enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYCHECKED || enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYUNCHECKED_DEFAULT || enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYUNCHECKED_RECOMMENDED;
        }

        protected Object getValue(Object element) {
            return Boolean.TRUE;
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private class Filter
    extends ViewerFilter {
        private final boolean editableControl_;
        private final boolean showRecommendedSelectableValuesOnly_;

        public Filter(boolean editableControl, boolean showRecommendedSelectableValuesOnly) {
            this.editableControl_ = editableControl;
            this.showRecommendedSelectableValuesOnly_ = showRecommendedSelectableValuesOnly;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.editableControl_) {
                if (this.showRecommendedSelectableValuesOnly_) {
                    return ((EnumerationItem_WithLabelIconDecorationsAndSelectability)element).getSelectability() != EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYUNCHECKED_DEFAULT;
                }
                return true;
            }
            EnumerationItem_WithLabelIconDecorationsAndSelectability enumItem = (EnumerationItem_WithLabelIconDecorationsAndSelectability)element;
            Object key = enumItem.getKey();
            if (!MultipleChoiceWidget.this.currentValue.isEmpty()) {
                return key != null && MultipleChoiceWidget.this.currentValue.contains(enumItem.getKey());
            }
            return key == null;
        }
    }

    private class LabelProvider
    extends StyledCellLabelProvider {
        private static final String COLORKEY_LABELDECORATOR = "DecoratedMultipleChoiceWidget.new";
        private final FormToolkit toolkit;
        private final IMapRW_<EnumerationItem_WithLabelIconDecorationsAndSelectability, Image> imagesToDispose = new HashMap_(IHasher_.OBJECT_IDENTITY_HASHER);

        public LabelProvider(FormToolkit toolkit) {
            this.toolkit = toolkit;
        }

        public void update(ViewerCell cell) {
            String label = null;
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>(2);
            Image image = null;
            EnumerationItem_WithLabelIconDecorationsAndSelectability enumItem = (EnumerationItem_WithLabelIconDecorationsAndSelectability)cell.getElement();
            if (cell.getColumnIndex() == MultipleChoiceWidget.this.checkBoxColumnIndex) {
                image = enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_CHECKED ? ImageCache.getImage(MultipleChoiceWidget.this.tableViewer.getTable().getDisplay(), icon_checkbox_disabled_checked) : (enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_UNCHECKED ? ImageCache.getImage(MultipleChoiceWidget.this.tableViewer.getTable().getDisplay(), icon_checkbox_disabled_unchecked) : (MultipleChoiceWidget.this.currentValue.contains(enumItem.getKey()) ? ImageCache.getImage(MultipleChoiceWidget.this.tableViewer.getTable().getDisplay(), icon_checkbox_checked) : ImageCache.getImage(MultipleChoiceWidget.this.tableViewer.getTable().getDisplay(), icon_checkbox_unchecked)));
            } else if (cell.getColumnIndex() == MultipleChoiceWidget.this.labelColumnIndex) {
                label = enumItem.getLabel();
                StyleRange styleForLabel = new StyleRange();
                styleForLabel.start = 0;
                styleForLabel.length = enumItem.getLabel().length();
                styles.add(styleForLabel);
                if (enumItem.getLabelDecoration() != null) {
                    int decoratorStartIndex = label.length();
                    label = String.valueOf(label) + " " + enumItem.getLabelDecoration();
                    Color labelDecoratorColour = this.toolkit.getColors().getColor(COLORKEY_LABELDECORATOR);
                    if (labelDecoratorColour == null) {
                        labelDecoratorColour = this.toolkit.getColors().createColor(COLORKEY_LABELDECORATOR, 255, 210, 0);
                    }
                    StyleRange styleForDecoration = new StyleRange();
                    styleForDecoration.fontStyle = 1;
                    styleForDecoration.foreground = labelDecoratorColour;
                    styleForDecoration.start = decoratorStartIndex;
                    styleForDecoration.length = enumItem.getLabelDecoration().length() + 1;
                    styles.add(styleForDecoration);
                }
                if (enumItem.getSelectability() == EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_UNCHECKED) {
                    for (StyleRange style : styles) {
                        style.strikeout = true;
                        style.strikeoutColor = cell.getControl().getDisplay().getSystemColor(2);
                    }
                }
                if (enumItem.getIcon() != null) {
                    image = ImageCache.getImage(Display.getDefault(), enumItem.getIcon());
                    if (enumItem.getIconDecoration() != null) {
                        if (this.imagesToDispose.containsKey((Object)enumItem)) {
                            image = (Image)this.imagesToDispose.getByKey((Object)enumItem);
                        } else {
                            DecoratedImageDescriptorForGIFs decoratedImageDescriptor = new DecoratedImageDescriptorForGIFs(image);
                            ImageDescriptor decoration = ImageCache.getImageDescriptor(enumItem.getIconDecoration());
                            decoratedImageDescriptor.addDecorator(decoration, 3);
                            image = decoratedImageDescriptor.createImage();
                            this.imagesToDispose.put((Object)enumItem, (Object)image);
                        }
                    }
                }
            }
            cell.setText(label);
            cell.setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
            cell.setImage(image);
            super.update(cell);
        }

        public void dispose() {
            super.dispose();
            for (Image image : this.imagesToDispose.values()) {
                image.dispose();
            }
        }
    }
}

