/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews.dnd;

import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDragSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class TreeViewDragSourceListener
implements DragSourceListener {
    private final TreeViewer viewer;
    private final Collection<TreeViewDragSource> dragHandlers;
    private int supportedOperations = 0;
    private final Collection<Transfer> supportedTransfers = new ArrayList<Transfer>();

    public TreeViewDragSourceListener(TreeViewer viewer, Collection<TreeViewDragSource> dragHandlers) {
        this.viewer = viewer;
        this.dragHandlers = dragHandlers;
        for (TreeViewDragSource handler : dragHandlers) {
            this.supportedOperations |= handler.getOperations();
            this.supportedTransfers.addAll(Arrays.asList(handler.getTransferTypes()));
        }
    }

    public boolean hasDragSources() {
        return !this.dragHandlers.isEmpty();
    }

    public int getSupportedOperations() {
        return this.supportedOperations;
    }

    public Transfer[] getSupportedTransfers() {
        Transfer[] transfers = new Transfer[this.supportedTransfers.size()];
        return this.supportedTransfers.toArray(transfers);
    }

    public void dragStart(DragSourceEvent event) {
        boolean dragPossible = false;
        for (TreeViewDragSource dragSource : this.dragHandlers) {
            if (!dragSource.isDragPossible(event, (ISelectionProvider)this.viewer)) continue;
            dragPossible = true;
        }
        event.doit = dragPossible;
    }

    public void dragSetData(DragSourceEvent event) {
        for (TreeViewDragSource dragSource : this.dragHandlers) {
            Transfer[] transfers;
            Transfer[] transferArray = transfers = dragSource.getTransferTypes();
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer transfer = transferArray[n2];
                if (transfer.isSupportedType(event.dataType)) {
                    event.data = dragSource.getDragData(event, (ISelectionProvider)this.viewer);
                    return;
                }
                ++n2;
            }
        }
        event.data = null;
    }

    public void dragFinished(DragSourceEvent event) {
        for (TreeViewDragSource dragSource : this.dragHandlers) {
            dragSource.finishDrag(event, (ISelectionProvider)this.viewer);
        }
    }
}

