/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;

public class DatePickerDialog
extends Dialog {
    private DateTime datePicker;
    private Date initialDate;
    private Date selectedDate;
    private boolean allowWeekends = true;

    public DatePickerDialog(Shell parent) {
        super(parent);
    }

    public DatePickerDialog(Shell parent, boolean allowWeekends) {
        super(parent);
        this.allowWeekends = allowWeekends;
    }

    public DatePickerDialog(Shell parent, Date initialDate) {
        super(parent);
        this.initialDate = initialDate;
    }

    public DatePickerDialog(Shell parent, Date initialDate, boolean allowWeekends) {
        super(parent);
        this.initialDate = initialDate;
        this.allowWeekends = allowWeekends;
    }

    protected Control createDialogArea(Composite parent) {
        this.datePicker = new DateTime(parent, 1024);
        this.datePicker.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        if (this.initialDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.initialDate);
            this.datePicker.setDate(calendar.get(1), calendar.get(2), calendar.get(5));
        }
        this.datePicker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Calendar dateToBeSet = DatePickerDialog.this.getCalendarFromWidget();
                if (!DatePickerDialog.this.allowWeekends) {
                    if (dateToBeSet.get(7) == 7) {
                        dateToBeSet.add(5, -1);
                    } else if (dateToBeSet.get(7) == 1) {
                        dateToBeSet.add(5, -2);
                    }
                    DatePickerDialog.this.datePicker.setDate(dateToBeSet.get(1), dateToBeSet.get(2), dateToBeSet.get(5));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return this.datePicker;
    }

    private Calendar getCalendarFromWidget() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1, this.datePicker.getYear());
        calendar.set(2, this.datePicker.getMonth());
        calendar.set(5, this.datePicker.getDay());
        return calendar;
    }

    protected void cancelPressed() {
        this.selectedDate = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selectedDate = this.getCalendarFromWidget().getTime();
        super.okPressed();
    }

    public Date getDate() {
        return this.selectedDate;
    }
}

