/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.gui.widgets.browser.BrowserFactory;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class HTMLTextMessageDialog
extends MessageDialog {
    private static final ILogger logger = Logger.getLogger(HTMLTextMessageDialog.class);
    private final String htmlMessageBody;

    public HTMLTextMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, String html, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.htmlMessageBody = html;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        base.setLayout((Layout)layout);
        base.setBackground(base.getDisplay().getSystemColor(1));
        IBrowser browser = BrowserFactory.createBrowserOrSubstituteWidget(base, 0);
        browser.setHtml(this.htmlMessageBody);
        Control browserControl = browser.getSWTControl();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 180;
        browserControl.setLayoutData((Object)gridData);
        return browserControl;
    }

    public static int showHTMLTextMessageDialog(Shell parentShell, final String dialogTitle, final Image dialogTitleImage, final String dialogMessage, final String htmlMessageBody, final int dialogImageType, final String[] dialogButtonLabels, final int defaultIndex) {
        Shell wwShell = null;
        if (parentShell == null) {
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (ww == null) {
                ww = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            }
            wwShell = ww.getShell();
        }
        final Shell shell = parentShell != null ? parentShell : wwShell;
        final int[] choice = new int[1];
        Runnable showDialogRunnable = new Runnable(){

            @Override
            public void run() {
                HTMLTextMessageDialog dlg = new HTMLTextMessageDialog(shell, dialogTitle, dialogTitleImage, dialogMessage, htmlMessageBody, dialogImageType, dialogButtonLabels, defaultIndex);
                choice[0] = dlg.open();
            }
        };
        if (shell != null) {
            shell.getDisplay().syncExec(showDialogRunnable);
        } else {
            logger.error("Can't open HTML text message - no shell available");
        }
        return choice[0];
    }
}

