/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.image;

import com.arcway.lib.eclipse.graphics.image.BMPResolutionFetcher;
import com.arcway.lib.eclipse.graphics.image.JPEGResolutionFetcher;
import com.arcway.lib.eclipse.graphics.image.PNGResolutionFetcher;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class ResolutionFetcher {
    public static Point fetchResolutionInPixelsPerMeter(int type, File imageFile) throws EXImageDataTypeNotSupported, JvmExternalResourceInteractionException, EXCorruptImageFileContent, FileNotFoundException {
        Point pixelsPerMeter;
        switch (type) {
            case 0: {
                pixelsPerMeter = BMPResolutionFetcher.fetchResolutionInPixelsPerMeter(new FileInputStream(imageFile));
                break;
            }
            case 1: {
                pixelsPerMeter = BMPResolutionFetcher.fetchResolutionInPixelsPerMeter(new FileInputStream(imageFile));
                break;
            }
            case 2: {
                pixelsPerMeter = new Point(3779.527559055118, 3779.527559055118);
                break;
            }
            case 4: {
                pixelsPerMeter = JPEGResolutionFetcher.fetchResolutionInPixelsPerMeter(new FileInputStream(imageFile));
                break;
            }
            case 5: {
                pixelsPerMeter = PNGResolutionFetcher.fetchResolutionInPixelsPerMeter(new FileInputStream(imageFile));
                break;
            }
            default: {
                pixelsPerMeter = null;
            }
        }
        assert (pixelsPerMeter == null || ResolutionFetcher.assertDpiInformationIsCorrect(imageFile, pixelsPerMeter));
        return pixelsPerMeter;
    }

    private static boolean assertDpiInformationIsCorrect(File imageFile, Point pixelsPerMeter) {
        return true;
    }

    private ResolutionFetcher() {
    }
}

