/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.word.DocumentEvents2;
import com.arcway.lib.eclipse.ole.word.impl.RangeImpl;
import com.arcway.lib.eclipse.ole.word.impl.XMLNodeImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class DocumentEvents2Listener
extends AbstractOleEventsListener {
    private Set<DocumentEvents2> listeners = new HashSet<DocumentEvents2>();

    public DocumentEvents2Listener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(DocumentEvents2 listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(DocumentEvents2 listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 4: {
                this.fireNew(oleEvent);
                break;
            }
            case 5: {
                this.fireOpen(oleEvent);
                break;
            }
            case 6: {
                this.fireClose(oleEvent);
                break;
            }
            case 7: {
                this.fireSync(oleEvent);
                break;
            }
            case 8: {
                this.fireXMLAfterInsert(oleEvent);
                break;
            }
            case 9: {
                this.fireXMLBeforeDelete(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireNew(OleEvent oleEvent) {
        for (DocumentEvents2 l : this.listeners) {
            l.New();
        }
    }

    private void fireOpen(OleEvent oleEvent) {
        for (DocumentEvents2 l : this.listeners) {
            l.Open();
        }
    }

    private void fireClose(OleEvent oleEvent) {
        for (DocumentEvents2 l : this.listeners) {
            l.Close();
        }
    }

    private void fireSync(OleEvent oleEvent) {
        int syncEventType = oleEvent.arguments[0].getInt();
        for (DocumentEvents2 l : this.listeners) {
            l.Sync(syncEventType);
        }
    }

    private void fireXMLAfterInsert(OleEvent oleEvent) {
        XMLNodeImpl newXMLNode = new XMLNodeImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean inUndoRedo = oleEvent.arguments[1].getBoolean();
        for (DocumentEvents2 l : this.listeners) {
            l.XMLAfterInsert(newXMLNode, inUndoRedo);
        }
    }

    private void fireXMLBeforeDelete(OleEvent oleEvent) {
        RangeImpl deletedRange = new RangeImpl(oleEvent.arguments[0], this.getResourceManager());
        XMLNodeImpl oldXMLNode = new XMLNodeImpl(oleEvent.arguments[1], this.getResourceManager());
        boolean inUndoRedo = oleEvent.arguments[2].getBoolean();
        for (DocumentEvents2 l : this.listeners) {
            l.XMLBeforeDelete(deletedRange, oldXMLNode, inUndoRedo);
        }
    }
}

