/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types.pointer;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.pointer.AbstractPointer;
import au.com.swz.swttocom.swt.types.pointer.IPointer;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;

public class IUnknownPointer
extends AbstractPointer
implements IPointer {
    private IUnknown unknownData;

    public IUnknownPointer(ResourceManager resourceManager) {
        this(0, resourceManager);
    }

    public IUnknownPointer(int address, ResourceManager resourceManager) {
        super(resourceManager);
        this.resourcePackage.setPointerAddress(address);
    }

    public IUnknown getValue() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            int[] hMem = new int[1];
            OS.MoveMemory((int[])hMem, (int)this.resourcePackage.getPointerAddress(), (int)4);
            if (hMem[0] != 0) {
                this.unknownData = new IUnknown(hMem[0]);
            }
        }
        return this.unknownData;
    }

    public void setValue(IUnknown unknownData) {
        this.unknownData = unknownData;
        if (this.resourcePackage.getPointerAddress() > 0 && unknownData != null) {
            COM.MoveMemory((int)this.resourcePackage.getPointerAddress(), (int[])new int[]{unknownData.getAddress()}, (int)4);
        }
    }

    @Override
    public int getAddress() {
        if (this.resourcePackage.getPointerAddress() == 0) {
            int address = OS.GlobalAlloc((int)64, (int)4);
            if (this.unknownData != null) {
                COM.MoveMemory((int)address, (int[])new int[]{this.unknownData.getAddress()}, (int)4);
            }
        }
        return this.resourcePackage.getPointerAddress();
    }

    @Override
    public void setAddress(int address) {
        this.resourcePackage.setPointerAddress(address);
    }

    @Override
    public void dispose() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            this.resourcePackage.dispose();
        }
    }
}

