/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types;

import au.com.swz.swttocom.swt.types.OleEventSink;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IProvideClassInfo;
import org.eclipse.swt.internal.ole.win32.IProvideClassInfo2;
import org.eclipse.swt.internal.ole.win32.ITypeInfo;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class OleEventManager {
    private OleEventSink[] oleEventSink = new OleEventSink[0];
    private GUID[] oleEventSinkGUID = new GUID[0];
    private int[] oleEventSinkIUnknown = new int[0];

    void addEventListener(OleAutomation oleAutomation, GUID riid, int eventID, OleListener listener) {
        if (listener == null) {
            OLE.error((int)4);
        }
        Variant v = new Variant(oleAutomation);
        IDispatch objIUnknown = v.getDispatch();
        if (riid == null) {
            riid = OleEventManager.getDefaultEventSinkGUID((IUnknown)objIUnknown);
        }
        if (riid == null) {
            OLE.error((int)1004);
        }
        this.addEventListener(objIUnknown.getAddress(), riid, eventID, listener);
    }

    void removeEventListener(OleAutomation oleAutomation, GUID riid, int eventID, OleListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        Variant v = new Variant(oleAutomation);
        IDispatch objIUnknown = v.getDispatch();
        if (riid == null) {
            riid = OleEventManager.getDefaultEventSinkGUID((IUnknown)objIUnknown);
        }
        if (riid == null) {
            OLE.error((int)1004);
        }
        if (riid != null) {
            this.removeEventListener(objIUnknown.getAddress(), riid, eventID, listener);
        }
    }

    public void dispose() {
        this.disconnectEventSinks();
    }

    private static GUID getDefaultEventSinkGUID(IUnknown unknown) {
        int[] ppvObject = new int[1];
        if (unknown.QueryInterface(COM.IIDIProvideClassInfo2, ppvObject) == 0) {
            IProvideClassInfo2 pci2 = new IProvideClassInfo2(ppvObject[0]);
            GUID riid = new GUID();
            int result = pci2.GetGUID(1, riid);
            pci2.Release();
            if (result == 0) {
                return riid;
            }
        }
        if (unknown.QueryInterface(COM.IIDIProvideClassInfo, ppvObject) == 0) {
            IProvideClassInfo pci = new IProvideClassInfo(ppvObject[0]);
            int[] ppTI = new int[1];
            int[] ppEI = new int[1];
            int result = pci.GetClassInfo(ppTI);
            pci.Release();
            if (result == 0 && ppTI[0] != 0) {
                ITypeInfo classInfo = new ITypeInfo(ppTI[0]);
                int[] ppTypeAttr = new int[1];
                result = classInfo.GetTypeAttr(ppTypeAttr);
                if (result == 0 && ppTypeAttr[0] != 0) {
                    TYPEATTR typeAttribute = new TYPEATTR();
                    COM.MoveMemory((TYPEATTR)typeAttribute, (int)ppTypeAttr[0], (int)TYPEATTR.sizeof);
                    classInfo.ReleaseTypeAttr(ppTypeAttr[0]);
                    int implMask = 7;
                    int implBits = 3;
                    int i = 0;
                    while (i < typeAttribute.cImplTypes) {
                        int[] pRefType;
                        int[] pImplTypeFlags = new int[1];
                        if (classInfo.GetImplTypeFlags(i, pImplTypeFlags) == 0 && (pImplTypeFlags[0] & implMask) == implBits && classInfo.GetRefTypeOfImplType(i, pRefType = new int[1]) == 0) {
                            classInfo.GetRefTypeInfo(pRefType[0], ppEI);
                        }
                        ++i;
                    }
                }
                classInfo.Release();
                if (ppEI[0] != 0) {
                    ITypeInfo eventInfo = new ITypeInfo(ppEI[0]);
                    ppTypeAttr = new int[1];
                    result = eventInfo.GetTypeAttr(ppTypeAttr);
                    GUID riid = null;
                    if (result == 0 && ppTypeAttr[0] != 0) {
                        riid = new GUID();
                        COM.MoveMemory((GUID)riid, (int)ppTypeAttr[0], (int)GUID.sizeof);
                        eventInfo.ReleaseTypeAttr(ppTypeAttr[0]);
                    }
                    eventInfo.Release();
                    return riid;
                }
            }
        }
        return null;
    }

    protected void addEventListener(int iunknown, GUID guid, int eventID, OleListener listener) {
        if (listener == null || iunknown == 0 || guid == null) {
            OLE.error((int)4);
        }
        int index = -1;
        int i = 0;
        while (i < this.oleEventSinkGUID.length) {
            if (COM.IsEqualGUID((GUID)this.oleEventSinkGUID[i], (GUID)guid) && iunknown == this.oleEventSinkIUnknown[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            this.oleEventSink[index].addListener(eventID, listener);
        } else {
            int oldLength = this.oleEventSink.length;
            OleEventSink[] newOleEventSink = new OleEventSink[oldLength + 1];
            GUID[] newOleEventSinkGUID = new GUID[oldLength + 1];
            int[] newOleEventSinkIUnknown = new int[oldLength + 1];
            System.arraycopy(this.oleEventSink, 0, newOleEventSink, 0, oldLength);
            System.arraycopy(this.oleEventSinkGUID, 0, newOleEventSinkGUID, 0, oldLength);
            System.arraycopy(this.oleEventSinkIUnknown, 0, newOleEventSinkIUnknown, 0, oldLength);
            this.oleEventSink = newOleEventSink;
            this.oleEventSinkGUID = newOleEventSinkGUID;
            this.oleEventSinkIUnknown = newOleEventSinkIUnknown;
            this.oleEventSink[oldLength] = new OleEventSink(iunknown, guid);
            this.oleEventSinkGUID[oldLength] = guid;
            this.oleEventSinkIUnknown[oldLength] = iunknown;
            this.oleEventSink[oldLength].AddRef();
            this.oleEventSink[oldLength].connect();
            this.oleEventSink[oldLength].addListener(eventID, listener);
        }
    }

    private void disconnectEventSinks() {
        int i = 0;
        while (i < this.oleEventSink.length) {
            OleEventSink sink = this.oleEventSink[i];
            sink.disconnect();
            sink.Release();
            ++i;
        }
        this.oleEventSink = new OleEventSink[0];
        this.oleEventSinkGUID = new GUID[0];
        this.oleEventSinkIUnknown = new int[0];
    }

    protected void removeEventListener(int iunknown, GUID guid, int eventID, OleListener listener) {
        if (listener == null || guid == null) {
            SWT.error((int)4);
        }
        int i = 0;
        while (i < this.oleEventSink.length) {
            if (COM.IsEqualGUID((GUID)this.oleEventSinkGUID[i], (GUID)guid) && iunknown == this.oleEventSinkIUnknown[i]) {
                this.oleEventSink[i].removeListener(eventID, listener);
                if (!this.oleEventSink[i].hasListeners()) {
                    this.oleEventSink[i].disconnect();
                    this.oleEventSink[i].Release();
                    int oldLength = this.oleEventSink.length;
                    if (oldLength == 1) {
                        this.oleEventSink = new OleEventSink[0];
                        this.oleEventSinkGUID = new GUID[0];
                        this.oleEventSinkIUnknown = new int[0];
                    } else {
                        OleEventSink[] newOleEventSink = new OleEventSink[oldLength - 1];
                        System.arraycopy(this.oleEventSink, 0, newOleEventSink, 0, i);
                        System.arraycopy(this.oleEventSink, i + 1, newOleEventSink, i, oldLength - i - 1);
                        this.oleEventSink = newOleEventSink;
                        GUID[] newOleEventSinkGUID = new GUID[oldLength - 1];
                        System.arraycopy(this.oleEventSinkGUID, 0, newOleEventSinkGUID, 0, i);
                        System.arraycopy(this.oleEventSinkGUID, i + 1, newOleEventSinkGUID, i, oldLength - i - 1);
                        this.oleEventSinkGUID = newOleEventSinkGUID;
                        int[] newOleEventSinkIUnknown = new int[oldLength - 1];
                        System.arraycopy(this.oleEventSinkIUnknown, 0, newOleEventSinkIUnknown, 0, i);
                        System.arraycopy(this.oleEventSinkIUnknown, i + 1, newOleEventSinkIUnknown, i, oldLength - i - 1);
                        this.oleEventSinkIUnknown = newOleEventSinkIUnknown;
                    }
                }
                return;
            }
            ++i;
        }
    }
}

