/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.excel.RefreshEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class RefreshEventsListener
extends AbstractOleEventsListener {
    private final Set<RefreshEvents> listeners = new HashSet<RefreshEvents>();

    public RefreshEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(RefreshEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(RefreshEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1596: {
                this.fireBeforeRefresh(oleEvent);
                break;
            }
            case 1597: {
                this.fireAfterRefresh(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireBeforeRefresh(OleEvent oleEvent) {
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[0].getByRef(), this.getResourceManager());
        for (RefreshEvents l : this.listeners) {
            l.BeforeRefresh(cancel);
        }
        cancel.setAddress(0);
    }

    private void fireAfterRefresh(OleEvent oleEvent) {
        boolean success = oleEvent.arguments[0].getBoolean();
        for (RefreshEvents l : this.listeners) {
            l.AfterRefresh(success);
        }
    }
}

