/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import au.com.swz.swttocom.swt.types.IManagedAutomationObject;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.excel.AppEvents;
import com.arcway.lib.eclipse.ole.excel.Workbook;
import com.arcway.lib.eclipse.ole.excel.impl.HyperlinkImpl;
import com.arcway.lib.eclipse.ole.excel.impl.PivotTableImpl;
import com.arcway.lib.eclipse.ole.excel.impl.RangeImpl;
import com.arcway.lib.eclipse.ole.excel.impl.WindowImpl;
import com.arcway.lib.eclipse.ole.excel.impl.XmlMapImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class AppEventsListener
extends AbstractOleEventsListener {
    private final Set<AppEvents> listeners = new HashSet<AppEvents>();

    public AppEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(AppEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(AppEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1565: {
                this.fireNewWorkbook(oleEvent);
                break;
            }
            case 1558: {
                this.fireSheetSelectionChange(oleEvent);
                break;
            }
            case 1559: {
                this.fireSheetBeforeDoubleClick(oleEvent);
                break;
            }
            case 1560: {
                this.fireSheetBeforeRightClick(oleEvent);
                break;
            }
            case 1561: {
                this.fireSheetActivate(oleEvent);
                break;
            }
            case 1562: {
                this.fireSheetDeactivate(oleEvent);
                break;
            }
            case 1563: {
                this.fireSheetCalculate(oleEvent);
                break;
            }
            case 1564: {
                this.fireSheetChange(oleEvent);
                break;
            }
            case 1567: {
                this.fireWorkbookOpen(oleEvent);
                break;
            }
            case 1568: {
                this.fireWorkbookActivate(oleEvent);
                break;
            }
            case 1569: {
                this.fireWorkbookDeactivate(oleEvent);
                break;
            }
            case 1570: {
                this.fireWorkbookBeforeClose(oleEvent);
                break;
            }
            case 1571: {
                this.fireWorkbookBeforeSave(oleEvent);
                break;
            }
            case 1572: {
                this.fireWorkbookBeforePrint(oleEvent);
                break;
            }
            case 1573: {
                this.fireWorkbookNewSheet(oleEvent);
                break;
            }
            case 1574: {
                this.fireWorkbookAddinInstall(oleEvent);
                break;
            }
            case 1575: {
                this.fireWorkbookAddinUninstall(oleEvent);
                break;
            }
            case 1554: {
                this.fireWindowResize(oleEvent);
                break;
            }
            case 1556: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 1557: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 1854: {
                this.fireSheetFollowHyperlink(oleEvent);
                break;
            }
            case 2157: {
                this.fireSheetPivotTableUpdate(oleEvent);
                break;
            }
            case 2160: {
                this.fireWorkbookPivotTableCloseConnection(oleEvent);
                break;
            }
            case 2161: {
                this.fireWorkbookPivotTableOpenConnection(oleEvent);
                break;
            }
            case 2289: {
                this.fireWorkbookSync(oleEvent);
                break;
            }
            case 2290: {
                this.fireWorkbookBeforeXmlImport(oleEvent);
                break;
            }
            case 2291: {
                this.fireWorkbookAfterXmlImport(oleEvent);
                break;
            }
            case 2292: {
                this.fireWorkbookBeforeXmlExport(oleEvent);
                break;
            }
            case 2293: {
                this.fireWorkbookAfterXmlExport(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireNewWorkbook(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.NewWorkbook(wb);
        }
    }

    private void fireSheetSelectionChange(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetSelectionChange((IManagedAutomationObject)sh, target);
        }
    }

    private void fireSheetBeforeDoubleClick(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetBeforeDoubleClick((IManagedAutomationObject)sh, target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireSheetBeforeRightClick(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetBeforeRightClick((IManagedAutomationObject)sh, target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireSheetActivate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetActivate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetDeactivate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetDeactivate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetCalculate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetCalculate((IManagedAutomationObject)sh);
        }
    }

    private void fireSheetChange(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        RangeImpl target = new RangeImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetChange((IManagedAutomationObject)sh, target);
        }
    }

    private void fireWorkbookOpen(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookOpen(wb);
        }
    }

    private void fireWorkbookActivate(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookActivate(wb);
        }
    }

    private void fireWorkbookDeactivate(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookDeactivate(wb);
        }
    }

    private void fireWorkbookBeforeClose(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookBeforeClose(wb, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWorkbookBeforeSave(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUI = oleEvent.arguments[1].getBoolean();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookBeforeSave(wb, saveAsUI, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWorkbookBeforePrint(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookBeforePrint(wb, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWorkbookNewSheet(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookNewSheet(wb, (IManagedAutomationObject)sh);
        }
    }

    private void fireWorkbookAddinInstall(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookAddinInstall(wb);
        }
    }

    private void fireWorkbookAddinUninstall(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookAddinUninstall(wb);
        }
    }

    private void fireWindowResize(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WindowResize(wb, wn);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WindowActivate(wb, wn);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WindowDeactivate(wb, wn);
        }
    }

    private void fireSheetFollowHyperlink(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        HyperlinkImpl target = new HyperlinkImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetFollowHyperlink((IManagedAutomationObject)sh, target);
        }
    }

    private void fireSheetPivotTableUpdate(OleEvent oleEvent) {
        AutomationObjectImpl sh = new AutomationObjectImpl(oleEvent.arguments[0], this.getResourceManager());
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.SheetPivotTableUpdate((IManagedAutomationObject)sh, target);
        }
    }

    private void fireWorkbookPivotTableCloseConnection(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookPivotTableCloseConnection(wb, target);
        }
    }

    private void fireWorkbookPivotTableOpenConnection(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[1], this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookPivotTableOpenConnection(wb, target);
        }
    }

    private void fireWorkbookSync(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        int syncEventType = oleEvent.arguments[1].getInt();
        for (AppEvents l : this.listeners) {
            l.WorkbookSync(wb, syncEventType);
        }
    }

    private void fireWorkbookBeforeXmlImport(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[1], this.getResourceManager());
        String url = oleEvent.arguments[2].getString();
        boolean isRefresh = oleEvent.arguments[3].getBoolean();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[4].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookBeforeXmlImport(wb, map, url, isRefresh, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWorkbookAfterXmlImport(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[1], this.getResourceManager());
        boolean isRefresh = oleEvent.arguments[2].getBoolean();
        int result = oleEvent.arguments[3].getInt();
        for (AppEvents l : this.listeners) {
            l.WorkbookAfterXmlImport(wb, map, isRefresh, result);
        }
    }

    private void fireWorkbookBeforeXmlExport(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[1], this.getResourceManager());
        String url = oleEvent.arguments[2].getString();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (AppEvents l : this.listeners) {
            l.WorkbookBeforeXmlExport(wb, map, url, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWorkbookAfterXmlExport(OleEvent oleEvent) {
        Workbook wb = new Workbook(oleEvent.arguments[0], this.getResourceManager());
        XmlMapImpl map = new XmlMapImpl(oleEvent.arguments[1], this.getResourceManager());
        String url = oleEvent.arguments[2].getString();
        int result = oleEvent.arguments[3].getInt();
        for (AppEvents l : this.listeners) {
            l.WorkbookAfterXmlExport(wb, map, url, result);
        }
    }
}

