/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.excel.RefreshEvents;
import com.arcway.lib.eclipse.ole.excel._QueryTable;
import com.arcway.lib.eclipse.ole.excel.impl.RefreshEventsListener;
import com.arcway.lib.eclipse.ole.excel.impl._QueryTableImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class QueryTable
extends _QueryTableImpl {
    private static final ILogger logger = Logger.getLogger(QueryTable.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{59191DA1-EA47-11CE-A51F-00AA0061507F}");
    private RefreshEventsListener refreshEvents;

    public QueryTable(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public QueryTable(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _QueryTable create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _QueryTableImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _QueryTableImpl _QueryTableImpl2 = new _QueryTableImpl(appVariant, resourceManager);
            return _QueryTableImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addRefreshEventsListener(RefreshEvents listener) {
        if (this.refreshEvents == null) {
            this.refreshEvents = new RefreshEventsListener(this.getResourceManager());
            this.addEventListener(RefreshEvents.IID, 1596, (OleListener)this.refreshEvents);
            this.addEventListener(RefreshEvents.IID, 1597, (OleListener)this.refreshEvents);
        }
        return this.refreshEvents.addListener(listener);
    }

    public boolean removeRefreshEventsListener(RefreshEvents listener) {
        boolean bRtn = this.refreshEvents.removeListener(listener);
        if (this.refreshEvents.isEmpty()) {
            this.removeEventListener(RefreshEvents.IID, 1596, (OleListener)this.refreshEvents);
            this.removeEventListener(RefreshEvents.IID, 1597, (OleListener)this.refreshEvents);
            this.refreshEvents = null;
        }
        return bRtn;
    }
}

