/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.excel.AppEvents;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.eclipse.ole.excel.impl.AppEventsListener;
import com.arcway.lib.eclipse.ole.excel.impl._ApplicationImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Application
extends _ApplicationImpl {
    private static final ILogger logger = Logger.getLogger(Application.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{00024500-0000-0000-C000-000000000046}");
    private AppEventsListener appEvents;

    public Application(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Application(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _Application create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _ApplicationImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _ApplicationImpl _ApplicationImpl2 = new _ApplicationImpl(appVariant, resourceManager);
            return _ApplicationImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addAppEventsListener(AppEvents listener) {
        if (this.appEvents == null) {
            this.appEvents = new AppEventsListener(this.getResourceManager());
            this.addEventListener(AppEvents.IID, 1565, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1558, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1559, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1560, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1561, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1562, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1563, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1564, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1567, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1568, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1569, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1570, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1571, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1572, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1573, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1574, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1575, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1554, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1556, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1557, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 1854, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2157, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2160, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2161, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2289, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2290, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2291, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2292, (OleListener)this.appEvents);
            this.addEventListener(AppEvents.IID, 2293, (OleListener)this.appEvents);
        }
        return this.appEvents.addListener(listener);
    }

    public boolean removeAppEventsListener(AppEvents listener) {
        boolean bRtn = this.appEvents.removeListener(listener);
        if (this.appEvents.isEmpty()) {
            this.removeEventListener(AppEvents.IID, 1565, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1558, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1559, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1560, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1561, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1562, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1563, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1564, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1567, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1568, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1569, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1570, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1571, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1572, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1573, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1574, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1575, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1554, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1556, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1557, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 1854, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2157, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2160, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2161, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2289, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2290, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2291, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2292, (OleListener)this.appEvents);
            this.removeEventListener(AppEvents.IID, 2293, (OleListener)this.appEvents);
            this.appEvents = null;
        }
        return bRtn;
    }
}

