/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gef.graphics.devicedrivers;

import com.arcway.lib.eclipse.gef.graphics.devicedrivers.DeviceDriverDraw2DGraphicsFitter;
import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTFont;
import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.graphics.SWTRenderer;
import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverInterpolating;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.text.EXFontSizeTooSmall;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.java.To;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DeviceDriverDraw2DGraphics
extends DeviceDriverInterpolating {
    private static final ILogger logger = Logger.getLogger(DeviceDriverDraw2DGraphics.class);
    private static Boolean ADVANCED_GRAPHICS_API_AVAILABLE_AT_ALL = null;
    private final Graphics graphics;
    private final DeviceDriverDraw2DGraphicsFitter fitter;
    private Color draw2DForegroundColor;
    private Color draw2DBackgroundColor;
    private Font currentFont;
    private final Font initialFont;
    private String currentFontName;
    private int currentFontStyle;
    private double currentLineHeight;
    private static Class<? extends Throwable> lastSWTExceptionType = null;
    private boolean advancedGraphicsAPIEnabled;
    private final GC gc;
    private final Device device;

    public DeviceDriverDraw2DGraphics(Graphics graphics) {
        block7: {
            this.draw2DForegroundColor = null;
            this.draw2DBackgroundColor = null;
            this.currentFont = null;
            this.currentFontName = "";
            this.currentFontStyle = 0;
            this.currentLineHeight = 0.0;
            this.advancedGraphicsAPIEnabled = false;
            assert (graphics != null) : "graphics = null";
            Display currentDevice = Display.getCurrent();
            if (currentDevice == null) {
                currentDevice = new Display();
            }
            this.device = currentDevice;
            this.gc = new GC((Drawable)this.device);
            this.initialFont = graphics.getFont();
            this.graphics = graphics;
            this.fitter = new DeviceDriverDraw2DGraphicsFitter();
            if (this.isAdvancedGraphicsAPIAvailableAtAll()) {
                try {
                    graphics.setAntialias(1);
                    graphics.setTextAntialias(1);
                    graphics.setInterpolation(0);
                    graphics.setAlpha(255);
                    this.advancedGraphicsAPIEnabled = true;
                }
                catch (SWTException e) {
                    if (lastSWTExceptionType != ((Object)((Object)e)).getClass()) {
                        lastSWTExceptionType = ((Object)((Object)e)).getClass();
                        logger.debug("Could not initialize Advanced Graphics API.");
                    }
                }
                catch (RuntimeException e) {
                    if (lastSWTExceptionType == e.getClass()) break block7;
                    lastSWTExceptionType = e.getClass();
                    logger.debug("Could not initialize Advanced Graphics API.");
                }
            }
        }
        graphics.setLineCap(2);
        graphics.setLineJoin(2);
        graphics.setLineStyle(1);
        this.setLineWidth(To.toDouble((int)graphics.getLineWidth()));
        this.setLineScale(this.getLineWidth());
        this.setLineColor(this.colorFromSWT(graphics.getForegroundColor()));
        this.setTextColor(this.colorFromSWT(graphics.getForegroundColor()));
        this.setFillAttributes(new com.arcway.lib.graphics.Color(this.colorFromSWT(graphics.getBackgroundColor())), 255);
    }

    private boolean isAdvancedGraphicsAPIAvailableAtAll() {
        if (ADVANCED_GRAPHICS_API_AVAILABLE_AT_ALL == null) {
            Image swtImage = new Image(null, 16, 1);
            GC testGC = new GC((Drawable)swtImage);
            testGC.setAdvanced(true);
            boolean advancedGraphicsAPIAvailable = testGC.getAdvanced();
            testGC.dispose();
            swtImage.dispose();
            ADVANCED_GRAPHICS_API_AVAILABLE_AT_ALL = new Boolean(advancedGraphicsAPIAvailable);
            if (!advancedGraphicsAPIAvailable) {
                logger.info("Advanced Graphics API not available. Use e.g. Windows XP, Windows GDI+ extension or Cairo on linux to improve drawing.");
            }
        }
        return ADVANCED_GRAPHICS_API_AVAILABLE_AT_ALL;
    }

    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            this.withTransformation(optionalTransformation, runnable);
        } else {
            runnable.run();
        }
    }

    private <T extends Throwable> void withTransformation(TransformationAffiliate transformation, IDeviceRunnable<T> runnable) throws T {
        this.graphics.pushState();
        TransformationAffiliate.Concatenation concatenation = transformation.toConcatenation();
        if (concatenation != null) {
            double shearingX;
            GeoVector scaling = concatenation.getScaling();
            double sx = scaling.x;
            double sy = scaling.y;
            double m = shearingX = concatenation.getShearingX();
            Direction rotation = concatenation.getRotation();
            double phiInDegrees = rotation.getAngle();
            GeoVector translation = concatenation.getTranslation();
            double dx = translation.x;
            double dy = translation.y;
            if (!Geo.isZero((double)sx) || !Geo.isZero((double)sx)) {
                this.graphics.scale((float)sx, (float)sy);
            }
            if (!Geo.isZero((double)m)) {
                this.graphics.shear((float)m, 0.0f);
            }
            if (!Geo.isZero((double)phiInDegrees)) {
                this.graphics.rotate((float)phiInDegrees);
            }
            if (!Geo.isZero((double)dx) || !Geo.isZero((double)dy)) {
                this.graphics.translate((float)dx, (float)dy);
            }
        }
        runnable.run();
        this.graphics.popState();
    }

    public void setLineColor(com.arcway.lib.graphics.Color lineColor) {
        super.setLineColor(lineColor);
        this.updateForegroundColorForLineDrawing();
    }

    public void setLineWidth(double lineWidth) {
        super.setLineWidth(lineWidth);
        this.graphics.setLineWidth((int)this.fitter.lineWidthFit(lineWidth));
    }

    public void setFillAttributes(com.arcway.lib.graphics.Color fillColor, int fillAlpha) {
        super.setFillAttributes(fillColor, fillAlpha);
        this.updateBackgroundColorForFillDrawing();
    }

    public void setTextFontName(String fontName) {
        super.setTextFontName(fontName);
    }

    public void setTextSize(double height, double textTop, double textAscent, double textDescent) {
        super.setTextSize(height, textTop, textAscent, textDescent);
    }

    public void setTextBold(boolean bold) {
        super.setTextBold(bold);
    }

    public void setTextItalic(boolean italic) {
        super.setTextItalic(italic);
    }

    protected void fillPoints(Points points) {
        assert (points != null) : "points = null";
        if (this.getFillAlpha() == 255 || this.advancedGraphicsAPIEnabled && this.getFillAlpha() > 0) {
            if (this.advancedGraphicsAPIEnabled) {
                this.graphics.setAlpha(this.getFillAlpha());
            }
            this.graphics.fillPolygon(this.convertToDraw2DPointList(points));
            if (this.advancedGraphicsAPIEnabled) {
                this.graphics.setAlpha(255);
            }
        }
    }

    public void dispose() {
        this.disposeForegroundColor();
        this.disposeBackgroundColor();
        this.disposeFont();
        this.gc.dispose();
    }

    public void plot(com.arcway.lib.geometry.Point point) {
        double lineWidth = this.getLineWidth();
        int lineWidthInt = (int)Math.round(lineWidth);
        int sub = (int)Math.round(lineWidth / 2.0);
        int x = (int)this.fitter.pointFitX(point.x) - sub;
        int y = (int)this.fitter.pointFitY(point.y) - sub;
        this.updateBackgroundColorForLineDrawing();
        this.graphics.fillOval(x, y, lineWidthInt, lineWidthInt);
        this.updateBackgroundColorForFillDrawing();
    }

    public void line(Line line) {
        if (line.isZeroLengthLine()) {
            this.plot(line.start);
        } else {
            this.graphics.drawLine((int)this.fitter.pointFitX(line.start.x), (int)this.fitter.pointFitY(line.start.y), (int)this.fitter.pointFitX(line.end.x), (int)this.fitter.pointFitY(line.end.y));
        }
    }

    public void arc(Arc arc) {
        Points points = arc.getPointsApproximated(50, 1.0);
        this.graphics.drawPolyline(this.convertToDraw2DPointList(points));
    }

    public void skipPlot(com.arcway.lib.geometry.Point point) {
    }

    public void skipLine(Line line) {
    }

    public void skipArc(Arc arc) {
    }

    public boolean isNotInterestedInRealTextDrawing() {
        return false;
    }

    public void text(com.arcway.lib.geometry.Point p, double textLength, String text, TurnedRectangle turnedClippingHint) {
        assert (p != null) : "p = null";
        assert (text != null) : "text = null";
        assert (turnedClippingHint != null) : "turnedClippingHint = null";
        if (this.getTextLineHeight() > 1.0E-10) {
            this.updateFont();
            if (this.currentFont != null) {
                double textLengthDraw2D = this.getTextLength(text);
                double textTopDraw2D = this.getTextTopDraw2D();
                this.updateForegroundColorForTextDrawing();
                if (this.advancedGraphicsAPIEnabled) {
                    boolean useRotation;
                    this.graphics.pushState();
                    boolean useScalingToCorrectFontSizeRoundingError = false;
                    double fX = 1.0;
                    double fY = 1.0;
                    if (useScalingToCorrectFontSizeRoundingError &= this.graphics instanceof SWTGraphics) {
                        double textHeightDraw2D;
                        if (textLengthDraw2D > 1.0E-10) {
                            fX = textLength / textLengthDraw2D;
                        }
                        if ((textHeightDraw2D = textTopDraw2D - this.getTextDescentDraw2D()) > 1.0E-10) {
                            fY = this.getTextLineHeight() / textHeightDraw2D;
                        }
                    }
                    com.arcway.lib.geometry.Point textBasePoint = this.calculateTextBasePoint(p, textLengthDraw2D * fX, textTopDraw2D * fY);
                    this.graphics.translate((float)textBasePoint.x, (float)textBasePoint.y);
                    if (!(!(textLength > 1.0E-10) || Geo.equals((double)fX, (double)1.0) && Geo.equals((double)fY, (double)1.0))) {
                        this.graphics.scale((float)fX, (float)fY);
                    }
                    if (useRotation = this.graphics instanceof SWTGraphics) {
                        Direction direction = this.getTextDirection();
                        double angle = direction.getAngle();
                        float angleSWT = (float)(-angle);
                        this.graphics.rotate(angleSWT);
                    }
                    this.graphics.drawString(text, 0, 0);
                    this.graphics.popState();
                } else {
                    com.arcway.lib.geometry.Point textBasePoint = this.calculateTextBasePoint(p, textLengthDraw2D, textTopDraw2D);
                    this.graphics.drawString(text, (int)this.fitter.pointFitX(textBasePoint.x), (int)this.fitter.pointFitY(textBasePoint.y));
                }
                this.updateForegroundColorForLineDrawing();
            }
        }
    }

    private com.arcway.lib.geometry.Point calculateTextBasePoint(com.arcway.lib.geometry.Point p, double textLenght, double textTop) {
        GeoVector textOffset = this.calculateTextOffset(textLenght, textTop);
        Direction direction = this.getTextDirection();
        return p.movePoint(textOffset.turn(direction));
    }

    private GeoVector calculateTextOffset(double textLength, double textTop) {
        double xOff;
        switch (this.getTextAlignment()) {
            case 2: {
                xOff = -textLength / 2.0;
                break;
            }
            case 4: {
                xOff = -textLength;
                break;
            }
            default: {
                xOff = 0.0;
            }
        }
        return new GeoVector(xOff, -textTop);
    }

    private double getTextTopDraw2D() {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextTop((GC)this.gc, (Font)this.currentFont);
    }

    private double getTextDescentDraw2D() {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextDescent((GC)this.gc, (Font)this.currentFont);
    }

    private double getTextLength(String text) {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextLength((GC)this.gc, (Font)this.currentFont, (String)text);
    }

    private void updateForegroundColorForLineDrawing() {
        this.setForegroundColor(this.getLineColor());
    }

    private void updateForegroundColorForTextDrawing() {
        this.setForegroundColor(this.getTextColor());
    }

    private void setForegroundColor(com.arcway.lib.graphics.Color color) {
        if (!color.equalsColor(this.colorFromSWT(this.graphics.getForegroundColor()))) {
            this.disposeForegroundColor();
        }
        if (this.draw2DForegroundColor == null) {
            this.draw2DForegroundColor = this.createSWTColor(color);
            this.graphics.setForegroundColor(this.draw2DForegroundColor);
        }
    }

    private void disposeForegroundColor() {
        if (this.draw2DForegroundColor != null) {
            if (this.graphics.getForegroundColor() == this.draw2DForegroundColor) {
                this.graphics.setForegroundColor(ColorConstants.black);
            }
            this.draw2DForegroundColor.dispose();
            this.draw2DForegroundColor = null;
        }
    }

    private void updateBackgroundColorForFillDrawing() {
        this.setBackgroundColor(this.getFillColor());
    }

    private void updateBackgroundColorForLineDrawing() {
        this.setBackgroundColor(this.getLineColor());
    }

    private void setBackgroundColor(com.arcway.lib.graphics.Color fillColor) {
        if (!fillColor.equalsColor(this.colorFromSWT(this.graphics.getBackgroundColor()))) {
            this.disposeBackgroundColor();
        }
        if (this.draw2DBackgroundColor == null) {
            this.draw2DBackgroundColor = this.createSWTColor(fillColor);
            this.graphics.setBackgroundColor(this.draw2DBackgroundColor);
        }
    }

    private void disposeBackgroundColor() {
        if (this.draw2DBackgroundColor != null) {
            if (this.graphics.getBackgroundColor() == this.draw2DBackgroundColor) {
                this.graphics.setBackgroundColor(ColorConstants.white);
            }
            this.draw2DBackgroundColor.dispose();
            this.draw2DBackgroundColor = null;
        }
    }

    private void updateFont() {
        this.setFont(this.getTextFontName(), this.isTextBold(), this.isTextItalic());
    }

    private void setFont(String newFontName, boolean bold, boolean italic) {
        int newFontStyle = this.calculateSWTFontStyle(bold, italic);
        if (!(this.currentFont == null || newFontStyle == this.currentFontStyle && Geo.equals((double)this.getTextLineHeight(), (double)this.currentLineHeight) && newFontName.equals(this.currentFontName))) {
            this.disposeFont();
        }
        if (this.currentFont == null) {
            this.currentFontName = newFontName;
            this.currentFontStyle = newFontStyle;
            this.currentLineHeight = this.getTextLineHeight();
            try {
                try {
                    this.currentFont = SWTFont.createSWTFont((Device)this.device, (GC)this.gc, (double)this.currentLineHeight, (TextStyle)new TextStyle(newFontName, bold, italic));
                }
                catch (EXFontSizeTooSmall e) {
                    this.currentFont = null;
                }
            }
            catch (EXNoMoreHandles e) {
                this.currentFont = null;
            }
        }
        if (this.currentFont != null) {
            this.graphics.setFont(this.currentFont);
        }
    }

    private void disposeFont() {
        if (this.currentFont != null) {
            if (this.graphics.getFont() != this.initialFont) {
                this.graphics.setFont(this.initialFont);
            }
            if (this.currentFont != this.initialFont) {
                this.currentFont.dispose();
            }
            this.currentFont = null;
        }
    }

    private com.arcway.lib.graphics.Color colorFromSWT(Color swtColor) {
        return new com.arcway.lib.graphics.Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
    }

    private Color createSWTColor(com.arcway.lib.graphics.Color color) {
        return new Color(null, color.r, color.g, color.b);
    }

    private int calculateSWTFontStyle(boolean bold, boolean italic) {
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        return style;
    }

    private PointList convertToDraw2DPointList(Points points) {
        PointList pointList = new PointList();
        int index = 0;
        while (index < points.size()) {
            com.arcway.lib.geometry.Point point = points.get(index);
            int toAddX = (int)this.fitter.pointFitX(point.x);
            int toAddY = (int)this.fitter.pointFitY(point.y);
            boolean toAdd = true;
            if (pointList.size() > 0) {
                Point lastPoint = pointList.getLastPoint();
                if (lastPoint.x == toAddX && lastPoint.y == toAddY) {
                    toAdd = false;
                }
            }
            if (toAdd) {
                pointList.addPoint(new Point(toAddX, toAddY));
            }
            ++index;
        }
        return pointList;
    }

    public void drawImage(IOffscreenBitmap offscreenBitmap, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle scaleToRectangle, int alpha) {
        assert (offscreenBitmap != null);
        assert (sourceX >= 0);
        assert (sourceY >= 0);
        assert (sourceX < offscreenBitmap.getWidthInPixels());
        assert (sourceY < offscreenBitmap.getHeightInPixels());
        assert (sourceW > 0);
        assert (sourceH > 0);
        assert (sourceW <= offscreenBitmap.getWidthInPixels() - sourceX);
        assert (sourceH <= offscreenBitmap.getHeightInPixels() - sourceY);
        assert (scaleToRectangle != null);
        int destX = (int)this.fitter.pointFitX(scaleToRectangle.getUpperLeft().x);
        int destY = (int)this.fitter.pointFitY(scaleToRectangle.getUpperLeft().y);
        int destW = (int)this.fitter.pointFitX(scaleToRectangle.getW().abs());
        int destH = (int)this.fitter.pointFitY(scaleToRectangle.getH().abs());
        if (destW > 0 && destH > 0) {
            boolean created;
            SWTOffscreenBitmap swtOffscreenBitmap;
            IOffscreenBitmap offscreenBitmapToUse;
            Rectangle toDrawSource = new Rectangle((int)this.fitter.pointFitX(sourceX), (int)this.fitter.pointFitY(sourceY), (int)this.fitter.pointFitX(sourceW), (int)this.fitter.pointFitY(sourceH));
            Rectangle toDrawScale = new Rectangle(destX, destY, destW, destH);
            if (offscreenBitmap instanceof com.arcway.lib.graphics.image.Image) {
                com.arcway.lib.graphics.image.Image image = (com.arcway.lib.graphics.image.Image)offscreenBitmap;
                offscreenBitmapToUse = image.getOffscreenBitmap();
            } else {
                offscreenBitmapToUse = offscreenBitmap;
            }
            if (offscreenBitmapToUse instanceof SWTOffscreenBitmap) {
                swtOffscreenBitmap = (SWTOffscreenBitmap)offscreenBitmapToUse;
                created = false;
            } else {
                SWTRenderer renderer = SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread();
                try {
                    swtOffscreenBitmap = renderer.createSWTOffscreenBitmap(offscreenBitmapToUse);
                    created = true;
                }
                catch (EXImageDataTypeNotSupported e) {
                    throw new RuntimeException(e);
                }
                catch (EXImageTooBig e) {
                    throw new RuntimeException(e);
                }
                catch (EXNoMoreHandles e) {
                    throw new RuntimeException(e);
                }
            }
            Image imageToDraw = swtOffscreenBitmap.getWrappedSWTImage();
            int oldAlpha = 255;
            if (this.advancedGraphicsAPIEnabled) {
                oldAlpha = this.graphics.getAlpha();
                this.graphics.setAlpha(alpha);
            }
            this.graphics.pushState();
            float angle = -((float)scaleToRectangle.getDirection().getAngle());
            if (!Geo.isZero((double)(Geo.getNormalizedAngle((double)((double)angle + 1.0E-10)) % 360.0 - 1.0E-10))) {
                float offsetX = (float)scaleToRectangle.getUpperLeft().x;
                float offsetY = (float)scaleToRectangle.getUpperLeft().y;
                this.graphics.translate(offsetX, offsetY);
                this.graphics.rotate(angle);
                this.graphics.translate(-offsetX, -offsetY);
            }
            this.graphics.drawImage(imageToDraw, toDrawSource, toDrawScale);
            this.graphics.popState();
            if (this.advancedGraphicsAPIEnabled) {
                this.graphics.setAlpha(oldAlpha);
            }
            if (created) {
                swtOffscreenBitmap.dispose();
            }
        }
    }

    private void setClipping(com.arcway.lib.geometry.Rectangle clippingRectangle) {
        if (clippingRectangle != null) {
            this.graphics.setClip(DeviceDriverDraw2DGraphicsFitter.convertBoundsToDraw2D(clippingRectangle));
        } else {
            this.graphics.setClip(null);
        }
    }

    public boolean supportsNullImage() {
        return false;
    }

    public boolean driverSupportsTransformationForSubElements() {
        return false;
    }
}

