/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews.contextmenus;

import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.contextmenus.IContextMenuContributor;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.util.List;

public abstract class AbstractContexMenuContributor
implements IContextMenuContributor {
    private IRepositoryTransaction transaction = null;
    protected static final IStreamResource DELETE_STREAM_RESOURCE = new FileResourceInPackage(AbstractContexMenuContributor.class, "delete.gif");

    protected IRepositoryTransactionManager getTransactionManager(IRepositorySnapshotRO snapshot) {
        IRepositoryWorkspaceRO workspace = snapshot.getRepositoryInterface().getWorkspace();
        Assert.checkOperationSupport((boolean)(workspace instanceof IRepositoryWorkspaceRW));
        IRepositoryWorkspaceRW workspaceRW = (IRepositoryWorkspaceRW)workspace;
        return workspaceRW.getTransactionManager();
    }

    protected void executeRun(IRepositorySnapshotRO snapshot, List<AbstractRepositoryAction> actions) {
        if (actions.size() == 1) {
            this.executeRun(snapshot, actions.get(0));
        } else {
            this.openTransaction(snapshot);
            for (AbstractRepositoryAction element : actions) {
                this.appendActionToTransaction(element);
            }
            this.closeTransaction();
        }
    }

    protected void executeRun(IRepositorySnapshotRO snapshot, AbstractRepositoryAction action) {
        try {
            this.getTransactionManager(snapshot).executeAsTransaction(action);
        }
        catch (RuntimeException e) {
            this.getLogger().error((Throwable)e);
            throw e;
        }
        catch (EXNotReproducibleSnapshot e) {
            this.getLogger().error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EXTransactionExecution e) {
            this.getLogger().error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EXPermissionDenied e) {
            this.getLogger().error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EXLockDenied e) {
            this.getLogger().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void openTransaction(IRepositorySnapshotRO snapshot) {
        IRepositoryObjectSample snapshotInformation = snapshot.getSnapshotInformation();
        IRepositoryTypeManagerRO typeManager = snapshot.getTypeManager();
        IRepositoryTransactionManager manager = this.getTransactionManager(snapshot);
        try {
            this.transaction = manager.openTransaction(RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshotInformation, (IRepositoryTypeManagerRO)typeManager));
        }
        catch (EXNotReproducibleSnapshot e) {
            this.getLogger().error((Throwable)e);
        }
    }

    protected void appendActionToTransaction(AbstractRepositoryAction action) {
        assert (this.transaction != null && this.transaction.getState().canActionsBeAppended()) : "Transaction must be open.";
        assert (action != null);
        try {
            this.transaction.appendAction(action);
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e);
        }
    }

    protected void closeTransaction() {
        assert (this.transaction != null) : "Transaction must exist.";
        try {
            this.transaction.closeTransaction();
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e);
        }
    }

    protected abstract ILogger getLogger();
}

