/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryAttributeSetNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryCrossLinkRelationContributionNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContributionReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationContributionReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationContributionReference;
import java.util.ArrayList;

public class RepositoryCrossLinkRelationNode
extends RepositoryDataItemNode {
    private final ICrossLinkRepositoryRelationContributionReference parentRepositoryRelationContributionReference;
    private ICrossLinkRepositoryRelationContribution cachedParentRepositoryRelationContribution = null;
    private static final ILogger logger = Logger.getLogger(RepositoryCrossLinkRelationNode.class);

    public RepositoryCrossLinkRelationNode(ICrossLinkRepositoryRelationContribution parentRepositoryRelationContribution, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.parentRepositoryRelationContributionReference = new CrossLinkRepositoryRelationContributionReference(parentRepositoryRelationContribution);
    }

    public RepositoryCrossLinkRelationNode(ICrossLinkRepositoryRelationContributionReference parentRepositoryRelationContributionReference, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) {
        super(treeViewModelAccessAgent, snapshotID);
        this.parentRepositoryRelationContributionReference = parentRepositoryRelationContributionReference;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getParentNode() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getParentNode() )");
            return null;
        }
        return new RepositoryAttributeSetNode(this.cachedParentRepositoryRelationContribution.getAttributeSet(), this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in hasChildNodes() )");
            return false;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        ICrossLinkRepositoryRelation repositoryRelation = this.cachedParentRepositoryRelationContribution.getRelation();
        ICrossLinkRepositoryRelationType relationType = repositoryRelation.getRelationType();
        ICollection_ contributionTypes = relationType.getAllRelationContributionTypes();
        for (ICrossLinkRepositoryRelationContributionType type : contributionTypes) {
            ICrossLinkRepositoryRelationContribution repositoryRelationContribution = repositoryRelation.getRelationContribution(type);
            CrossLinkRepositoryRelationContributionReference repositoryRelationContributionReference = new CrossLinkRepositoryRelationContributionReference(repositoryRelationContribution);
            if (ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.isEqual((Object)this.parentRepositoryRelationContributionReference, (Object)repositoryRelationContributionReference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ArrayList<RepositoryCrossLinkRelationContributionNode> children = new ArrayList<RepositoryCrossLinkRelationContributionNode>();
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getChildNodes() )");
            return new Object[0];
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        ICrossLinkRepositoryRelation repositoryRelation = this.cachedParentRepositoryRelationContribution.getRelation();
        ICrossLinkRepositoryRelationType relationType = repositoryRelation.getRelationType();
        ICollection_ contributionTypes = relationType.getAllRelationContributionTypes();
        for (ICrossLinkRepositoryRelationContributionType type : contributionTypes) {
            ICrossLinkRepositoryRelationContribution repositoryRelationContribution = repositoryRelation.getRelationContribution(type);
            CrossLinkRepositoryRelationContributionReference repositoryRelationContributionReference = new CrossLinkRepositoryRelationContributionReference(repositoryRelationContribution);
            if (ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.isEqual((Object)this.parentRepositoryRelationContributionReference, (Object)repositoryRelationContributionReference)) continue;
            children.add(new RepositoryCrossLinkRelationContributionNode((ICrossLinkRepositoryRelationContributionReference)repositoryRelationContributionReference, this.parentRepositoryRelationContributionReference.getRelationContributionRoleID(), this.getTreeViewModelAccessAgent(), this.snapshotID));
        }
        return children.toArray();
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getNodeText() )");
            return "";
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getNodeText() )");
            return "";
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendLabel label = treeView.getFrontendTypeManager().getFrontendRelationType(this.cachedParentRepositoryRelationContribution.getRelation().getRelationType()).getLabel();
        return label.getText();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getNodeImage() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getNodeImage() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getNodeImage() )");
            return null;
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendLabel label = treeView.getFrontendTypeManager().getFrontendRelationType(this.cachedParentRepositoryRelationContribution.getRelation().getRelationType()).getLabel();
        return label.getIcon16x16();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryCrossLinkRelationNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        RepositoryCrossLinkRelationNode otherNode = (RepositoryCrossLinkRelationNode)node;
        return ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.isEqual((Object)this.parentRepositoryRelationContributionReference, (Object)otherNode.parentRepositoryRelationContributionReference);
    }

    @Override
    public int hashCode() {
        return ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.getHashCode((Object)this.parentRepositoryRelationContributionReference);
    }

    private void resolveParentRepositoryRelationContributionIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget, EXCrossLinkRelationContributionReferenceCannotBeResolved, EXCrossLinkRelationReferenceCannotBeResolved {
        if (this.cachedParentRepositoryRelationContribution != null && this.cachedParentRepositoryRelationContribution.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedParentRepositoryRelationContribution = RepositoryReferences.getRelationContributionFromReference((ICrossLinkRepositoryRelationContributionReference)this.parentRepositoryRelationContributionReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveParentRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getNodeImage() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getItem() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getItem() )");
            return null;
        }
        return this.cachedParentRepositoryRelationContribution.getRelation();
    }
}

