/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendAttributeSetType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.WidgetReference;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.CustomPropertySpecification;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.ColumnWidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.TableWidgetParameters;
import com.arcway.lib.ui.editor.specification.editor.ColumnSpecification;
import com.arcway.lib.ui.editor.specification.editor.Editor;
import com.arcway.lib.ui.editor.specification.editor.PageSpecification;
import com.arcway.lib.ui.editor.specification.editor.TableSpecification;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationAttributeSetType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationRelationType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategoryReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryEditorLayoutFactory {
    private static final HashMap<Object, WidgetTypeID> WIDGET_TYPE_MAP = RepositoryEditorLayoutFactory.fillDefaultWidgetMap();

    public static List<WidgetReference> generateDefaultLayout(IRepositoryObjectReference repositoryObjectReference, IRepositoryObjectType repositoryObjectType) {
        ArrayList<WidgetReference> pages = new ArrayList<WidgetReference>();
        if (repositoryObjectType != null) {
            boolean firstPage = true;
            for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
                WidgetReference page = new WidgetReference((IWidgetTypeID)WidgetTypeID.FORMPAGE, RepositoryEditorLayoutFactory.getPageWidgetParameters(attributeSetType, repositoryObjectType));
                WidgetReference table = new WidgetReference((IWidgetTypeID)WidgetTypeID.TABLE, (WidgetParameters)RepositoryEditorLayoutFactory.getTableWidgetParameters(attributeSetType, repositoryObjectType));
                page.addChild(table);
                WidgetReference column = new WidgetReference((IWidgetTypeID)WidgetTypeID.COLUMN, (WidgetParameters)RepositoryEditorLayoutFactory.getColumnWidgetParameters(attributeSetType, repositoryObjectType));
                if (firstPage) {
                    if (repositoryObjectType.canBeSpecialisedByCategories() == IRepositoryObjectType.EnumCategorySupportType.YES) {
                        ArrayList<RepositoryObjectTypeCategoryReference> references = new ArrayList<RepositoryObjectTypeCategoryReference>();
                        references.add(new RepositoryObjectTypeCategoryReference(repositoryObjectReference));
                        WidgetReference widgetReference = new WidgetReference(references, (IWidgetTypeID)WidgetTypeID.SINGLECHOICE, new WidgetParameters(ObjectTypeCategoryLabels.LABEL_CATEGORY, "", true, 0, 1));
                        table.addChild(widgetReference);
                        WidgetReference horizontalSeparatorReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.HORIZONTAL_SEPARATOR, new WidgetParameters("", "", false, 0, 1));
                        table.addChild(horizontalSeparatorReference);
                    }
                    firstPage = false;
                }
                String id = "";
                for (IRepositoryPropertyType repositoryPropertyType : attributeSetType.getPropertyTypes()) {
                    IRepositoryDataType dataType = repositoryPropertyType.getDataType();
                    id = repositoryPropertyType.getRepositoryPropertyTypeID().toCanonicalString();
                    RepositoryPropertyReference repositoryPropertyReference = new RepositoryPropertyReference(repositoryObjectReference, repositoryPropertyType.getRepositoryPropertyTypeID());
                    ArrayList<RepositoryPropertyReference> references = new ArrayList<RepositoryPropertyReference>();
                    references.add(repositoryPropertyReference);
                    if (dataType == null) continue;
                    WidgetReference widgetReference = new WidgetReference(references, RepositoryEditorLayoutFactory.getWidgetTypeID(repositoryPropertyType.getRepositoryPropertyTypeID(), repositoryObjectType), RepositoryEditorLayoutFactory.getPropertyWidgetParameters(repositoryPropertyType.getRepositoryPropertyTypeID(), repositoryObjectType));
                    column.addChild(widgetReference);
                }
                for (ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType : attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                    id = repositoryRelationContributionType.getRepositoryRelationContributionRoleID().toCanonicalString();
                    ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution repositoryRelationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)repositoryRelationContributionType.getRelatedRelationType().getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)repositoryRelationContributionType.getRepositoryRelationContributionRoleID(), (IRepositoryPropertySetSample)repositoryObjectReference.getObjectID());
                    ArrayList<ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution> references = new ArrayList<ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution>();
                    references.add(repositoryRelationsReference);
                    WidgetReference widgetReference = new WidgetReference(references, (IWidgetTypeID)WIDGET_TYPE_MAP.get(repositoryRelationContributionType.getCardinality()), RepositoryEditorLayoutFactory.getRelationWidgetParameters(repositoryRelationContributionType, repositoryObjectType, repositoryObjectReference));
                    column.addChild(widgetReference);
                }
                table.addChild(column);
                if (id.contains("uid")) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public static List<WidgetReference> generateLayout(IRepositoryObjectReference repositoryObjectReference, IRepositoryObjectType repositoryObjectType, Editor layoutSpec) {
        ArrayList<WidgetReference> pages = new ArrayList<WidgetReference>();
        for (Object name : layoutSpec.getPageSpecifications()) {
            PageSpecification pageSpec = (PageSpecification)name;
            WidgetReference page = new WidgetReference((IWidgetTypeID)WidgetTypeID.FORMPAGE, pageSpec.getWidgetParameters());
            List tables = pageSpec.getTableSpecifications();
            for (Object name2 : tables) {
                TableSpecification tableSpec = (TableSpecification)name2;
                WidgetReference tableWidgetReference = RepositoryEditorLayoutFactory.getWidgetReferenceForTableSpec(tableSpec, repositoryObjectReference, repositoryObjectType);
                page.addChild(tableWidgetReference);
            }
            pages.add(page);
        }
        return pages;
    }

    private static WidgetReference getWidgetReferenceForTableSpec(TableSpecification tableSpec, IRepositoryObjectReference repositoryObjectReference, IRepositoryObjectType repositoryObjectType) {
        WidgetReference tableWidgetReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.TABLE, tableSpec.getWidgetParameters());
        List children = tableSpec.getChildSpecifications();
        for (IWidgetSpecification child : children) {
            WidgetReference columnWidgetReference;
            ColumnSpecification columnSpec;
            if (child instanceof ColumnSpecification) {
                columnSpec = (ColumnSpecification)child;
                columnWidgetReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.COLUMN, (WidgetParameters)columnSpec.getWidgetParameters());
                tableWidgetReference.addChild(columnWidgetReference);
                List columnChildren = columnSpec.getChildSpecifications();
                for (IWidgetSpecification columnChild : columnChildren) {
                    if (columnChild instanceof CustomPropertySpecification) {
                        CustomPropertySpecification columnChildSpec = (CustomPropertySpecification)columnChild;
                        WidgetReference columnChildWidgetReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.COLUMN, columnChildSpec.getWidgetParameters());
                        columnWidgetReference.addChild(columnChildWidgetReference);
                        continue;
                    }
                    if (!(columnChild instanceof WidgetSpecification)) continue;
                    WidgetReference widgetReference = RepositoryEditorLayoutFactory.getWidgetReferenceForWidgetSpec((WidgetSpecification)columnChild, repositoryObjectReference, repositoryObjectType);
                    columnWidgetReference.addChild(widgetReference);
                }
                continue;
            }
            if (child instanceof CustomPropertySpecification) {
                columnSpec = (CustomPropertySpecification)child;
                columnWidgetReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.COLUMN, columnSpec.getWidgetParameters());
                tableWidgetReference.addChild(columnWidgetReference);
                continue;
            }
            if (child instanceof WidgetSpecification) {
                WidgetReference widgetReference = RepositoryEditorLayoutFactory.getWidgetReferenceForWidgetSpec((WidgetSpecification)child, repositoryObjectReference, repositoryObjectType);
                tableWidgetReference.addChild(widgetReference);
                continue;
            }
            if (!(child instanceof TableSpecification)) continue;
            WidgetReference childTableWidgetReference = RepositoryEditorLayoutFactory.getWidgetReferenceForTableSpec((TableSpecification)child, repositoryObjectReference, repositoryObjectType);
            tableWidgetReference.addChild(childTableWidgetReference);
        }
        return tableWidgetReference;
    }

    private static WidgetReference getWidgetReferenceForWidgetSpec(WidgetSpecification widgetSpec, IRepositoryObjectReference repositoryObjectReference, IRepositoryObjectType repositoryObjectType) {
        WidgetReference widgetReference = null;
        IRepositoryPropertyTypeID namePropertyTypeID = null;
        ArrayList<Object> contentReferences = new ArrayList<Object>();
        if (widgetSpec.isObjectTypeCategoryContained()) {
            assert (repositoryObjectType.canBeSpecialisedByCategories() == IRepositoryObjectType.EnumCategorySupportType.YES);
            RepositoryObjectTypeCategoryReference repositoryObjectTypeCategoryReference = new RepositoryObjectTypeCategoryReference(repositoryObjectReference);
            contentReferences.add(repositoryObjectTypeCategoryReference);
        }
        for (Object e : widgetSpec.getPropertyTypeIDs()) {
            final String id = (String)e;
            IRepositoryPropertyTypeID propertyTypeID = new IRepositoryPropertyTypeID(){

                public String toCanonicalString() {
                    return id.trim();
                }
            };
            if (namePropertyTypeID == null) {
                namePropertyTypeID = propertyTypeID;
            }
            RepositoryPropertyReference repositoryPropertyReference = new RepositoryPropertyReference(repositoryObjectReference, propertyTypeID);
            contentReferences.add(repositoryPropertyReference);
        }
        for (Object object : widgetSpec.getRelationTypeIDs2relationContributionRoleIDs().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            final String relationTypeID = (String)entry.getKey();
            IRepositoryRelationTypeID repositoryRelationTypeID = new IRepositoryRelationTypeID(){

                public String toCanonicalString() {
                    return relationTypeID.trim();
                }
            };
            final String roleID = (String)entry.getValue();
            IRepositoryRelationContributionRoleID repositoryRelationContributionRoleID = new IRepositoryRelationContributionRoleID(){

                public String toCanonicalString() {
                    return roleID.trim();
                }
            };
            ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution repositoryRelationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)repositoryRelationTypeID, (IRepositoryRelationContributionRoleID)repositoryRelationContributionRoleID, (IRepositoryPropertySetSample)repositoryObjectReference.getObjectID());
            contentReferences.add(repositoryRelationsReference);
        }
        if (widgetSpec.getWidgetTypeID() != null) {
            widgetReference = new WidgetReference(contentReferences, widgetSpec.getWidgetTypeID(), widgetSpec.getWidgetParameters());
        } else if (namePropertyTypeID != null) {
            WidgetParameters widgetParameters = RepositoryEditorLayoutFactory.getPropertyWidgetParameters(namePropertyTypeID, repositoryObjectType);
            IWidgetTypeID widgetTypeID = RepositoryEditorLayoutFactory.getWidgetTypeID(namePropertyTypeID, repositoryObjectType);
            widgetReference = new WidgetReference(contentReferences, widgetTypeID, widgetParameters);
        }
        return widgetReference;
    }

    private static IWidgetTypeID getWidgetTypeID(IRepositoryPropertyTypeID repositoryPropertyTypeID, IRepositoryObjectType repositoryObjectType) {
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getAttributeSetType(repositoryPropertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(repositoryPropertyTypeID);
        IRepositoryDataType dataType = repositoryPropertyType.getDataType();
        WidgetTypeID widgetTypeID = WIDGET_TYPE_MAP.get(dataType.getClass());
        return widgetTypeID;
    }

    private static ColumnWidgetParameters getColumnWidgetParameters(IRepositoryAttributeSetType attributeSetType, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendAttributeSetType frontendAttributeSetType = frontendTypeManager.getFrontendAttributeSetType(attributeSetType);
        String label = frontendAttributeSetType.getLabel().getText();
        if (label == null) {
            label = attributeSetType.getRepositoryAttributeSetTypeID().toCanonicalString();
        }
        return new ColumnWidgetParameters(label, "", true, true, true, true, 0, 1);
    }

    private static TableWidgetParameters getTableWidgetParameters(IRepositoryAttributeSetType attributeSetType, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendAttributeSetType frontendAttributeSetType = frontendTypeManager.getFrontendAttributeSetType(attributeSetType);
        String label = frontendAttributeSetType.getLabel().getText();
        if (label == null) {
            label = attributeSetType.getRepositoryAttributeSetTypeID().toCanonicalString();
        }
        return new TableWidgetParameters(label, "", true, 1);
    }

    private static WidgetParameters getPageWidgetParameters(IRepositoryAttributeSetType attributeSetType, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendAttributeSetType frontendAttributeSetType = frontendTypeManager.getFrontendAttributeSetType(attributeSetType);
        String label = frontendAttributeSetType.getLabel().getText();
        if (label == null) {
            label = attributeSetType.getRepositoryAttributeSetTypeID().toCanonicalString();
        }
        return new WidgetParameters(label, "", true);
    }

    private static WidgetParameters getRelationWidgetParameters(ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType, IRepositoryObjectType repositoryObjectType, IRepositoryObjectReference repositoryObjectReference) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        ICollection_ relationContributionTypes = repositoryRelationContributionType.getRelatedRelationType().getAllRelationContributionTypes();
        ICrossLinkRepositoryRelationContributionType secondRelationContributionType = repositoryRelationContributionType;
        for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
            if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)relationContributionType.getRelatedObjectType().getRepositoryObjectTypeID(), (Object)repositoryObjectReference.getObjectTypeID())) continue;
            secondRelationContributionType = relationContributionType;
        }
        IRepositoryObjectType objectType = secondRelationContributionType.getRelatedObjectType();
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(objectType);
        String label = frontendObjectType.getLabel().getText();
        if (label == null) {
            label = repositoryRelationContributionType.getRelatedRelationType().getRepositoryRelationTypeID().toCanonicalString();
        }
        ICrossLinkRepositoryRelationType relationType = secondRelationContributionType.getRelatedRelationType();
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        IGenericModificationRelationType genericModificationRelationType = genericModificationTypeManager.getGenericModificationRelationType(relationType);
        boolean relationTypeModifiable = genericModificationRelationType.isCreatableAndDeletableGenerically();
        return new WidgetParameters(label, "", relationTypeModifiable);
    }

    private static WidgetParameters getPropertyWidgetParameters(IRepositoryPropertyTypeID propertyTypeID, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendLabel label = frontendPropertyType.getLabel();
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        IGenericModificationAttributeSetType genericModificationAttributeSetType = genericModificationTypeManager.getGenericModificationAttributeSetType(repositoryAttributeSetType);
        boolean modifiable = genericModificationAttributeSetType.arePropertiesModifiableGenerically();
        return new WidgetParameters(label.getText(), "", modifiable, 0, 1);
    }

    public static HashMap<Object, WidgetTypeID> fillDefaultWidgetMap() {
        HashMap<Object, WidgetTypeID> map = new HashMap<Object, WidgetTypeID>();
        map.put(RDTBoolean.class, WidgetTypeID.BOOLEAN);
        map.put(RDTDuration64Bitmsec.class, WidgetTypeID.DURATION);
        map.put(RDTFreeString.class, WidgetTypeID.FREESTRING);
        map.put(RDTFreeText.class, WidgetTypeID.FREETEXT);
        map.put(RDTDateUTC64Bitmsec.class, WidgetTypeID.DATE);
        map.put(RDTDisplayName.class, WidgetTypeID.FREESTRING);
        map.put(RDTInteger32Bit.class, WidgetTypeID.FREESTRING);
        map.put(RDTInteger64Bit.class, WidgetTypeID.FREESTRING);
        map.put(RDTFloat64BitIEEE754.class, WidgetTypeID.FREESTRING);
        map.put(RDTLocale.class, WidgetTypeID.LANGUAGE);
        map.put(RDTUID.class, WidgetTypeID.FREESTRING);
        map.put(RDTURL.class, WidgetTypeID.URL);
        map.put(RDTFile.class, WidgetTypeID.FILE);
        map.put(RDTMultipleChoice.class, WidgetTypeID.MULTIPLECHOICE);
        map.put(RDTSingleChoice.class, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_0, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_1, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_n, WidgetTypeID.MULTIPLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C1_1, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C1_n, WidgetTypeID.MULTIPLECHOICE);
        return map;
    }
}

