/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconObject;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;

public class IconObjectWithStatusDecorator
implements Icon {
    private static final ILogger LOGGER = Logger.getLogger(IconObjectWithStatusDecorator.class);
    private final String statusID;
    private final IStreamResource statusDecoratorIcon;

    public IconObjectWithStatusDecorator(String statusID, IStreamResource statusDecoratorIcon) {
        this.statusID = statusID;
        this.statusDecoratorIcon = statusDecoratorIcon;
    }

    @Override
    public IStreamResource getIcon(LabelCreationContext context) {
        String objectTypeID = context.getFrontendObjectType().getRepositoryObjectType().getRepositoryObjectTypeID().toCanonicalString();
        String categoryID = context.getObjectTypeCategoryID() != null ? context.getObjectTypeCategoryID().toCanonicalString() : "[default-category]";
        String objectAndCategoryID = String.valueOf(objectTypeID) + ":" + categoryID;
        return new StreamResourceForDecoratedObjectIcon(IconObject.getIcon_(context), this.statusDecoratorIcon, objectAndCategoryID, this.statusID);
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        return null;
    }

    private static InputStream createInputStreamForDecoratedIcon(IStreamResource baseIconResource, IStreamResource decoratorIconResource) {
        ByteArrayInputStream decoratedIconStream = null;
        try {
            IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
            Image baseIconImage = renderer.loadImage(baseIconResource);
            Image statusDecoratorImage = renderer.loadImage(decoratorIconResource);
            Image decoratedIconImage = renderer.createDecoratedImage(baseIconImage, statusDecoratorImage);
            byte[] decoratedIconBytes = ImageCoDec.encodeIntoByteArray((Image)decoratedIconImage, (ImageFileType)ImageCoDec.PNG);
            decoratedIconStream = new ByteArrayInputStream(decoratedIconBytes);
            baseIconImage.dispose();
            statusDecoratorImage.dispose();
            decoratedIconImage.dispose();
        }
        catch (EXUnspecifiedImageLoadingError eUILE) {
            LOGGER.warn((Throwable)eUILE);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            LOGGER.warn((Throwable)jeriE);
        }
        catch (EXImageDataTypeNotSupported e) {
            LOGGER.warn((Throwable)e);
        }
        catch (EXUnsupportedColorDepth e) {
            LOGGER.warn((Throwable)e);
        }
        catch (EXNoMoreHandles e) {
            LOGGER.warn((Throwable)e);
        }
        catch (EXImageTooBig e) {
            LOGGER.warn((Throwable)e);
        }
        catch (EXCorruptImageFileContent e) {
            LOGGER.warn((Throwable)e);
        }
        if (decoratedIconStream != null) {
            return decoratedIconStream;
        }
        try {
            return Icons16x16.UNKNOWN.toInputStream();
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            LOGGER.warn((Throwable)jeriE);
            return null;
        }
    }

    private static class StreamResourceForDecoratedObjectIcon
    implements IStreamResource {
        private final String categoryID;
        private final String statusID;
        private final IStreamResource decoratorIconResource;
        private final IStreamResource baseIconResource;

        public StreamResourceForDecoratedObjectIcon(IStreamResource baseIconResource, IStreamResource decoratorIconResource, String categoryID, String statusID) {
            this.baseIconResource = baseIconResource;
            this.decoratorIconResource = decoratorIconResource;
            this.categoryID = categoryID;
            this.statusID = statusID;
        }

        public InputStream toInputStream() throws JvmExternalResourceInteractionException {
            return IconObjectWithStatusDecorator.createInputStreamForDecoratedIcon(this.baseIconResource, this.decoratorIconResource);
        }

        public String getName() {
            return "Status decorated object icon";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.categoryID == null ? 0 : this.categoryID.hashCode());
            result = 31 * result + (this.statusID == null ? 0 : this.statusID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StreamResourceForDecoratedObjectIcon other = (StreamResourceForDecoratedObjectIcon)obj;
            if (this.categoryID == null ? other.categoryID != null : !this.categoryID.equals(other.categoryID)) {
                return false;
            }
            return !(this.statusID == null ? other.statusID != null : !this.statusID.equals(other.statusID));
        }
    }
}

