/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.AbstractFrontendDataValidationExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.IStreamResourceWithMetaInformation;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.implementation.filearchive.FileResourceForFileInFileArchive;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Locale;

public class FDTFile
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTFile.class, "file.gif");
    private final RDTFile repositoryDataType;
    private final ArrayList<IRepositoryPropertySample> resources = new ArrayList();

    public static FDTFile getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTFile frontendDataType = (FDTFile)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTFile.getInstance());
        return frontendDataType;
    }

    public FDTFile(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
        this.repositoryDataType = RDTFile.getInstance();
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTFile", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        String valueAsString = null;
        FileResourceForFileInFileArchive valueAsFileResource = this.getFileResourceForValue(value);
        if (valueAsFileResource instanceof IStreamResource) {
            IStreamResource valueAsStreamResource = (IStreamResource)valueAsFileResource;
            valueAsString = String.valueOf(valueAsStreamResource.getName()) + "\n";
            if (valueAsStreamResource instanceof IStreamResourceWithMetaInformation) {
                IStreamResourceWithMetaInformation valueAsSRWMI = (IStreamResourceWithMetaInformation)valueAsStreamResource;
                valueAsString = String.valueOf(valueAsString) + "(" + valueAsSRWMI.getCreator() + " / " + valueAsSRWMI.getCreationDate(userLocale) + ")";
            }
        }
        FrontendLabel label = valueAsString != null ? new FrontendLabel(valueAsString, null) : new FrontendLabel(Messages.getString("FDTFile.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        return label;
    }

    public String valueToCanonicalForm(IRepositoryData repositoryData) {
        IRepositoryFileID url = this.repositoryDataType.dataToFileID(repositoryData);
        String externalForm = url == null ? null : url.toCanonicalString();
        return externalForm;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.getFileResourceForValue(value);
    }

    private FileResourceForFileInFileArchive getFileResourceForValue(IRepositoryData value) {
        if (RDTFile.getInstance().dataToFileID(value) == null) {
            return null;
        }
        return new FileResourceForFileInFileArchive(value, this.getFrontendTypeManager().getRepositoryTypeManager());
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) throws JvmExternalResourceInteractionException {
        IRepositoryData data = null;
        boolean hasResourcesAllocated = false;
        if (editorValue == null) {
            data = RDTFile.getInstance().createData(null);
        } else if (editorValue instanceof FileResourceForFileInFileArchive) {
            data = RDTFile.getInstance().createData(((FileResourceForFileInFileArchive)editorValue).getFileID());
        } else {
            data = this.repositoryDataType.loadFileIntoTemporaryStorage((IStreamResource)editorValue, this.getFrontendTypeManager().getRepositoryTypeManager().getRepositoryInterface().getFileArchive());
            hasResourcesAllocated = true;
        }
        RepositoryPropertySample repositoryPropertySample = new RepositoryPropertySample(data);
        if (hasResourcesAllocated) {
            this.resources.add((IRepositoryPropertySample)repositoryPropertySample);
        }
        return repositoryPropertySample;
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
        IRepositoryData data = repositoryPropertySample.getValue();
        if (this.repositoryDataType.getClass().isInstance(data.getDataType())) {
            this.repositoryDataType.removeFileFromTemporaryStorage(repositoryPropertySample.getValue(), this.getFrontendTypeManager().getRepositoryTypeManager().getRepositoryInterface().getFileArchive());
            this.removeResource(repositoryPropertySample);
        }
    }

    private void removeResource(IRepositoryPropertySample repositoryPropertySample) {
        IHasher_ hasher = IRepositoryPropertySample.REPRESENTS_EQUAL_PROPERTYS_HASHER;
        ListIterator<IRepositoryPropertySample> i = this.resources.listIterator();
        while (i.hasNext()) {
            IRepositoryPropertySample propertySampleFromList = i.next();
            if (!hasher.isEqual((Object)repositoryPropertySample, (Object)propertySampleFromList)) continue;
            i.remove();
            break;
        }
    }

    @Override
    public boolean hasResourcesAllocated() {
        return this.resources.size() != 0;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    public static class FETFileFilenamePostifxInvalid
    extends AbstractFrontendDataValidationExceptionType<RDTFile.EXFilenamePostifxInvalid> {
        private FETFileFilenamePostifxInvalid(IFrontendTypeManager frontendTypeManager) {
            super(frontendTypeManager);
        }

        @Override
        protected Class<RDTFile.EXFilenamePostifxInvalid> getConcreteRepositoryExceptionType() {
            return RDTFile.EXFilenamePostifxInvalid.class;
        }

        @Override
        protected String getExceptionMessage(PresentationContext presentationContext, RDTFile.EXFilenamePostifxInvalid exception) {
            String message = String.valueOf(Messages.getString("EXFileFilenamePostifxInvalid.FileBeforeInvalidFilename", presentationContext.getLocale())) + exception.getInvalidFileName() + Messages.getString("EXFileFilenamePostifxInvalid.FileBeforeAllowedPostfixes", presentationContext.getLocale()) + FETFileFilenamePostifxInvalid.stringCollectionToString((ICollection_<String>)exception.getAllowedNamePostfixes(), presentationContext) + Messages.getString("EXFileFilenamePostifxInvalid.FileEnd", presentationContext.getLocale());
            return message;
        }

        private static String stringCollectionToString(ICollection_<String> strings, PresentationContext presentationContext) {
            String previousString;
            StringBuffer stringBuffer = new StringBuffer();
            IIterator_ i = strings.iterator();
            if (i.hasNext()) {
                previousString = (String)i.next();
                stringBuffer.append('\"');
                stringBuffer.append(previousString);
                stringBuffer.append('\"');
            } else {
                previousString = null;
            }
            String nextString = i.hasNext() ? (String)i.next() : null;
            while (i.hasNext()) {
                String currentString = nextString;
                nextString = (String)i.next();
                if (previousString != null) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\"');
                stringBuffer.append(currentString);
                stringBuffer.append('\"');
            }
            if (nextString != null) {
                stringBuffer.append(Messages.getString("EXFileFilenamePostifxInvalid.FileAnd", presentationContext.getLocale()));
                stringBuffer.append('\"');
                stringBuffer.append(nextString);
                stringBuffer.append('\"');
            }
            return stringBuffer.toString();
        }

        public static class FrontendExceptionTypeRegistration
        implements IFrontendExceptionTypeRegistration {
            @Override
            public IFrontendExceptionType createFrontendExceptionType(IFrontendTypeManager frontendTypeManager) {
                return new FETFileFilenamePostifxInvalid(frontendTypeManager);
            }
        }
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTFile(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        private static final int SHOW_FILENAME_ONLY = 1;
        private static final int SHOW_FILECONTENT_AS_IMAGE = 2;
        public static final Parameters PARAMETERS__SHOW_FILENAME_ONLY = new Parameters(1);
        public static final Parameters PARAMETERS__SHOW_FILECONTENT_AS_IMAGE = new Parameters(2);
        private final int mode;

        public Parameters(int mode) {
            this.mode = mode;
        }

        public boolean isShowFilenameOnly() {
            return this.mode == 1;
        }

        public boolean isShowFileContentAsImage() {
            return this.mode == 2;
        }
    }
}

