/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOStakeholder_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOSourceFileInfo_V0;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.cockpit.ppm1.ppm1migrator.PPM1MigratorCore;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOPMProject;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOTask;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOWorkItem;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class PPM1Migrator_ForProjectFiles {
    private static final ILogger logger = Logger.getLogger(PPM1Migrator_ForProjectFiles.class);
    public static final String PROJECT_EOLIST_TAG_MODULEDATA = "module data";
    public static final String PROJECT_EOLIST_TAG_LINKS = "links";
    private static final String PPM1_DATA_TAG = "Module.MSProjectModule";
    private static final long MIN_TO_MS_CONVERSION = 60000L;
    private static final String STAKEHOLDERS_DELIMITER = ";";

    public static void migrateData(HistoricProjectFileView_0_ historicViewOnProjectFile) throws MigrationFailedException {
        try {
            EOList permissions;
            EOProject_V0 projectMetaData = historicViewOnProjectFile.getProjectMetaData();
            EOList moduleDataListList = historicViewOnProjectFile.getDataList(PROJECT_EOLIST_TAG_MODULEDATA);
            if (moduleDataListList != null) {
                int ppm1DataListIndex = -1;
                for (EOList moduleDataList : moduleDataListList) {
                    EOModuleData_V0 newTask;
                    String pmProjectUid;
                    String moduleDataListRole = moduleDataList.getRole();
                    if (!moduleDataListRole.equals(PPM1_DATA_TAG)) continue;
                    ppm1DataListIndex = moduleDataListList.indexOf((Object)moduleDataList);
                    EOList ppm1Data = moduleDataList;
                    HashMap<String, EOList> map_role_ppm1DataList = new HashMap<String, EOList>();
                    for (EOList ppm1ItemList : ppm1Data) {
                        map_role_ppm1DataList.put(ppm1ItemList.getRole(), ppm1ItemList);
                    }
                    String projectUID = projectMetaData.getProjectUID();
                    String defaultCreatorModifier = "";
                    long defaultCreationModificationDate = System.currentTimeMillis();
                    HashSet<EOModuleData_V0> newSourcefileInfos = new HashSet<EOModuleData_V0>();
                    HashSet<EOModuleData_V0> newProjectPlans = new HashSet<EOModuleData_V0>();
                    HashSet<EOModuleData_V0> newTasks = new HashSet<EOModuleData_V0>();
                    HashSet<EOModuleData_V0> newWorkItems = new HashSet<EOModuleData_V0>();
                    HashSet newWICategories = new HashSet();
                    ArrayList<EOLink_V0> newLinks = new ArrayList<EOLink_V0>();
                    HashSet newPermissions = new HashSet();
                    HashMap<String, EOModuleData_V0> sourcefileMap = new HashMap<String, EOModuleData_V0>();
                    HashMap<String, EOModuleData_V0> projectPlanMap = new HashMap<String, EOModuleData_V0>();
                    HashMap<String, EOModuleData_V0> taskMap = new HashMap<String, EOModuleData_V0>();
                    HashMap<String, EOModuleData_V0> workItemMap = new HashMap<String, EOModuleData_V0>();
                    HashMap categoryNameMap = new HashMap();
                    Collection oldSourceFileInfos = (Collection)map_role_ppm1DataList.get("PMM_SOURCEFILEINFOS");
                    for (EOSourceFileInfo_V0 oldSourceFileInfo : oldSourceFileInfos) {
                        EOModuleData_V0 newSourceFile = PPM1MigratorCore.migrateSourceFileInfoRecord(oldSourceFileInfo, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                        newSourcefileInfos.add(newSourceFile);
                        sourcefileMap.put(oldSourceFileInfo.getUID(), newSourceFile);
                    }
                    for (EOPMProject oldProjectPlan : (EOList)map_role_ppm1DataList.get("PMM_PROJECTPLANS")) {
                        EOModuleData_V0 newProjectPlan = PPM1MigratorCore.migrateProjectPlanRecord(oldProjectPlan, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                        newProjectPlans.add(newProjectPlan);
                        projectPlanMap.put(oldProjectPlan.getUID(), newProjectPlan);
                        String oldSourcefileUID = oldProjectPlan.getSourceUID();
                        if (oldSourcefileUID == null) continue;
                        EOModuleData_V0 newTargetSourcefile = (EOModuleData_V0)sourcefileMap.get(oldSourcefileUID);
                        if (newTargetSourcefile != null) {
                            newLinks.add(new EOLink_V0(projectUID, newTargetSourcefile.getUid(), newProjectPlan.getUid(), "com.arcway.cockpit.projectplanningmodule2", "ProjectSourceFile"));
                            continue;
                        }
                        logger.warn("Inconsistent project planning data: The project plan with the name \"" + (oldProjectPlan.getName() == null ? "" : oldProjectPlan.getName()) + "\" referred to a non existing source file");
                    }
                    Collection oldTasks = (Collection)map_role_ppm1DataList.get("PMM_TASKS");
                    for (EOTask oldTask : oldTasks) {
                        pmProjectUid = oldTask.getPMProjectUid();
                        if (pmProjectUid != null && projectPlanMap.get(pmProjectUid) != null) {
                            newTask = PPM1MigratorCore.migrateTaskRecord(oldTask, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                            newTasks.add(newTask);
                            taskMap.put(oldTask.getUID(), newTask);
                            continue;
                        }
                        logger.warn("Inconsistent project planning data: The task with the name \"" + (oldTask.getName() == null ? "" : oldTask.getName()) + "\" referred to a non existing project plan. - did not import this task ");
                    }
                    for (EOTask oldTask : oldTasks) {
                        pmProjectUid = oldTask.getPMProjectUid();
                        if (pmProjectUid == null || projectPlanMap.get(pmProjectUid) == null) continue;
                        newTask = (EOModuleData_V0)taskMap.get(oldTask.getUID());
                        String oldParentTaskUID = oldTask.getParentUid();
                        if (oldParentTaskUID == null || taskMap.get(oldParentTaskUID) == null) {
                            newLinks.add(new EOLink_V0(projectUID, ((EOModuleData_V0)projectPlanMap.get(oldTask.getPMProjectUid())).getUid(), newTask.getUid(), "com.arcway.cockpit.projectplanningmodule2", "TaskProjectPlan"));
                            if (oldParentTaskUID == null) continue;
                            logger.warn("Inconsistent project planning data: The task with the name \"" + (oldTask.getName() == null ? "" : oldTask.getName()) + "\" referred to a non existing parent task." + " - converted task to a \"root\" task of the same project plan");
                            continue;
                        }
                        newLinks.add(new EOLink_V0(projectUID, ((EOModuleData_V0)taskMap.get(oldParentTaskUID)).getUid(), newTask.getUid(), "com.arcway.cockpit.projectplanningmodule2", "TaskTask"));
                    }
                    Map stakeholderMap = PPM1Migrator_ForProjectFiles.extractStakeholderNames((Collection)historicViewOnProjectFile.getDataList("stakeholders"));
                    Collection oldWorkItems = (Collection)map_role_ppm1DataList.get("PMM_WORKITEMS");
                    for (EOWorkItem oldWorkItem : oldWorkItems) {
                        String linkedTaskUID;
                        EOModuleData_V0 newWorkItem = PPM1MigratorCore.migrateWorkItemRecord(oldWorkItem, projectUID, defaultCreatorModifier, defaultCreationModificationDate, stakeholderMap);
                        newWorkItems.add(newWorkItem);
                        workItemMap.put(oldWorkItem.getUID(), newWorkItem);
                        EOModuleData_V0 workItemCategory = PPM1MigratorCore.updateCategoryListAndReturnCategoryEO(newWICategories, new ArrayList(1), categoryNameMap, oldWorkItem, projectUID, defaultCreatorModifier, defaultCreationModificationDate);
                        String targetUEUid = oldWorkItem.getUniqueElementUID();
                        if (targetUEUid != null) {
                            newLinks.add(new EOLink_V0(projectUID, targetUEUid, newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemUniqueElement"));
                        }
                        if ((linkedTaskUID = oldWorkItem.getTaskUID()) != null) {
                            EOModuleData_V0 newTargetTask = (EOModuleData_V0)taskMap.get(linkedTaskUID);
                            if (newTargetTask != null) {
                                newLinks.add(new EOLink_V0(projectUID, newTargetTask.getUid(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemTask"));
                            } else {
                                logger.warn("Inconsistent project planning data: The work item with the name \"" + (oldWorkItem.getName() == null ? "" : oldWorkItem.getName()) + "\" refferred to a non existing task. ");
                            }
                        }
                        if (workItemCategory != null) {
                            newLinks.add(new EOLink_V0(projectUID, workItemCategory.getUid(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemCategory"));
                        }
                        StringTokenizer names = new StringTokenizer(oldWorkItem.getResourceNames(), STAKEHOLDERS_DELIMITER);
                        EOStakeholder_V0 personInCharge = null;
                        while (names.hasMoreTokens() && personInCharge == null) {
                            String name = names.nextToken().trim();
                            personInCharge = (EOStakeholder_V0)stakeholderMap.get(name);
                        }
                        if (personInCharge == null) continue;
                        newLinks.add(new EOLink_V0(projectUID, personInCharge.getUID(), newWorkItem.getUid(), "com.arcway.cockpit.projectplanningmodule2", "WorkItemStakeholder"));
                    }
                    EOList ppm2SourceFilesList = new EOList("ppm2.sourceFile");
                    ppm2SourceFilesList.addAll(newSourcefileInfos);
                    moduleDataListList.addChild((EncodableObjectBase)ppm2SourceFilesList);
                    EOList ppm2ProjectPlansList = new EOList("ppm2.projectplan");
                    ppm2ProjectPlansList.addAll(newProjectPlans);
                    moduleDataListList.addChild((EncodableObjectBase)ppm2ProjectPlansList);
                    EOList ppm2TasksList = new EOList("ppm2.task");
                    ppm2TasksList.addAll(newTasks);
                    moduleDataListList.addChild((EncodableObjectBase)ppm2TasksList);
                    EOList ppm2WorkItemsList = new EOList("ppm2.workitem");
                    ppm2WorkItemsList.addAll(newWorkItems);
                    moduleDataListList.addChild((EncodableObjectBase)ppm2WorkItemsList);
                    EOList ppm2WICategoriesList = new EOList("ppm2.workitemcategory");
                    ppm2WICategoriesList.addAll(newWICategories);
                    moduleDataListList.addChild((EncodableObjectBase)ppm2WICategoriesList);
                    EOList linksList = historicViewOnProjectFile.getDataList(PROJECT_EOLIST_TAG_LINKS);
                    linksList.addAll(newLinks);
                }
                if (ppm1DataListIndex != -1) {
                    moduleDataListList.remove(ppm1DataListIndex);
                }
            }
            if ((permissions = historicViewOnProjectFile.getDataList("permissions")) != null) {
                ArrayList<EOPermission> permissionsToRemove = new ArrayList<EOPermission>(permissions.size());
                ArrayList<EOPermission> permissionsToAdd = new ArrayList<EOPermission>(permissions.size());
                for (EOPermission permission : permissions) {
                    boolean isPPM1Permission = false;
                    String operation = permission.getOperation();
                    String operandType = permission.getOperandType();
                    String operandUID = permission.getOperandUID();
                    String newOperation = null;
                    String newOperandType = null;
                    String newOperandUID = null;
                    if (operandType.equals("treeElement")) {
                        isPPM1Permission = true;
                        newOperandType = "ppm2.prmOperand.projectPlan";
                        if (operation.equals("editTask")) {
                            newOperation = "ppm2.editProjectPlanOrTask";
                        } else if (operation.equals("editWorkItem")) {
                            newOperation = "ppm2.editContainedWorkItems";
                        }
                        newOperandUID = operandUID;
                    } else if (operandType.equals("project")) {
                        if (operation.equals("editPMProjects")) {
                            isPPM1Permission = true;
                            newOperandType = "ppm2.prmOperand.root";
                            newOperation = "ppm2.createProjectPlan";
                            newOperandUID = "PPM2_Permission_Root";
                        } else if (operation.equals("editGlobalWorkItems")) {
                            isPPM1Permission = true;
                            newOperandType = "ppm2.prmOperand.root";
                            newOperation = "ppm2.editUnassignedWorkItems";
                            newOperandUID = "PPM2_Permission_Root";
                        }
                    }
                    if (!isPPM1Permission) continue;
                    permissionsToRemove.add(permission);
                    EOPermission newPermission = new EOPermission();
                    newPermission.setPermissionUID(UUIDGenerator.getUniqueID());
                    newPermission.setSubSetType(permission.getSubSetType());
                    newPermission.setSubSetUID(permission.getSubSetUID());
                    newPermission.setOperation(newOperation);
                    newPermission.setOperandType(newOperandType);
                    newPermission.setOperandUID(newOperandUID);
                    newPermission.setOwnerID(permission.getOwnerID());
                    newPermission.setOwnerType(permission.getOwnerType());
                    permissionsToAdd.add(newPermission);
                }
                permissions.removeAll(permissionsToRemove);
                permissions.addAll(permissionsToAdd);
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Could not access project file.", (Throwable)pfaE);
        }
    }

    private static Map extractStakeholderNames(Collection stakeholders) {
        HashMap<String, EOStakeholder_V0> map = new HashMap<String, EOStakeholder_V0>(stakeholders.size());
        for (EOStakeholder_V0 stakeholder : stakeholders) {
            map.put(stakeholder.getStakeholderName(), stakeholder);
        }
        return map;
    }
}

