/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.frame.client.global.gui.validators.RenamePlanValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.ISectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.exceptions.EXNoPlanFoundException;
import com.arcway.cockpit.planimporter.wizard.ImportedPlansContentProvider;
import com.arcway.cockpit.planimporter.wizard.ImportedPlansLabelProvider;
import com.arcway.cockpit.planimporter.wizard.PlansImportWizard;
import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PlanImportAttributePage
extends WizardPage {
    private Object currentlySelectedTreeItem;
    private String errorMessage;
    private final ImportedPlansListener listener;
    private final Map<String, ISection> mapTargetSectionsName;
    private Collection<Object> notImportedPlans;
    private final PlansImportWizard parent;
    private Group planDataGroup;
    private final IPlansConverter plansConverter;
    private Group plansGroup;
    private Plans convertedPlans;
    private final IFrameProjectAgent projectAgent;
    private final ISectionManager sectionManager;
    private ISection selectedSection;
    private String selectedSectionName;
    private Group targetGroup;
    private Combo targetName;
    private final Collection<? extends ISection> targetSections;
    private UsableCheckboxTreeViewer treeViewer;
    private Text txtDescription;
    private Text txtPlanName;
    private Composite base;

    public PlanImportAttributePage(String pageName, IPlansConverter plansConverter, IFrameProjectAgent projectAgent, ISection parentSection, PlansImportWizard parent) {
        super(pageName);
        assert (projectAgent != null);
        assert (parent != null);
        this.plansConverter = plansConverter;
        this.projectAgent = projectAgent;
        this.sectionManager = this.projectAgent.getSectionManager();
        this.selectedSection = parentSection;
        this.targetSections = ((SectionManager)this.sectionManager).getSections();
        this.mapTargetSectionsName = new HashMap<String, ISection>();
        for (ISection iSection : this.targetSections) {
            String name = iSection.getSectionName();
            if (!iSection.isRootSection()) {
                ISection parentTargetSection = ((SectionManager)this.sectionManager).getSection(iSection.getParentUID());
                name = this.getTargetName(parentTargetSection, iSection);
            }
            if (iSection.getUID().equals(this.selectedSection.getUID())) {
                this.selectedSectionName = name;
            }
            this.mapTargetSectionsName.put(name, iSection);
        }
        this.parent = parent;
        this.listener = new ImportedPlansListener();
        this.notImportedPlans = new ArrayList<Object>();
        this.errorMessage = null;
    }

    public void createControl(Composite parentComp) {
        this.base = new Composite(parentComp, 0);
        this.base.setLayoutData((Object)new GridData(1808));
        this.base.setLayout((Layout)new GridLayout(1, true));
        Composite upperBase = new Composite(this.base, 0);
        upperBase.setLayoutData((Object)new GridData(1808));
        upperBase.setLayout((Layout)new GridLayout(2, true));
        Composite leftBase = new Composite(upperBase, 0);
        leftBase.setLayoutData((Object)new GridData(1808));
        leftBase.setLayout((Layout)new GridLayout(1, false));
        this.createImportedPlansGroup(leftBase);
        Composite rightBase = new Composite(upperBase, 0);
        rightBase.setLayoutData((Object)new GridData(1808));
        rightBase.setLayout((Layout)new GridLayout(1, false));
        this.createPlansDataGroup(rightBase);
        Composite lowerBase = new Composite(this.base, 0);
        lowerBase.setLayoutData((Object)new GridData(768));
        lowerBase.setLayout((Layout)new GridLayout(1, true));
        this.createProjectTargetGroup(lowerBase);
        this.setControl((Control)this.base);
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = super.getNextPage();
        ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(this.treeViewer.getCheckedElements()));
        if (!checkedElements.isEmpty()) {
            this.parent.updateConstructionElements();
            return nextPage;
        }
        return null;
    }

    public ISection getSelectedSection() {
        return this.selectedSection;
    }

    public void init() {
        this.setTitle(this.plansConverter.getLocalizedName(Locale.getDefault()));
        this.setDescription(Messages.getString("PlanImportAttributes.description"));
        this.setPageComplete(false);
    }

    public void setConversionErrorMessage(String message, int type) {
        this.treeViewer.removeCheckStateListener((ICheckStateListener)this.listener);
        this.plansGroup.setEnabled(false);
        this.treeViewer.getTree().setEnabled(false);
        this.targetName.setEnabled(false);
        this.txtPlanName.setEnabled(false);
        this.txtDescription.setEnabled(false);
        this.errorMessage = message;
        this.setMessage(this.errorMessage, type);
        this.setPageComplete(false);
    }

    public void setPlansInput(Plans plans) {
        this.plansGroup.setEnabled(true);
        this.targetName.setEnabled(true);
        this.txtPlanName.setEnabled(false);
        this.txtDescription.setEnabled(false);
        this.treeViewer.getTree().setEnabled(true);
        this.treeViewer.getTree().deselectAll();
        this.convertedPlans = plans;
        this.updateAllCheckedPlans(this.convertedPlans, false);
        this.treeViewer.removeCheckStateListener((ICheckStateListener)this.listener);
        this.treeViewer.setInput((Object)this.convertedPlans);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this.listener);
        this.treeViewer.expandAll();
        ArrayList<Object> itemList = new ArrayList<Object>(Arrays.asList(this.treeViewer.getCheckedElements()));
        if (!itemList.isEmpty()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private Collection<Object> findAllInstancesOfTheSameLevel(Plans plans, Object object) {
        Collection<Object> plansCollection = new ArrayList();
        plansCollection = plans.getAllPlansAndPlanDirectories();
        if (plansCollection.contains(object)) {
            return plansCollection;
        }
        for (PlanDirectory directory : plans.getPlanDirectories()) {
            plansCollection = this.findAllInstancesOfTheSameLevel((Plans)directory, object);
            if (plansCollection.isEmpty()) continue;
            return plansCollection;
        }
        plansCollection = new ArrayList();
        return plansCollection;
    }

    private boolean checkAttributesOfPlans(String planNameToBeChecked, Plans plans) throws EXNoPlanFoundException {
        this.errorMessage = null;
        this.setErrorMessage(this.errorMessage);
        boolean succeeded = false;
        Collection<Object> plansCollection = this.findAllInstancesOfTheSameLevel(plans, this.currentlySelectedTreeItem);
        if (plansCollection.isEmpty()) {
            throw new EXNoPlanFoundException();
        }
        for (Object object : plansCollection) {
            boolean sameInstance = false;
            String planName = null;
            if (object instanceof Plan) {
                if (!(this.currentlySelectedTreeItem instanceof Plan)) continue;
                sameInstance = (Plan)this.currentlySelectedTreeItem == (Plan)object;
                planName = ((Plan)object).getName();
            }
            if (object instanceof PlanDirectory) {
                if (!(this.currentlySelectedTreeItem instanceof PlanDirectory)) continue;
                sameInstance = (PlanDirectory)this.currentlySelectedTreeItem == (PlanDirectory)object;
                planName = ((PlanDirectory)object).getName();
            }
            if (!sameInstance) {
                if (planName == null || !planName.equalsIgnoreCase(planNameToBeChecked.trim())) continue;
                this.errorMessage = String.valueOf(Messages.getString("PlanImportAttributes.nameNotValid")) + planName + ". ";
                this.notImportedPlans.add(this.currentlySelectedTreeItem);
                succeeded = false;
                return succeeded;
            }
            succeeded = true;
        }
        if (succeeded) {
            return succeeded;
        }
        Collection plansDirectories = plans.getPlanDirectories();
        for (PlanDirectory planDirectory : plansDirectories) {
            succeeded = this.checkAttributesOfPlans(planNameToBeChecked, (Plans)planDirectory);
            if (!succeeded) continue;
            return succeeded;
        }
        return succeeded;
    }

    private void checkAttributesValue(Widget widget) {
        if (widget.equals(this.txtDescription)) {
            Plan plan;
            this.txtDescription.removeModifyListener((ModifyListener)this.listener);
            String planDescriptionToBeChecked = this.txtDescription.getText().trim();
            if (this.currentlySelectedTreeItem instanceof Plan) {
                plan = (Plan)this.currentlySelectedTreeItem;
                plan.setDescription(planDescriptionToBeChecked);
            }
            if (this.currentlySelectedTreeItem instanceof PlanDirectory) {
                plan = (PlanDirectory)this.currentlySelectedTreeItem;
                plan.setDescription(planDescriptionToBeChecked);
            }
            this.txtDescription.addModifyListener((ModifyListener)this.listener);
        } else {
            this.setPageComplete(false);
            this.txtPlanName.removeModifyListener((ModifyListener)this.listener);
            String planNameToBeChecked = this.txtPlanName.getText().trim();
            String warningMessage = null;
            if (planNameToBeChecked == null || planNameToBeChecked.trim().equals("")) {
                warningMessage = Messages.getString("PlanImportAttributes.emptyPlanName");
            } else if (planNameToBeChecked.length() > 250) {
                warningMessage = String.valueOf(Messages.getString("PlanImportAttributes.tooLongName.0")) + 250 + Messages.getString("PlanImportAttributes.tooLongName.1");
            }
            if (warningMessage != null) {
                if (this.currentlySelectedTreeItem instanceof Plan) {
                    this.txtPlanName.setText(((Plan)this.currentlySelectedTreeItem).getName());
                    this.txtPlanName.setSelection(0, this.txtPlanName.getCharCount());
                    this.txtPlanName.showSelection();
                }
                if (this.currentlySelectedTreeItem instanceof PlanDirectory) {
                    this.txtPlanName.setText(((PlanDirectory)this.currentlySelectedTreeItem).getName());
                    this.txtPlanName.setSelection(0, this.txtPlanName.getCharCount());
                    this.txtPlanName.showSelection();
                }
                this.setMessage(warningMessage, 2);
                this.setPageComplete(this.errorMessage == null);
            } else {
                this.setMessage(this.getDescription());
                try {
                    boolean succeeded = this.checkAttributesOfPlans(planNameToBeChecked, this.convertedPlans);
                    if (succeeded) {
                        if (this.treeViewer.getChecked(this.currentlySelectedTreeItem)) {
                            Plan plan;
                            if (this.currentlySelectedTreeItem instanceof Plan) {
                                plan = (Plan)this.currentlySelectedTreeItem;
                                plan.setName(planNameToBeChecked);
                            }
                            if (this.currentlySelectedTreeItem instanceof PlanDirectory) {
                                plan = (PlanDirectory)this.currentlySelectedTreeItem;
                                plan.setName(planNameToBeChecked);
                            }
                        }
                        this.setErrorMessage(this.errorMessage);
                        this.checkNameValidity(Arrays.asList(this.treeViewer.getCheckedElements()));
                    } else {
                        this.setErrorMessage(this.errorMessage);
                        this.setPageComplete(this.errorMessage == null);
                    }
                }
                catch (EXNoPlanFoundException e) {
                    this.txtPlanName.setEnabled(false);
                    this.txtDescription.setEnabled(false);
                    if (!this.txtPlanName.getText().equals("")) {
                        this.txtPlanName.setText("");
                    }
                    if (!this.txtDescription.getText().equals("")) {
                        this.txtDescription.setText("");
                    }
                    this.errorMessage = e.getLocalizedMessage();
                    this.setErrorMessage(this.errorMessage);
                    this.setPageComplete(this.errorMessage == null);
                }
            }
            this.txtPlanName.addModifyListener((ModifyListener)this.listener);
        }
    }

    private void checkNameValidity(Collection<Object> checkedElements) {
        this.setPageComplete(false);
        this.updateAllCheckedPlans(this.convertedPlans, false);
        this.notImportedPlans = new ArrayList<Object>();
        Collection rootLevelPlans = this.convertedPlans.getAllPlansAndPlanDirectories();
        for (Object object : checkedElements) {
            if (object instanceof Plan) {
                RenamePlanValidator planNameValidator;
                String message;
                Plan plan = (Plan)object;
                plan.setChecked(true);
                if (rootLevelPlans.contains(object) && (message = (planNameValidator = new RenamePlanValidator(this.projectAgent, this.getSelectedSection().getUID())).isValid(plan.getName())) != null) {
                    this.notImportedPlans.add(plan);
                }
            }
            if (!(object instanceof PlanDirectory)) continue;
            PlanDirectory directory = (PlanDirectory)object;
            directory.setChecked(true);
            if (!rootLevelPlans.contains(object) || !this.sectionManager.containsChildSection(this.selectedSection, directory.getName())) continue;
            this.notImportedPlans.add(directory);
        }
        if (!this.notImportedPlans.isEmpty()) {
            String notImportedNames = String.valueOf(Messages.getString("PlanImportAttributes.nameNotValid")) + " ";
            Iterator<Object> i = this.notImportedPlans.iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (object instanceof Plan) {
                    notImportedNames = String.valueOf(notImportedNames) + ((Plan)object).getName();
                }
                if (object instanceof PlanDirectory) {
                    notImportedNames = String.valueOf(notImportedNames) + ((PlanDirectory)object).getName();
                }
                if (!i.hasNext()) continue;
                notImportedNames = String.valueOf(notImportedNames) + ", ";
            }
            this.errorMessage = String.valueOf(notImportedNames) + ". " + Messages.getString("PlanImportAttributes.nameNotValid2");
        } else {
            this.errorMessage = null;
        }
        this.setErrorMessage(this.errorMessage);
        this.setPageComplete(this.errorMessage == null);
    }

    private void createImportedPlansGroup(Composite composite) {
        this.plansGroup = new Group(composite, 0);
        this.plansGroup.setText(Messages.getString("PlanImportAttributes.plansToImport"));
        GridData plansGroupGridData = new GridData(1808);
        this.plansGroup.setLayoutData((Object)plansGroupGridData);
        this.plansGroup.setLayout((Layout)new GridLayout());
        this.createTreeViewer((Composite)this.plansGroup);
        this.plansGroup.setEnabled(false);
    }

    private void createPlansDataGroup(Composite composite) {
        this.planDataGroup = new Group(composite, 0);
        this.planDataGroup.setText(Messages.getString("PlanImportAttributes.planInfo"));
        GridData plansDataGroupGridData = new GridData(1808);
        this.planDataGroup.setLayoutData((Object)plansDataGroupGridData);
        this.planDataGroup.setLayout((Layout)new GridLayout(1, false));
        Label lblPlanName = new Label((Composite)this.planDataGroup, 0);
        lblPlanName.setLayoutData((Object)new GridData(768));
        lblPlanName.setText(Messages.getString("PlanImportAttributes.planName"));
        this.txtPlanName = new Text((Composite)this.planDataGroup, 2052);
        this.txtPlanName.setLayoutData((Object)new GridData(768));
        this.txtPlanName.setEnabled(false);
        this.txtPlanName.addModifyListener((ModifyListener)this.listener);
        Label lblDescription = new Label((Composite)this.planDataGroup, 0);
        lblDescription.setLayoutData((Object)new GridData(768));
        lblDescription.setText(Messages.getString("PlanImportAttributes.planDesc"));
        this.txtDescription = new Text((Composite)this.planDataGroup, 2114);
        this.txtDescription.setLayoutData((Object)new GridData(1808));
        this.txtDescription.setEnabled(false);
        this.txtDescription.addModifyListener((ModifyListener)this.listener);
    }

    private void createProjectTargetGroup(Composite composite) {
        this.targetGroup = new Group(composite, 0);
        this.targetGroup.setText(Messages.getString("PlanImportAttributes.target"));
        this.targetGroup.setLayoutData((Object)new GridData(1808));
        this.targetGroup.setLayout((Layout)new GridLayout(2, false));
        Label firstlblName = new Label((Composite)this.targetGroup, 0);
        firstlblName.setText(Messages.getString("PlanImportAttributes.targetDirectory"));
        this.targetName = new Combo((Composite)this.targetGroup, 4);
        this.targetName.setLayoutData((Object)new GridData(768));
        String[] targets = this.mapTargetSectionsName.keySet().toArray(new String[this.mapTargetSectionsName.keySet().size()]);
        List<String> sortTargetSectionNames = Arrays.asList(targets);
        Collections.sort(sortTargetSectionNames);
        for (String name : sortTargetSectionNames) {
            this.targetName.add(name);
        }
        this.targetName.setText(this.selectedSectionName);
        this.targetName.addSelectionListener((SelectionListener)this.listener);
        this.targetName.setEnabled(false);
    }

    private void createTable(Tree tree) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        tree.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        tree.addSelectionListener((SelectionListener)this.listener);
        tree.setEnabled(false);
    }

    private void createTreeViewer(Composite composite) {
        this.treeViewer = new UsableCheckboxTreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new ImportedPlansContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ImportedPlansLabelProvider());
        this.treeViewer.activateSelectionContextMenu();
        this.createTable(this.treeViewer.getTree());
    }

    private String getTargetName(ISection parentSec, ISection section) {
        ISection parentSection = parentSec;
        String sectionName = section.getSectionName();
        String newName = String.valueOf(parentSection.getSectionName()) + "/" + sectionName;
        while (!parentSection.isRootSection()) {
            String parentUID = parentSection.getParentUID();
            parentSection = ((SectionManager)this.sectionManager).getSection(parentUID);
            sectionName = newName;
            newName = String.valueOf(parentSection.getSectionName()) + "/" + sectionName;
        }
        return newName;
    }

    private void updateAllCheckedPlans(Plans plans, boolean checked) {
        for (Plan plan : plans.getPlans()) {
            plan.setChecked(checked);
        }
        for (PlanDirectory subDirectory : plans.getPlanDirectories()) {
            subDirectory.setChecked(checked);
            this.updateAllCheckedPlans((Plans)subDirectory, checked);
        }
    }

    private void updatePlansDataGroup(String name, String description, boolean updated) {
        this.txtPlanName.removeModifyListener((ModifyListener)this.listener);
        this.txtDescription.removeModifyListener((ModifyListener)this.listener);
        this.txtPlanName.setEnabled(updated);
        this.txtDescription.setEnabled(updated);
        this.txtPlanName.setText(name);
        if (description != null) {
            this.txtDescription.setText(description);
        } else {
            this.txtDescription.setText("");
        }
        this.txtPlanName.addModifyListener((ModifyListener)this.listener);
        this.txtDescription.addModifyListener((ModifyListener)this.listener);
    }

    public void dispose() {
        this.mapTargetSectionsName.clear();
        this.notImportedPlans.clear();
        this.targetSections.clear();
        this.base.dispose();
    }

    class ImportedPlansListener
    implements SelectionListener,
    ModifyListener,
    ICheckStateListener {
        ImportedPlansListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object checkedElement = event.getElement();
            if (checkedElement instanceof Plan) {
                ((Plan)checkedElement).setChecked(event.getChecked());
            } else if (checkedElement instanceof PlanDirectory) {
                ((PlanDirectory)checkedElement).setChecked(event.getChecked());
            }
            ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(PlanImportAttributePage.this.treeViewer.getCheckedElements()));
            if (!checkedElements.isEmpty()) {
                PlanImportAttributePage.this.treeViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
                PlanImportAttributePage.this.checkNameValidity(checkedElements);
            } else {
                PlanImportAttributePage.this.updateAllCheckedPlans(PlanImportAttributePage.this.convertedPlans, false);
                PlanImportAttributePage.this.setPageComplete(false);
            }
        }

        public void modifyText(ModifyEvent event) {
            if (event.widget instanceof Text) {
                PlanImportAttributePage.this.checkAttributesValue(event.widget);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.widget instanceof Combo) {
                Combo item = (Combo)event.getSource();
                String text = item.getText();
                if (PlanImportAttributePage.this.mapTargetSectionsName.containsKey(text)) {
                    ISection section = (ISection)PlanImportAttributePage.this.mapTargetSectionsName.get(text);
                    PlanImportAttributePage.this.selectedSection = section;
                    PlanImportAttributePage.this.selectedSectionName = section.getSectionName();
                }
                if (PlanImportAttributePage.this.treeViewer != null) {
                    ArrayList<Object> checkedElements = new ArrayList<Object>(Arrays.asList(PlanImportAttributePage.this.treeViewer.getCheckedElements()));
                    if (!checkedElements.isEmpty()) {
                        PlanImportAttributePage.this.checkNameValidity(checkedElements);
                    } else {
                        PlanImportAttributePage.this.setPageComplete(false);
                    }
                }
            }
            if (event.widget instanceof Tree) {
                int selectionCount;
                Plan plan;
                TreeItem treeItem = (TreeItem)event.item;
                PlanImportAttributePage.this.currentlySelectedTreeItem = treeItem.getData();
                if (PlanImportAttributePage.this.currentlySelectedTreeItem instanceof Plan) {
                    plan = (Plan)PlanImportAttributePage.this.currentlySelectedTreeItem;
                    PlanImportAttributePage.this.updatePlansDataGroup(plan.getName(), plan.getDescription(), plan.isChecked());
                    PlanImportAttributePage.this.checkAttributesValue(event.widget);
                }
                if (PlanImportAttributePage.this.currentlySelectedTreeItem instanceof PlanDirectory) {
                    plan = (PlanDirectory)PlanImportAttributePage.this.currentlySelectedTreeItem;
                    PlanImportAttributePage.this.updatePlansDataGroup(plan.getName(), plan.getDescription(), plan.isChecked());
                    PlanImportAttributePage.this.checkAttributesValue(event.widget);
                }
                if ((selectionCount = PlanImportAttributePage.this.treeViewer.getCheckedElements().length) == 0) {
                    PlanImportAttributePage.this.setPageComplete(false);
                }
            }
        }
    }
}

