/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.p2.ui;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.psc.eclipse.client.update.updateurl.PSCClientUpdateURLConnection;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ServerStatusChangedListener
implements IServerStatusChangedListener {
    private static final ILogger LOGGER = Logger.getLogger(ServerStatusChangedListener.class);
    private final RequestForwarder requestForwarder;

    public ServerStatusChangedListener(RequestForwarder requestForwarder) {
        this.requestForwarder = requestForwarder;
        ServerStatusChangedListener.removeAllCockpitServerRepositories();
    }

    public void addedServer(ServerConnection serverConnection) {
    }

    public void modifiedServer(ServerConnection serverConnection) {
        this.updateRepositories();
    }

    public void deletedServer(ServerConnection serverConnection) {
        this.updateRepositories();
    }

    public boolean serverAboutToBeDeleted(ServerConnection serverConnection) {
        this.updateRepositories();
        return true;
    }

    public void login(ServerConnection serverConnection) {
        this.updateRepositories();
    }

    public void logoff(ServerConnection serverConnection) {
        this.updateRepositories();
    }

    private void updateRepositories() {
        if (this.requestForwarder != null) {
            try {
                ProvisioningUI provisioningUI = ProvSDKUIActivator.getDefault().getProvisioningUI();
                ProvisioningSession provisioningSession = provisioningUI.getSession();
                RepositoryTracker repositoryTracker = provisioningUI.getRepositoryTracker();
                URI[] p2KnownRepositories = repositoryTracker.getKnownRepositories(provisioningSession);
                List serverConnections = this.requestForwarder.getServerConnections();
                HashMap<URI, ServerConnection> wantedRepositories = new HashMap<URI, ServerConnection>();
                for (ServerConnection sc : serverConnections) {
                    if (!sc.isConnected()) continue;
                    wantedRepositories.put(PSCClientUpdateURLConnection.createPSCClientUpdateURLForPSCServer((ServerConnection)sc).toURI(), sc);
                }
                ArrayList<URI> toBeRemoved = new ArrayList<URI>();
                URI[] uRIArray = p2KnownRepositories;
                int n = p2KnownRepositories.length;
                int n2 = 0;
                while (n2 < n) {
                    URI repoURI = uRIArray[n2];
                    if ("update".equalsIgnoreCase(repoURI.getScheme())) {
                        toBeRemoved.add(repoURI);
                    }
                    ++n2;
                }
                toBeRemoved.removeAll(wantedRepositories.keySet());
                ArrayList toBeAdded = new ArrayList();
                toBeAdded.addAll(wantedRepositories.keySet());
                toBeAdded.removeAll(Arrays.asList(p2KnownRepositories));
                repositoryTracker.removeRepositories(toBeRemoved.toArray(new URI[toBeRemoved.size()]), provisioningSession);
                for (URI repoURI : toBeAdded) {
                    if (!ServerStatusChangedListener.updateRepositoryAvailableOnCockpitServer(repoURI)) continue;
                    repositoryTracker.addRepository(repoURI, ((ServerConnection)wantedRepositories.get(repoURI)).getServerName(), provisioningSession);
                }
            }
            catch (Exception e) {
                LOGGER.info("Unable to adjust the p2 repository to include connected Cockpit Servers.", (Throwable)e);
            }
        }
    }

    private static boolean updateRepositoryAvailableOnCockpitServer(URI repoURI) {
        String[] testFileRelPathNames = new String[]{"artifacts.jar", "artifacts.xml", "content.jar", "content.xml", "cockpit-3-40-x-client-update.xml"};
        boolean repositoryAvailable = false;
        String[] stringArray = testFileRelPathNames;
        int n = testFileRelPathNames.length;
        int n2 = 0;
        while (n2 < n) {
            String testFileName = stringArray[n2];
            try {
                URL url = new URL(repoURI.toURL(), testFileName);
                try {
                    InputStream stream = url.openStream();
                    repositoryAvailable = true;
                    stream.close();
                    break;
                }
                catch (IOException stream) {
                }
            }
            catch (Exception e1) {
                LOGGER.error("Problem while generating test-URL for update repository availability check on the CockpitServer " + repoURI.toString(), (Throwable)e1);
            }
            ++n2;
        }
        return repositoryAvailable;
    }

    private static void removeAllCockpitServerRepositories() {
        try {
            ProvisioningUI provisioningUI = ProvSDKUIActivator.getDefault().getProvisioningUI();
            ProvisioningSession provisioningSession = provisioningUI.getSession();
            RepositoryTracker repositoryTracker = provisioningUI.getRepositoryTracker();
            URI[] p2KnownRepositories = repositoryTracker.getKnownRepositories(provisioningSession);
            ArrayList<URI> toBeRemoved = new ArrayList<URI>();
            URI[] uRIArray = p2KnownRepositories;
            int n = p2KnownRepositories.length;
            int n2 = 0;
            while (n2 < n) {
                URI repoURI = uRIArray[n2];
                if ("update".equalsIgnoreCase(repoURI.getScheme())) {
                    toBeRemoved.add(repoURI);
                }
                ++n2;
            }
            repositoryTracker.removeRepositories(toBeRemoved.toArray(new URI[toBeRemoved.size()]), provisioningSession);
        }
        catch (Exception e) {
            LOGGER.info("Unable to adjust the p2 repository to include connected Cockpit Servers.", (Throwable)e);
        }
    }
}

