/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter.helper;

import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.stringtools.StringPairKey;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.cockpit.interFace.declaration.frame.ModuleIDNameSpace;
import com.arcway.repository.cockpit.interFace.declaration.frame.modelelement.COTIDsModelElement;
import com.arcway.repository.cockpit.interFace.declaration.frame.modules.COTIDsModuleData;
import com.arcway.repository.cockpit.interFace.declaration.frame.plan.COTIDsPlan;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsProject;
import com.arcway.repository.cockpit.interFace.declaration.frame.reporttemplate.COTIDsReportOutputtemplate;
import com.arcway.repository.cockpit.interFace.declaration.frame.reporttemplate.COTIDsReportTemplate;
import com.arcway.repository.cockpit.interFace.declaration.frame.reporttemplate.COTIDsReportTemplateFolder;
import com.arcway.repository.cockpit.interFace.declaration.frame.section.COTIDsSection;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.COTIDsStakeholder;
import com.arcway.repository.cockpit.interFace.declaration.frame.stakeholder.COTIDsStakeholderRole;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.declaration.data.item.IDNameSpace;
import com.arcway.repository.lib.high.declaration.type.RepositoryInheritanceDeclarationItemID;
import com.arcway.repository.lib.high.declaration.type.attributeset.RepositoryAttributeSetTypeID;
import com.arcway.repository.lib.high.declaration.type.module.RepositoryModuleTypeID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.property.RepositoryPropertyTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.BaseRepositoryRelationTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import com.arcway.repository.lib.high.declaration.type.relationcontribution.RepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import java.util.ArrayList;
import java.util.HashMap;

public class RepositoryIDCreator {
    private static final String ABSTRACT_NATURALORDERSUPERTYPE_PREFIX = "abstract_natural_order_super_type_for";
    private static final String ABSTRACT_SUBSETSUPERTYPE_PREFIX = "abstract_subset_super_type_for";
    private static final String SEPARATOR = "_";
    private static HashMap globalNameSpaceIDCache = new HashMap();
    private IDCacheForNameSpace nameSpaceIDCache;

    private static Object readFromResultCache(HashMap map, Object key) {
        return map.get(key);
    }

    private static void addToResultCache(HashMap map, Object key, Object result) {
        map.put(key, result);
    }

    private static Object readFromResultCache(HashMap twoLevelMap, Object keyPart1, Object keyPart2) {
        Object result = null;
        HashMap secondLevelMap = (HashMap)twoLevelMap.get(keyPart1);
        if (secondLevelMap != null) {
            result = secondLevelMap.get(keyPart2);
        }
        return result;
    }

    private static void addToResultCache(HashMap twoLevelMap, Object keyPart1, Object keyPart2, Object result) {
        HashMap<Object, Object> secondLevelMap = (HashMap<Object, Object>)twoLevelMap.get(keyPart1);
        if (secondLevelMap == null) {
            secondLevelMap = new HashMap<Object, Object>();
            twoLevelMap.put(keyPart1, secondLevelMap);
        }
        secondLevelMap.put(keyPart2, result);
    }

    public RepositoryIDCreator(String moduleID, String repositoryModuleID) {
        assert (moduleID.indexOf(".") == -1);
        assert (repositoryModuleID.indexOf(".") == -1);
        StringPairKey cacheKey = new StringPairKey(moduleID, repositoryModuleID);
        this.nameSpaceIDCache = (IDCacheForNameSpace)globalNameSpaceIDCache.get(cacheKey);
        if (this.nameSpaceIDCache == null) {
            this.nameSpaceIDCache = new IDCacheForNameSpace();
            this.nameSpaceIDCache.moduleIDNameSpace = new ModuleIDNameSpace(new KeySegment(moduleID));
            this.nameSpaceIDCache.moduleTypeID = new RepositoryModuleTypeID(this.nameSpaceIDCache.moduleIDNameSpace, new KeySegment(repositoryModuleID));
            globalNameSpaceIDCache.put(cacheKey, this.nameSpaceIDCache);
        }
    }

    public IRepositoryModuleTypeID createRepositoryModuleTypeID() {
        return this.nameSpaceIDCache.moduleTypeID;
    }

    public IRepositoryModuleTypeID createRepositoryModuleTypeID(String repositoryModuleID) {
        IRepositoryModuleTypeID id = (IRepositoryModuleTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRepositoryModuleTypeID_String, repositoryModuleID);
        if (id == null) {
            id = new RepositoryModuleTypeID(this.nameSpaceIDCache.moduleIDNameSpace, new KeySegment(repositoryModuleID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRepositoryModuleTypeID_String, repositoryModuleID, id);
        }
        return id;
    }

    public RepositoryObjectTypeID createRepositoryObjectTypeID(RepositoryObjectTypeID superTypeID, String objectTypeID) {
        assert (objectTypeID.indexOf(".") == -1);
        return superTypeID.createSubTypeID(this.nameSpaceIDCache.moduleIDNameSpace, new KeySegment(objectTypeID));
    }

    public IRepositoryAttributeSetTypeID createRepositoryAttributeSetTypeID(RepositoryObjectTypeID objectTypeID, String attributeSetTypeID) {
        String keyPart2;
        assert (attributeSetTypeID.indexOf(".") == -1);
        String keyPart1 = objectTypeID.toCanonicalString();
        IRepositoryAttributeSetTypeID id = (IRepositoryAttributeSetTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRepositoryAttributeSetTypeID_RepositoryObjectTypeID_String, keyPart1, keyPart2 = attributeSetTypeID);
        if (id == null) {
            id = new RepositoryAttributeSetTypeID((RepositoryInheritanceDeclarationItemID)objectTypeID, new KeySegment(attributeSetTypeID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRepositoryAttributeSetTypeID_RepositoryObjectTypeID_String, keyPart1, keyPart2, id);
        }
        return id;
    }

    private IRepositoryPropertyTypeID createRepositoryPropertyTypeID(RepositoryObjectTypeID objectTypeID, String propertyTypeID) {
        assert (propertyTypeID.indexOf(".") == -1);
        return new RepositoryPropertyTypeID(objectTypeID, new KeySegment(propertyTypeID));
    }

    public RepositoryRelationTypeID createRepositoryRelationTypeID(RepositoryRelationTypeID superTypeRelationTypeID, String relationTypeID) {
        assert (relationTypeID.indexOf(".") == -1);
        return superTypeRelationTypeID.createSubTypeID(this.nameSpaceIDCache.moduleIDNameSpace, new KeySegment(relationTypeID));
    }

    public IRepositoryRelationContributionRoleID createRepositoryRelationContributionRoleID(RepositoryRelationTypeID relationTypeID, String relationContributionRoleID) {
        assert (relationContributionRoleID.indexOf(".") == -1);
        return new RepositoryRelationContributionRoleID(relationTypeID, new KeySegment(relationContributionRoleID));
    }

    private IRepositoryDataTypeID createRepositoryDataTypeID(RepositoryObjectTypeID objectTypeID, String attributeID) {
        return new RepositoryDataTypeID(this.nameSpaceIDCache.moduleIDNameSpace, objectTypeID, new KeySegment(attributeID));
    }

    public String createStringIDForAbstractNaturalOrderSuperType(String cockpitTypeID) {
        String id = (String)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createStringIDForAbstractNaturalOrderSuperType_String, cockpitTypeID);
        if (id == null) {
            id = "abstract_natural_order_super_type_for_" + cockpitTypeID.replace('.', '_');
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createStringIDForAbstractNaturalOrderSuperType_String, cockpitTypeID, id);
        }
        return id;
    }

    public String createStringIDForAbstractSubsetSuperType(String cockpitTypeID) {
        String id = (String)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createStringIDForAbstractSubsetSuperType_String, cockpitTypeID);
        if (id == null) {
            id = "abstract_subset_super_type_for_" + cockpitTypeID.replace('.', '_');
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createStringIDForAbstractSubsetSuperType_String, cockpitTypeID, id);
        }
        return id;
    }

    public RepositoryObjectTypeID createObjectTypeIDForRealType(String cockpitTypeID) {
        RepositoryObjectTypeID id = (RepositoryObjectTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createObjectTypeIDForRealType_String, cockpitTypeID);
        if (id == null) {
            id = this.createRepositoryObjectTypeID(COTIDsModuleData.OBJECT_TYPE_ID, RepositoryIDCreator.getCoreTypeID(cockpitTypeID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createObjectTypeIDForRealType_String, cockpitTypeID, id);
        }
        return id;
    }

    public RepositoryObjectTypeID createObjectTypeIDForAbstractNaturalOrderSuperType(String cockpitTypeID) {
        RepositoryObjectTypeID id = (RepositoryObjectTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createObjectTypeIDForAbstractNaturalOrderSuperType_String, cockpitTypeID);
        if (id == null) {
            id = this.createRepositoryObjectTypeID(COTIDsModuleData.OBJECT_TYPE_ID, this.createStringIDForAbstractNaturalOrderSuperType(cockpitTypeID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createObjectTypeIDForAbstractNaturalOrderSuperType_String, cockpitTypeID, id);
        }
        return id;
    }

    public RepositoryObjectTypeID createObjectTypeIDForAbstractSubsetSuperType(String cockpitTypeID) {
        RepositoryObjectTypeID id = (RepositoryObjectTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createObjectTypeIDForAbstractSubsetSuperType_String, cockpitTypeID);
        if (id == null) {
            id = this.createRepositoryObjectTypeID(COTIDsModuleData.OBJECT_TYPE_ID, this.createStringIDForAbstractSubsetSuperType(cockpitTypeID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createObjectTypeIDForAbstractSubsetSuperType_String, cockpitTypeID, id);
        }
        return id;
    }

    public static String getCoreTypeID(String fullCockpitTypeID) {
        String coreTypeID = fullCockpitTypeID.indexOf(".") != -1 ? fullCockpitTypeID.substring(fullCockpitTypeID.lastIndexOf(".") + 1) : fullCockpitTypeID;
        return coreTypeID;
    }

    public RepositoryRelationTypeID createRelationTypeID(String cockpitLinkTypeID) {
        RepositoryRelationTypeID id = (RepositoryRelationTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRelationTypeID_String, cockpitLinkTypeID);
        if (id == null) {
            id = BaseRepositoryRelationTypeID.RELATION_TYPE_ID;
            ArrayList segments = StringUtil.split((String)cockpitLinkTypeID, (char)'.');
            for (String segment : segments) {
                id = this.createRepositoryRelationTypeID(id, segment);
            }
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRelationTypeID_String, cockpitLinkTypeID, id);
        }
        return id;
    }

    public RepositoryRelationTypeID createRelationTypeID(RepositoryRelationTypeID superRelationTypeID, String cockpitLinkTypeID) {
        RepositoryRelationTypeID id = (RepositoryRelationTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRelationTypeID_String, cockpitLinkTypeID);
        if (id == null) {
            id = this.createRepositoryRelationTypeID(superRelationTypeID, cockpitLinkTypeID);
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRelationTypeID_String, cockpitLinkTypeID, id);
        }
        return id;
    }

    public IRepositoryRelationContributionRoleID createRelationContributionRoleID(String cockpitLinkTypeID, String roleID) {
        String keyPart1 = cockpitLinkTypeID;
        String keyPart2 = roleID;
        IRepositoryRelationContributionRoleID id = (IRepositoryRelationContributionRoleID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRelationContributionRoleID_String_String, keyPart1, keyPart2);
        if (id == null) {
            id = this.createRepositoryRelationContributionRoleID(this.createRelationTypeID(cockpitLinkTypeID), roleID);
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRelationContributionRoleID_String_String, keyPart1, keyPart2, id);
        }
        return id;
    }

    public IRepositoryRelationContributionRoleID createRelationContributionRoleID(RepositoryRelationTypeID superRelationTypeID, String cockpitLinkTypeID, String roleID) {
        String keyPart1 = cockpitLinkTypeID;
        String keyPart2 = roleID;
        IRepositoryRelationContributionRoleID id = (IRepositoryRelationContributionRoleID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createRelationContributionRoleID_String_String, keyPart1, keyPart2);
        if (id == null) {
            id = this.createRepositoryRelationContributionRoleID(this.createRelationTypeID(superRelationTypeID, cockpitLinkTypeID), roleID);
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createRelationContributionRoleID_String_String, keyPart1, keyPart2, id);
        }
        return id;
    }

    public IRepositoryPropertyTypeID createPropertyTypeIDForAttribute(RepositoryObjectTypeID objectTypeID, String attributeID) {
        String keyPart2;
        String keyPart1 = objectTypeID.toCanonicalString();
        IRepositoryPropertyTypeID id = (IRepositoryPropertyTypeID)RepositoryIDCreator.readFromResultCache(this.nameSpaceIDCache.createPropertyTypeIDForAttribute_RepositoryObjectTypeID_String, keyPart1, keyPart2 = attributeID);
        if (id == null) {
            id = this.createRepositoryPropertyTypeID(objectTypeID, RepositoryIDCreator.getCoreTypeID(attributeID));
            RepositoryIDCreator.addToResultCache(this.nameSpaceIDCache.createPropertyTypeIDForAttribute_RepositoryObjectTypeID_String, keyPart1, keyPart2, id);
        }
        return id;
    }

    public static IRepositoryObjectTypeID getRepositoryObjectTypeIDForFrameCockpitTypeID(String cockpitTypeID) {
        if (cockpitTypeID.equals("frame.project")) {
            return COTIDsProject.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals("com.arcway.cockpit.section")) {
            return COTIDsSection.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals("com.arcway.cockpit.plan")) {
            return COTIDsPlan.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals("com.arcway.cockpit.uniqueelement")) {
            return COTIDsModelElement.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals("com.arcway.cockpit.stakeholder")) {
            return COTIDsStakeholder.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals("com.arcway.cockpit.stakeholderrole")) {
            return COTIDsStakeholderRole.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)) {
            return COTIDsReportTemplateFolder.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE)) {
            return COTIDsReportTemplate.OBJECT_TYPE_ID;
        }
        if (cockpitTypeID.equals(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE)) {
            return COTIDsReportOutputtemplate.OBJECT_TYPE_ID;
        }
        return null;
    }

    private static class IDCacheForNameSpace {
        public IDNameSpace moduleIDNameSpace = null;
        public IRepositoryModuleTypeID moduleTypeID = null;
        public HashMap createRepositoryModuleTypeID_String = new HashMap();
        public HashMap createRepositoryAttributeSetTypeID_RepositoryObjectTypeID_String = new HashMap();
        public HashMap createStringIDForAbstractContainerType_String = new HashMap();
        public HashMap createStringIDForInvisibleContainerType_String_String = new HashMap();
        public HashMap createStringIDForAbstractNaturalOrderSuperType_String = new HashMap();
        public HashMap createStringIDForAbstractSubsetSuperType_String = new HashMap();
        public HashMap createObjectTypeIDForRealType_String = new HashMap();
        public HashMap createObjectTypeIDForAbstractContainerType_String = new HashMap();
        public HashMap createObjectTypeIDForAbstractNaturalOrderSuperType_String = new HashMap();
        public HashMap createObjectTypeIDForAbstractSubsetSuperType_String = new HashMap();
        public HashMap createObjectTypeIDForInvisibleContainerType_String_String = new HashMap();
        public HashMap createRelationTypeID_String = new HashMap();
        public HashMap createRelationContributionRoleID_String_String = new HashMap();
        public HashMap createPropertyTypeIDForAttribute_RepositoryObjectTypeID_String = new HashMap();
        public HashMap createDataTypeIDForDiscreteAttribute_RepositoryObjectTypeID_String = new HashMap();

        private IDCacheForNameSpace() {
        }
    }
}

